'use strict';

PROPERTY.Boolean           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // default_label
    // type
    // component_radio_list
    // component_btn_inheritance
    // state
    // state_inheritance
    // tab_parent_id
    this.init( dom_element );
};
PROPERTY.Boolean.prototype = {
    init                         : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.state                     = null;
        this.component_radio_list      = new COMPONENT.RadioList( dom_element );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.checkErrorWarning();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___clickOnRadioBtn           : function ( value ) {
        this.component_radio_list.clickOnRadioBtn( value );
        this.setStateInheritance( COMPONENT.CONST.BTN_STATE.OFF );
        this._computeState();
        this.updateView();
    },
    updateAllTemplatesCustomTags: function ( templates_properties ) {
        if ( !templates_properties ) {
            return;
        }
        var _size = templates_properties.length;
        var _current;
        for ( var i = 0; i < _size; i++ ) {
            _current = templates_properties[ i ];
            if ( _current.value === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT ) {
                _current.label = this.default_label;
            }
            else if ( _current.value === "0" ) {
                _current.label = _( 'element.false' );
            }
            else if ( _current.value === "1" ) {
                _current.label = _( 'element.true' );
            }
        }
        
    },
    //********************************************  GET / SET ***********************************************//
    ___unset                     : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser             : function ( value ) {
        if ( !value ) {
            if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.DEFAULT_BUTTON_LABEL;
            }
        }
        switch ( value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                this.clickOnRadioBtn( null, value );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.DEFAULT_BUTTON_LABEL:
                this.clickOnRadioBtn( null, PROPERTY.CONST.DEFAULT_BUTTON_LABEL );
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                if ( !this.state_inheritance ) {
                    this.clickOnBtnInheritance();
                }
                break;
            default:
                this.clickOnRadioBtn( null, value );
                break;
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    isDifferentValue             : function ( value1, value2 ) {
        if ( value1 === value2 ) {
            return false;
        }
        if ( value1 === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT && value2 === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            return false;
        }
        if ( value2 === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT && value1 === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
            return false;
        }
        return true;
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance       : function () {
        var _value = this.component_radio_list.getValue();
        if ( _value === PROPERTY.CONST.DEFAULT_BUTTON_LABEL && this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
        else {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this._computeState();
    },
    _computeState                : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var is_default_on      = this.component_radio_list.isDefaultOn();
        if ( this.is_override ) {
            if ( this.component_radio_list.getRadioButton( PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE ).isOn() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
            else if ( is_default_on ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
        }
        else if ( this.is_mass_change ) {
            _to_set     = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
                    if ( this.component_radio_list.getValue() !== PROPERTY.CONST.DEFAULT_BUTTON_LABEL ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    }
                    break;
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else {
            if ( is_default_on && !this.component_btn_inheritance.isSet() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
            else if ( is_default_on ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
            }
        }
        this.setState( _to_set );
    },
    _computeInheritedLabel       : function ( inherited_value ) {
        switch ( inherited_value ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                inherited_value = this.default_value;
                break;
            case "1":
                inherited_value = _( 'element.true' );
                break;
            case "0":
                inherited_value = _( 'element.false' );
                break;
            
        }
        return inherited_value;
    },
    updateWithTemplateSpecific   : function () {
        this.updateView();
    },
    //********************************************  VIEW    **********************************************************//
    ___updateView                : function () {
        switch ( this.getName() ) {
            case PROPERTY.CONST.NAME.SHELL_EXECUTION:
                var _status = this.component_radio_list.getValue() === '1' ? COMPONENT.CONST.TAG_INFORMATION.STATUS.IN_SHELL : COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE;
                this.tag_information.setStatus( _status );
                break;
            case PROPERTY.CONST.NAME.ENABLED:
                var _is_disabled = this.component_radio_list.getValue() === '0';
                if ( _is_disabled ) {
                    DOM.BodyService.getDomElement().classList.add( "shinken-current-element-is-disabled" );
                }
                else {
                    DOM.BodyService.getDomElement().classList.remove( "shinken-current-element-is-disabled" );
                }
                break;
        }
        this._computeLabelSelect();
        this.checkErrorWarning();
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal           : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.NONE;
        }
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.Boolean, PROPERTY.Interface );