'use strict';

PROPERTY.StringInput           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // type
    // component_input
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_problem
    // inherited_label
    // custom_selected
    // tab_parent_id
    // has_warning_value
    // has_error_value
    // timeout_compute_value
    // help_content
    this.init( dom_element );
};
PROPERTY.StringInput.prototype = {
    init: function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input           = new COMPONENT.Input( dom_element.querySelector( ".shinken-input" ), this, false );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.setIsProtected( SHINKEN.TOOLS.ENCRYPTION.isProtectedProperty( this.name ) ? PROPERTY.CONST.PROTECTED_STATUS.PROTECTED : PROPERTY.CONST.PROTECTED_STATUS.NONE );
        if ( this.getName() === PROPERTY.CONST.NAME.PREFIX ) {
            this.component_input.setExtraTooltip( _( "sync.extra_tooltip_rename_prefix" ) );
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askComputeAfterChange: function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        if ( this.state_inheritance ) {
            this.component_input.need_validation = true;
        }
        this.component_input.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange  : function ( args ) {
        if ( args[ 'validation_done' ] ) {
            this.setStateInheritance( !this.component_input.getValue() );
        }
        this._computeState();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    onFocus              : function () {
        if ( this.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED ) {
            this.component_input.dom_element.value = "";
        }
    },
    ___onFocusOut        : function () {
        var self = this;
        setTimeout( function () {
            if ( self.is_protected === PROPERTY.CONST.PROTECTED_STATUS.PROTECTED && !self.component_input.hasBeenChanged() ) {
                self.component_input.dom_element.value = self.component_input.original_value;
            }
        }, 500 );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance: function () {
        if ( this.state && this.component_btn_inheritance.getState() !== COMPONENT.CONST.BTN_STATE.INIT ) {
            return;
        }
        var _is_inheritable = !this.getValue();
        this.setStateInheritance( _is_inheritable );
        this.updateView();
    },
    ___updateView         : function () {
        this.component_input.updateView( this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON, true, false, this.component_btn_inheritance.isSet() );
    },
    _computeState         : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_override ) {
            if ( this.getValue() ) {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
            }
            else {
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            }
        }
        else if ( this.is_mass_change ) {
            _to_set     = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    break;
                default:
                    if ( this.getValue() ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    }
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.getValue() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    //********************************************  VALIDATION      **************************************************//
    computeErrorsSpecifics: function ( force_mass_change ) {
        this.component_input.validateValueInput();
        if ( this.state === PROPERTY.CONST.STATE_PROPERTY.INHERITANCE ) {
            this.component_input.setMessage();
        }
        this.component_input.setVisibilityCountersForParent( this.state !== PROPERTY.CONST.STATE_PROPERTY.INHERITANCE );
    },
    setErrorsSpecific     : function () {
        this.counter_temp_error   = 0;
        this.counter_temp_warning = 0;
    },
    //********************************************  SETTER GETTER   **************************************************//
    setStateProblem  : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem  : function () {
        return this.state_problem;
    },
    setIsProtected   : function ( to_set ) {
        this.is_protected = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'isProtected', this.is_protected );
            this.component_input.setIsProtected( this.is_protected );
        }
    },
    ___unset         : function () {
        this.setValueFromUser( "" );
        if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    this.component_input.setPlaceholder();
                    break;
                default:
                    this.component_input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                    break;
            }
        }
    },
    setValueFromUser : function ( value ) {
        this.component_input.setValueFromJs( value );
        this.askComputeAfterChange();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    getValueInherited: function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    getComponents    : function () {
        return [this.component_input];
    },
    //********************************************  INHERITANCE     **************************************************//
    updateWithTemplateSpecific: function () {
        this._computeState();
        this.component_input.need_validation = true;
        this.updateView();
    },
    cleanBeforeUpdate         : function () {
        this.component_input.setPlaceholder();
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal: function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            default:
                if ( this.is_protected && this.component_input.hasBeenChanged() ) {
                    return SHINKEN.TOOLS.STRING.b64Encode( this.getValue() );
                }
                return SHINKEN.TOOLS.STRING.trimExtented( this.getValue() );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInput, PROPERTY.Interface );