var MAX_ARGS_DFE   = 16;
var FORCED_TO_NULL = '[' + _( 'element.forced_empty' ) + ']';

App.DFE = (function ( self, Scope ) {
    "use strict";
    
    var IMPORT_KEY_DEFAULT_VALUE          = "default_value";
    var DFE_ARG_SEPARATOR_OPENNING        = "$(";
    var DFE_ARG_SEPARATOR_CLOSING         = ")$";
    var DFE_ARG_SEPARATOR_OPENNING_LENGTH = DFE_ARG_SEPARATOR_OPENNING.length;
    
    self._size                   = 0;
    self._duplicateSplittedValue = {};
    self._duplicateOutputValue   = {};
    self._group_dfe              = {};
    
    self._timerAskDFE;
    self._timerAskBuildHTMLCheckTab;
    
    self.init                  = function () {
    };
    self.getSplittedDataSize   = function ( key ) {
        return self._duplicateSplittedValue[ key ]._dfe_elem.length;
    };
    self.getSplittedData       = function ( key ) {
        return self._duplicateSplittedValue[ key ];
    };
    self.getSplittedDataUnique = function ( key ) {
        var _dfe_split = self.getSplittedData( key );
        var _to_return = [];
        if ( _dfe_split ) {
            if ( _dfe_split._messages.hasError() ) {
                _current           = _dfe_split._dfe_elem[ 0 ];
                _current._messages = _dfe_split._messages;
                _to_return.push( _current );
                return _to_return;
            }
            var _current;
            var _mapping = {};
            for ( var i = 0; i < _dfe_split._size; i++ ) {
                _current = _dfe_split._dfe_elem[ i ];
                if ( _current.is_duplicate && _mapping[ _current.key ] ) {
                    continue;
                }
                _to_return.push( _current );
                _mapping[ _current.key ] = true;
            }
        }
        return _to_return;
    };
    self.getDefaultArgsByCheck = function ( splited_dfe, check ) {
        var _to_return              = splited_dfe;
        _to_return.args_interpreted = jQuery.extend( true, [], splited_dfe.args );
        
        if ( check[ IMPORT_KEY_DEFAULT_VALUE ] ) {
            var propertyName            = (Object.keys( splited_dfe ).length !== 0) ? splited_dfe.property_name : '';
            var _default_value_splitted = _splitDFE( propertyName, check[ IMPORT_KEY_DEFAULT_VALUE ], true );
            
            var _validation = self.validateDefaultValueGetError( _default_value_splitted );
            if ( _default_value_splitted._messages.hasError() || _default_value_splitted._dfe_elem[ 0 ]._messages.hasError() ) {
                console.warn( "[_default_value_splitted 1]", "La valeur par défaut du check n'est pas valide.", check[ IMPORT_KEY_DEFAULT_VALUE ], check[ 'check_command' ] );
                return _to_return;
            }
            // TODO merge both conditions..
            if ( _validation._messages.hasError() ) {
                console.warn( "[_default_value_splitted 2]", "La valeur par défaut du check n'est pas valide.", check[ IMPORT_KEY_DEFAULT_VALUE ], check[ 'check_command' ] );
                return _to_return;
            }
            
            var listDefaultArgs     = _default_value_splitted._dfe_elem[ 0 ].args;
            var listDefaultArgsSize = listDefaultArgs.length;
            
            for ( var k = 0; k < listDefaultArgsSize && k < MAX_ARGS_DFE; k++ ) {
                var current_arg = splited_dfe.args[ k ];
                if ( !current_arg ) {
                    var arg                          = listDefaultArgs[ k ] || '';
                    var _splitted_data               = MANAGER.__instance_macro_distributor.splitCommand( arg );
                    var _label_final                 = MANAGER.__instance_macro_distributor.buildLabel( _splitted_data, true );
                    _to_return.args[ k ]             = arg;
                    _to_return.args_interpreted[ k ] = _label_final;
                }
            }
        }
        return _to_return;
    };
    
    function _analyseAndRemoveCommaInPara ( propertyValue, _indexes_comma, _size_indexes_comma ) {
        var _to_return            = {};
        var _messages             = new OBJECT.Messages();
        var _indexes_openning_arg = SHINKEN.TOOLS.STRING.indexesOf( propertyValue, DFE_ARG_SEPARATOR_OPENNING );
        var _indexes_closing_arg  = SHINKEN.TOOLS.STRING.indexesOf( propertyValue, DFE_ARG_SEPARATOR_CLOSING );
        var _size_opening_arg     = _indexes_openning_arg.length;
        var _size_closing_arg     = _indexes_closing_arg.length;
        
        var _current_index;
        if ( _size_opening_arg !== _size_closing_arg ) {
            _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_odd_separator' ) );
        }
        else {
            for ( var i = 0; i < _size_opening_arg; i++ ) {
                var _index_openning_arg = _indexes_openning_arg[ i ];
                var _index_closing_arg  = _indexes_closing_arg[ i ];
                
                if ( i > 0 && _index_openning_arg - _indexes_closing_arg[ i - 1 ] < 2 ) {
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, Scope.format( _( 'element.tooltip_dfe_incomplete_tag' ), (i + 1) ) );
                    break;
                }
                else if ( _index_openning_arg < _index_closing_arg ) {
                    for ( var j = _size_indexes_comma - 1; j >= 0; j-- ) {
                        _current_index = _indexes_comma[ j ];
                        if ( _current_index > _index_openning_arg && _current_index < _index_closing_arg ) {
                            _indexes_comma.splice( j, 1 );
                            _size_indexes_comma--;
                        }
                    }
                }
                else {
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, Scope.format( _( 'element.tooltip_dfe_reverse_tag' ), (i + 1) ) );
                    break;
                }
            }
        }
        _to_return._indexes_comma = _indexes_comma;
        _to_return._messages      = _messages;
        return _to_return;
    }
    
    function _splittedKeyParam ( dfe, index, is_default ) {
        var _indexes_openning_arg = SHINKEN.TOOLS.STRING.indexesOf( dfe, DFE_ARG_SEPARATOR_OPENNING );
        
        var _temp = SHINKEN.TOOLS.STRING.splitWithIndexes( dfe, _indexes_openning_arg, DFE_ARG_SEPARATOR_OPENNING_LENGTH );
        
        var _size = _temp.length;
        
        for ( var i = 0; i < _size; i++ ) {
            _temp[ i ] = _temp[ i ].split( DFE_ARG_SEPARATOR_CLOSING );
        }
        
        var _to_return        = {};
        _to_return.key        = SHINKEN.TOOLS.STRING.trim( _temp[ 0 ][ 0 ] );
        _to_return.args       = [];
        _to_return._messages  = new OBJECT.Messages();
        _to_return._size_args = _size - 1;
        
        if ( _to_return.key && is_default ) {
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, App.Scope.format( _( 'element.tooltip_default_arf_dfe_with_key' ), (index + 1) ) );
        }
        else if ( !_to_return.key && !is_default ) {
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, App.Scope.format( _( 'element.tooltip_dfe_empty_key' ), (index + 1) ) );
        }
        
        var hasUnknownValue   = false;
        var hasBackToLineChar = false;
        var getUnknownValue   = [];
        
        for ( var i = 1; i < _size; i++ ) {
            _to_return.args[ i - 1 ] = _temp[ i ][ 0 ];
            if ( _temp[ i ][ 1 ] && !SHINKEN.TOOLS.STRING.isEmpty( _temp[ i ][ 1 ] ) ) {
                // Unknown values between some $(ARG)$, can be a comma (,) missing..
                hasUnknownValue = true;
                getUnknownValue.push( '<span class=\'text-warning\'>' + _temp[ i ][ 1 ] + '</span>' );
            }
            else if ( _temp[ i ][ 1 ] && SHINKEN.TOOLS.STRING.containsCharCode( _temp[ i ][ 1 ], SHINKEN.TOOLS.STRING.CONST.CHAR_CODE_BACK_TO_LINE ) ) {
                // Unknown values between some $(ARG)$, can be a comma (,) missing..
                hasBackToLineChar = true;
            }
            else {
                var _number$ = SHINKEN.TOOLS.STRING.getNumberOccurence( _temp[ i ][ 0 ], '$' );
                if ( _number$ === 1 ) {
                    _to_return._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, App.Scope.format( _( 'element.tooltip_dfe_unpair_$_number' ), '<span class="text-warning">' + _temp[ i ][ 0 ] + '</span>' ) );
                }
                else if ( _number$ % 2 ) {
                    _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, App.Scope.format( _( 'element.tooltip_dfe_unpair_$_number_2' ), '<span class="text-warning">' + _temp[ i ][ 0 ] + '</span>' ) );
                }
            }
        }
        
        if ( hasUnknownValue ) {
            var plural = (getUnknownValue.length > 1) ? 's' : '';
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, App.Scope.format( _( 'element.tooltip_dfe_unknown_value' + plural ), getUnknownValue.join( ' , ' ) ) );
        }
        if ( hasBackToLineChar ) {
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_back_to_line_before_comma' ) );
        }
        return _to_return;
    }
    
    function _setDuplicateKey ( listDfe ) {
        var _values = [];
        var _current;
        var _size   = listDfe.length;
        for ( var i = 0; i < _size; i++ ) {
            _current     = listDfe[ i ];
            _values[ i ] = _current.key;
            for ( var j = 0; j < i; j++ ) {
                if ( _values[ j ] === _current.key ) {
                    _current.is_duplicate     = true;
                    listDfe[ j ].is_duplicate = true;
                    break;
                }
            }
        }
        return listDfe;
    }
    
    self.splitDFE = function ( propertyName, propertyValue, is_default ) {
        return _splitDFE( propertyName, propertyValue, is_default );
    };
    
    function _splitDFE ( propertyName, propertyValue, is_default ) {
        var _to_return = {};
        
        if ( propertyValue === 'null' || propertyValue === FORCED_TO_NULL ) {
            propertyValue = '';
        }
        
        var _indexes_comma      = SHINKEN.TOOLS.STRING.indexesOf( propertyValue, ',' );
        var _size_indexes_comma = _indexes_comma.length;
        
        var _temp_return;
        _temp_return         = _analyseAndRemoveCommaInPara( propertyValue, _indexes_comma, _size_indexes_comma );
        _to_return._messages = _temp_return._messages;
        _indexes_comma       = _temp_return._indexes_comma;
        var _dfe_elem        = SHINKEN.TOOLS.STRING.splitWithIndexes( propertyValue, _indexes_comma );
        
        _to_return._size = _dfe_elem.length;
        
        if ( is_default && _to_return._size > 1 ) {
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_default_arf_dfe_multi' ) );
        }
        if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( propertyName ) ) {
            _to_return._size = 1;
        }
        for ( var i = 0; i < _to_return._size; i++ ) {
            _dfe_elem[ i ]               = _splittedKeyParam( _dfe_elem[ i ], i, is_default );
            _dfe_elem[ i ].property_name = propertyName;
        }
        
        _dfe_elem = _setDuplicateKey( _dfe_elem );
        
        _to_return._dfe_elem = _dfe_elem;
        
        return _to_return;
    }
    
    self.getMessageDeletedElements = function ( new_split, old_split, check_ids ) {
        var _keys_new = SHINKEN.TOOLS.ARRAY.extractKey( new_split, 'key' );
        var _keys_old = SHINKEN.TOOLS.ARRAY.extractKey( old_split, 'key' );
        _keys_new.sort();
        _keys_old.sort();
        var _to_return  = [];
        var _current_check;
        var _size_check = check_ids.length;
        for ( var i = 0, _size_i = _keys_old.length; i < _size_i; i++ ) {
            if ( !SHINKEN.TOOLS.ARRAY.contains( _keys_new, _keys_old[ i ] ) ) {
                var _key_escape = SHINKEN.TOOLS.STRING.cleanXss(_keys_old[ i ]);
                var _html_name = '';
                for ( var j = 0; j < _size_check; j++ ) {
                    _current_check = MANAGER.__instance_element_distributor.getElement( "core-service-" + check_ids[ j ] );
                    _html_name += "<li class='shinken-font-xs'>" + _current_check.getName().replace( '$KEY$',  _key_escape) + "</li>";
                }
                _to_return.push( new OBJECT.Message( COMPONENT.CONST.STATUS.BEWARE, '<span class="shinken-between-bracket shinken-icon-error">' + _key_escape + "</span><ul>" + _html_name + "</ul>" ) );
            }
        }
        var _size_deleted = _to_return.length;
        if ( !_size_deleted ) {
            return null;
        }
        return _to_return;
    };
    self.setOutputDFE              = function ( splitted, name, template_name ) {
        return _setOutputDFE( splitted, name, template_name );
    };
    
    function _setOutputDFE ( splitted, name, template_name ) {
        var _current;
        
        var _to_return = new OBJECT.Messages();
        
        if ( splitted._messages.hasError() ) {
            _to_return = splitted._messages;
        }
        else {
            if ( splitted._messages.hasWarning() ) {
                _to_return = splitted._messages;
            }
            for ( var i = 0; i < splitted._size; i++ ) {
                _current = splitted._dfe_elem[ i ];
                
                if ( _current._messages.hasError() ) {
                    _to_return.addMessages( _current._messages.messages_error );
                }
                else if ( _current._messages.hasWarning() ) {
                    _to_return.addMessages( _current._messages.messages_warning );
                    
                }
            }
        }
        
        _to_return.message = _to_return.buildMessage( false, template_name );
        if ( name ) {
            self._duplicateOutputValue[ name ] = _to_return;
        }
        
        return _to_return;
    }
    
    self.validatorDFE = function ( splitted ) {
        return _validatorDFE( splitted );
    };
    
    function _validatorDFE ( splitted ) {
        var number_empty_args;
        var _current;
        
        var _to_return = splitted;
        var _value;
        
        
        for ( var i = 0; i < _to_return._size; i++ ) {
            _current          = _to_return._dfe_elem[ i ];
            number_empty_args = 0;
            if ( SHINKEN.TOOLS.ENCRYPTION.isProtectedField( _current.property_name ) ) {
                _current.is_dfe_protected = true;
                _current._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, _( 'element.tooltip_dfe_encrypted_data_has_value' ) );
                continue;
            }
            _value = _current.key.replace( PROPERTY.CONST.VALIDATOR.REGEXS.key_data, "" );
            if ( _value.match( PROPERTY.CONST.VALIDATOR.REGEXS.restrict_check ) ) {
                _current._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format( PROPERTY.CONST.VALIDATOR.MESSAGES.forbidden, ' ~!%^&*\"\'|<>?,()=+' ) );
            }
            else if ( _value.match( '[$]' ) ) {
                _current._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_dollar' ) );
            }
            for ( var j = 0; j < _current._size_args; j++ ) {
                if ( SHINKEN.TOOLS.STRING.isEmpty( _current.args[ j ] ) ) {
                    number_empty_args++;
                }
                
            }
            if ( number_empty_args ) {
                _current._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, number_empty_args === 1 ? _( 'element.tooltip_dfe_empty_arg' ) : _( 'element.tooltip_dfe_empty_args' ) );
            }
            
            if ( _current.is_duplicate ) {
                _current._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_same_key' ) );
            }
        }
        
        
        return _to_return;
    }
    
    self.validateDefaultValueGetError = function ( _split ) {
        
        var _to_return = { valid_type: COMPONENT.CONST.STATUS.NONE, _messages: new OBJECT.Messages() };
        
        var _current     = _split._dfe_elem[ 0 ];
        var _args_length = _current._size_args;
        
        var number_empty_args = 0;
        
        if ( _split._messages.hasError() ) {
            
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages  = _split._messages;
        }
        else if ( _split._size > 1 ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_check_comma_not_allowed' ) );
        }
        else if ( (_current.key && _args_length) || _current.error ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'element.tooltip_dfe_check_not_between_tag' ) );
        }
        else if ( _current._messages.hasError() ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages  = _current._messages;
        }
        else if ( _split._messages.hasWarning() ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.ERROR;
            _to_return._messages  = _split._messages;
        }
        else if ( _current.key ) {
            _to_return.valid_type = COMPONENT.CONST.STATUS.WARNING;
            _to_return._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, _( 'element.tooltip_dfe_check_not_between_tag' ) );
        }
        else {
            number_empty_args = 0;
            for ( var i = 0; i < _args_length; i++ ) {
                if ( !_current.args[ i ] ) {
                    number_empty_args++;
                }
            }
            if ( number_empty_args ) {
                _to_return.valid_type = COMPONENT.CONST.STATUS.WARNING;
                var _message          = number_empty_args === 1 ? _( 'element.tooltip_dfe_empty_arg' ) : _( 'element.tooltip_dfe_empty_args' );
                _to_return._messages.addMessage( COMPONENT.CONST.STATUS.WARNING, _message );
            }
        }
        
        return _to_return;
    };
    
    self.getKey = function ( v ) {
        v = (v) ? v : ''; // Default
        v = v.replace( /\s/g, '' );
        // Some special data start with _HOST, _SERVICE and _CONTACT
        v = v.replace( /^(\$_SERVICE|\$_HOST|\$_CONTACT)/gi, '' );
        v = v.replace( /\$/g, '' );
        
        if ( v[ 0 ] != '_' ) {
            v = '_' + v;
        }
        return cleanString( v );
    };
    
    function cleanString ( val ) {
        val     = val + ''; // Convert in string :)
        var exp = (/([^a-z0-9\-_])/gi);
        return val.replace( exp, '' ).toUpperCase();
    }
    
    return self;
})( App.DFE || {}, App.Scope || {} );
