'use strict';

SOURCE.IpRanges           = function () {
    //list_ranges;
    //list_mapping_id;
    //is_single_display;
};
SOURCE.IpRanges.prototype = {
    reset         : function () {
        this.list_ranges     = [];
        this.list_mapping_id = {};
    },
    init          : function ( datas, is_single_display ) {
        this.is_single_display = is_single_display;
        this.reset();
        for ( var i = 0, _size = datas.length; i < _size; i++ ) {
            this.addRangeInList( datas[ i ] );
        }
    },
    addRangeInList: function ( data ) {
        var _id                     = data[ SOURCE.CONST.RANGE.ID ];
        var _number                 = this.list_ranges.push( new SOURCE.Range( data, this.is_single_display ) );
        this.list_mapping_id[ _id ] = _number - 1;
        return this.getRangeById( _id );
    },
    updateData    : function ( datas ) {
        var _id;
        var _current;
        var _range;
        var _size = datas.length;
        
        for ( var i = 0; i < this.list_ranges.length; i++ ) {
            this.list_ranges[ i ].is_found = false;
        }
        
        for ( var i = 0; i < _size; i++ ) {
            _current = datas[ i ];
            _id      = _current[ SOURCE.CONST.RANGE.ID ];
            _range   = this.getRangeById( _id );
            if ( !_range ) {
                _range = new SOURCE.Range( _current, this.is_single_display );
                this.list_ranges.push( _range );
                this.list_ranges = SHINKEN.TOOLS.ARRAY.sortArray( this.list_ranges, 'current_name' );
                this.updateMapping();
                _range.createDomFromTemplate( this.list_mapping_id[ _id ] );
                _range.loadDomElements();
            }
            _range.is_found = true;
            _range.updateData( _current );
        }
        
        for ( var i = this.list_ranges.length - 1; i >= 0; i-- ) {
            if ( !this.list_ranges[ i ].is_found ) {
                this.list_ranges[ i ].remove();
                this.list_ranges.splice( i, 1 );
                this.updateMapping();
            }
        }
    },
    updateMapping : function () {
        this.list_mapping_id = {};
        for ( var i = 0, _size_i = this.list_ranges.length; i < _size_i; i++ ) {
            this.list_mapping_id[ this.list_ranges[ i ].getId() ] = i;
        }
    },
    getRangeById  : function ( id ) {
        var _index = this.list_mapping_id[ id ];
        
        if ( _index === undefined ) {
            console.warn( "[getRangeById]", "id not found need to create object" );
        }
        return this.list_ranges[ _index ];
    },
    getNbEnabled  : function () {
        var _to_return = 0;
        if ( this.list_ranges ) {
            for ( var i = 0, _size_i = this.list_ranges.length; i < _size_i; i++ ) {
                if ( this.list_ranges[ i ].isEnabled() ) {
                    _to_return++;
                }
            }
        }
        return _to_return;
    }
};