//priority 10
var CLIPBOARD_SERVICE = (function ( self ) {
    "use strict";
    self.dom_textarea     = null;
    self.dom_parent       = null;
    self.dom_button       = null;
    self.dom_text_to_copy = null;
    
    self.TYPE      = {};
    self.TYPE.TEXT = 'text';
    self.TYPE.HTML = 'html';
    
    self.setContent       = function ( dom_element, type ) {
        initDomElement( dom_element );
        if ( !self.dom_parent || !self.dom_text_to_copy ) {
            displayResult( false );
            return;
        }
        var _value;
        
        switch ( type ) {
            case self.TYPE.TEXT:
                _value = DOM.Service.getInnerText( self.dom_text_to_copy );
                break;
            case self.TYPE.HTML:
                _value = self.dom_text_to_copy.outerHTML;
                break;
        }
        
        setValueTextArea( _value );
        self.dom_textarea.select();
        var status = false;
        try {
            status = document.execCommand( 'copy' );
            displayResult( status );
            setValueTextArea( '' );
        }
        catch ( err ) {
            console.log( 'Unable to copy.' );
        }
    };
    self.buildHtmlButtons = function ( hasCopyButton, hasEditButton ) {
        var table_buttons = DOM.Service.createElement( "table", { class: "shinken-copy-buttons-container" } );
        var line_buttons  = DOM.Service.createElement( "tr", {} );
        
        if ( hasCopyButton ) {
            var button_copy_cell            = DOM.Service.createElement( "td", { class: "shinken-btn-copy-cell" } );
            var button_copy                 = DOM.Service.createElement( "td", {
                class             : "shinken-btn-copy shinken-btn-copy-text",
                onclick           : 'CLIPBOARD_SERVICE.setContent(this, CLIPBOARD_SERVICE.TYPE.TEXT)',
                'data-status-copy': '0',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_text_copy' )
            } );
            var icon_button_copy            = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinicon shinicon-copy" } );
            var success_message_button_copy = DOM.Service.createElement( "span", { class: "shinken-copy-success-message" }, _( 'copy_service.copySuccess' ) );
            var error_message_button_copy   = DOM.Service.createElement( "span", { class: "shinken-copy-error-message" }, _( 'copy_service.copyFail' ) );
            
            button_copy.appendChild( icon_button_copy );
            button_copy.appendChild( success_message_button_copy );
            button_copy.appendChild( error_message_button_copy );
            button_copy_cell.appendChild( button_copy );
            line_buttons.appendChild( button_copy_cell );
        }
        if ( hasEditButton ) {
            var button_edit_cell = DOM.Service.createElement( "td", { class: "shinken-btn-edit-cell" } );
            var button_edit      = DOM.Service.createElement( "td", {
                class             : "shinken-btn-copy",
                onclick           : 'MANAGER.EventManager.clickOnPaste(event)',
                'data-status-copy': '0',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_edition' )
            } );
            var icon_button_edit = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinken-icons-url shinken-icons-url-write" } );
            
            button_edit.appendChild( icon_button_edit );
            button_edit_cell.appendChild( button_edit );
            line_buttons.appendChild( button_edit_cell );
        }
        table_buttons.appendChild( line_buttons );
        return table_buttons;
    };
    init();
    
    //private
    function init () {
        createDomTextArea();
    }
    
    function createDomTextArea () {
        self.dom_textarea    = document.createElement( 'textarea' );
        self.dom_textarea.id = 'id-shinken-copy-clipboard-container';
        var _body            = document.querySelector( 'body' );
        _body.appendChild( self.dom_textarea );
    }
    
    function initDomElement ( dom_element ) {
        setDomButton( dom_element );
        self.dom_parent = findParentElementWithClass( dom_element, "shinken-parent-text-to-copy", 5 );
        if ( !self.dom_parent ) {
            return;
        }
        self.dom_text_to_copy = self.dom_parent.querySelector( ".shinken-text-to-copy" );
    }
    
    function setDomButton ( to_set ) {
        self.dom_button = to_set;
    }
    
    function setValueTextArea ( to_set ) {
        self.dom_textarea.value = to_set;
    }
    
    
    function displayResult ( status ) {
        self.dom_button.dataset[ 'statusCopy' ] = status ? '1' : '2';
        self.dom_button.classList.toggle( "IE-PATCH" );
        
        var _tmp_button = self.dom_button;
        setTimeout( function () {
            _tmp_button.dataset[ 'statusCopy' ] = '0';
            _tmp_button.classList.toggle( "IE-PATCH" );
        }, 2000 );
    }
    
    function findParentElementWithClass ( element, class_to_find, deepLimit ) {
        if ( !element ) {
            return null;
        }
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( element.classList.contains( class_to_find ) ) {
            return element;
        }
        deepLimit--;
        return findParentElementWithClass( element.parentElement, class_to_find, deepLimit );
    }
    
    return self;
    
})( {} );