//__lib__ lib_external
'use strict';

WINDOW.Element           = function ( name, dom_element, is_menu ) {
    //id
    //dom_element_target
    //counters
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.Element.prototype = {
    init                      : function () {
        this.initDomElement();
        if ( this.is_menu ){
            var _dom_element_counters = this.dom_element.querySelectorAll( '.shinken-counter' );
            this.counters = {};
            var _current;
            for ( var i = 0, _size_i = _dom_element_counters.length; i < _size_i; i++ ) {
                _current = _dom_element_counters[i];
                this.counters[_current.dataset.counterType] = new SHINKEN.OBJECT.Counter();
                this.counters[_current.dataset.counterType].init(_current);
            }
        }
        else {
            this.initCounters();
        }
    },
    initDomElement            : function () {
        this.id                 = this.dom_element.getAttribute( 'id' );
        if ( this.is_menu ){
            return;
        }
        if ( this.dom_element.classList.contains("shinken-active")){
            this.is_active = true;
        }
        this.dom_element_target = document.getElementById( this.id + '-target' );
        if ( !this.dom_element_target ){
            console.warn("[LA STRUCTURE HTML des windows n'est pas correcte]", this.id, this.id + '-target  ==> not found'   );
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    getName                   : function () {
        return this.name;
    },
    getID                     : function () {
        return this.id;
    },
    setHasRequired            : function ( to_set ) {
        if ( to_set ) {
            this.dom_element.querySelector( '.shinken-required-field' ).classList.remove( 'shinken-hidden' );
        }
    },
    setActive                 : function ( to_set ) {
        this.is_active = to_set;
        if ( this.is_active ) {
            this.dom_element.classList.add( 'shinken-active' );
            this.dom_element_target.classList.remove( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
            this.dom_element_target.classList.add( 'shinken-hidden' );
        }
    },
    hasProperties : function () {
        return false;
    },
    //********************************************  COUNTER MENU   **************************************************//
    updateCounter         : function ( name, value ) {
        this.counters[name].update("counter", value);
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.Element, SHINKEN.OBJECT.CounterInterface );

WINDOW.ElementWithProperties           = function ( name, dom_element, is_menu ) {
    //id
    //dom_element_target
    //counters
    this.name           = name;
    this.dom_element    = dom_element;
    this.is_menu        = !!is_menu;
    this.init();
};
WINDOW.ElementWithProperties.prototype = {
    hasProperties: function () {
        return true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementWithProperties, WINDOW.Element );