/*
 * Copyright (C) 2017:
 *     Gabes Jean, j.gabes@shinken-solutions.com
 */

var COUNTERS = {
    SELECT  : "select",
    CHANGE  : "change",
    NEW     : "new",
    PROPOSED: "proposed"
};

var ACTIONS = {
    NONE          : "DEFAULT",
    ENABLE        : "enable",
    DISABLE       : "disable",
    IMPORT        : "import",
    CHANGES       : 'changes',
    DELETE        : "delete",
    CLONE         : "clone",
    SUBMIT        : "submit",
    UNLOCK        : "unlock",
    APPLY         : "apply",
    REJECT        : "reject",
    CREATE_FROM   : "create_from",
    MASSIVE_CHANGE: "massive_change"
};

var MSG_TYPE_ERROR           = "alert-error";
var MSG_TYPE_WARNING         = "warning";
var MAX_ELEMENT_FOR_ANALYZER = 4096;

var __nb_action_done = 0;
var __KO_msg         = [];

// Massive disable of actions buttons on the list when we are launching something
// just look at what to disable, save previous properties to put them back when we will reenable them
function disable_all_elements_button_menu () {
    // Be sure to disable the fact that the user can get out the page before we did finish
    __massive_action_in_progress = true;
    var btns                     = $( '.btn-elements-left-menu' );
    
    for ( var i = 0; i < btns.length; i++ ) {
        var btn = $( btns[ i ] );
        // Save href, and disable it
        btn.attr( 'prev-href', btn.attr( 'href' ) );
        btn.attr( 'href', '#' );
        // Look if the button was already disabled Before the action, so keep this
        if ( btn.hasClass( 'disabled' ) ) {
            btn.attr( 'previous-disabled', '1' );
        }
        else {
            btn.attr( 'previous-disabled', '0' );
            btn.addClass( 'disabled' );
        }
    }
}

// The inverse, put back all properties
// Note: do not remove disabled if the button was already disabled before
function renable_all_elements_button_menu () {
    if ( !__massive_action_in_progress ) {
        return;
    }
    __massive_action_in_progress = false;
    
    var btns = $( '.btn-elements-left-menu' );
    for ( var i = 0; i < btns.length; i++ ) {
        var btn = $( btns[ i ] );
        // Manage to get back href thing
        btn.attr( 'href', btn.attr( 'prev-href' ) );
        btn.attr( 'prev-href', null ); // remove this data
        if ( btn.attr( 'previous-disabled' ) === '0' ) {
            btn.removeClass( 'disabled' );
        }
        btn.attr( 'previous-disabled', null );
    }
}

function form_success ( display_log_time ) {
    if ( typeof display_log_time === 'undefined' ) {
        display_log_time = 1000;
    }
    renable_all_elements_button_menu();
    // Update the menu values if possible, to show the user that it did change things
    ask_menu_update();
    
    if ( display_log_time !== 0 ) {
        var saving_log_msg = _( 'element.action_succeed' );
        saving_log_msg += ' ' + _( 'element.will_redirected' );
        
        show_saving_log( saving_log_msg, '', 'alert-success', false );
    }
    
    setTimeout( "location.reload(true);", display_log_time );
}

function form_error ( data, action ) {
    renable_all_elements_button_menu();
    _select_action();
    // Update the menu values if possible, to show the user that it did change things
    ask_menu_update();
    var _text = data.statusText;
    if ( data.status ) {
        _text = data.status + ' ' + data.statusText;
    }
    $( '#elements-progress-bar' ).css( 'width', '0%' );
    $( '#spinner-mass-action' ).empty();
    if ( data.text ) {
        _text = data.text;
        show_saving_log( SHINKEN.TOOLS.STRING.format( _text ), '', 'alert-error', true );
    }
    else {
        show_saving_log( SHINKEN.TOOLS.STRING.format( _( 'element.action_fail' ), _( 'mass-actions.' + action ), _text ), '', 'alert-error', true );
    }
}

///========================== LINE SELECTED UPDATE ====================================================================
function select_all () {
    var _all_row = $( '.shinken-element-line' );
    for ( var i = 0; i < _all_row.length; i++ ) {
        var _row = $( _all_row[ i ] );
        _row.data( "selected", 1 );
        var _checkbox = _row.find( ':first .changes-checkbox' );
        _checkbox.prop( 'checked', true );
    }
    _select_action();
}

function deselect_all () {
    $( '#all-changes-checkbox' ).attr( 'checked', false );
    
    var _all_row = $( '.shinken-element-line' );
    for ( var i = 0; i < _all_row.length; i++ ) {
        var _row = $( _all_row[ i ] );
        _row.data( "selected", 0 );
        var _checkbox = _row.find( ':first .changes-checkbox' );
        _checkbox.prop( 'checked', false );
    }
    _select_action();
}

function _select_action () {
    var ret                = _count_available_action();
    var _lines_by_action   = ret[ 0 ];
    var _count_line_select = ret[ 1 ];
    CONTROLLER.List.updateMassActonCountSelect( _lines_by_action );
    update_selected_count( _count_line_select );
    
    // The launch analyze button (host page) should be update (disable or not)
    // when the number of lines selects changes
    var _nb_selected_lines = _count_line_select.select - _count_line_select.proposed;
    update_launch_analyze_button( _nb_selected_lines );
}

function _count_available_action () {
    var _count_line_select                  = {};
    _count_line_select[ COUNTERS.SELECT ]   = 0;
    _count_line_select[ COUNTERS.CHANGE ]   = 0;
    _count_line_select[ COUNTERS.NEW ]      = 0;
    _count_line_select[ COUNTERS.PROPOSED ] = 0;
    
    var _lines_by_action                       = {};
    _lines_by_action[ ACTIONS.ENABLE ]         = [];
    _lines_by_action[ ACTIONS.DISABLE ]        = [];
    _lines_by_action[ ACTIONS.IMPORT ]         = [];
    _lines_by_action[ ACTIONS.CHANGES ]        = [];
    _lines_by_action[ ACTIONS.DELETE ]         = [];
    _lines_by_action[ ACTIONS.CLONE ]          = [];
    _lines_by_action[ ACTIONS.SUBMIT ]         = [];
    _lines_by_action[ ACTIONS.UNLOCK ]         = [];
    _lines_by_action[ ACTIONS.APPLY ]          = [];
    _lines_by_action[ ACTIONS.REJECT ]         = [];
    _lines_by_action[ ACTIONS.CREATE_FROM ]    = [];
    _lines_by_action[ ACTIONS.MASSIVE_CHANGE ] = [];
    
    var _is_editable;
    var _is_proposed;
    var _is_validated;
    var _is_submittable;
    var _is_new;
    var _is_change;
    var _is_enable;
    var _item_type;
    var _has_staging;
    var _all_lines = $( '.shinken-element-line' );
    var $_line;
    
    for ( var i = 0; i < _all_lines.length; i++ ) {
        $_line = $( _all_lines[ i ] );
        if ( $_line.data( 'selected' ) !== 1 ) {
            $_line.removeClass( 'element-selected' );
            continue;
        }
        $_line.addClass( 'element-selected' );
        
        _is_editable    = $_line.data( 'can-edit' ) === 1;
        _is_proposed    = $_line.hasClass( 'work-area-proposed' );
        _is_validated   = $_line.hasClass( 'work-area-validated' );
        _is_submittable = $_line.hasClass( "work-area-can-submit" );
        _is_deleted     = $_line.data( 'item-work-last-action' ) === "delete";
        _is_enable      = $_line.data( 'status' ) === 1;
        _is_new         = $_line.data( 'item-state' ) === 'new';
        _is_change      = $_line.data( 'is-change' ) === 1;
        _item_type      = $_line.data( 'item-type' );
        _has_staging    = $_line.data( 'item-work-last-action' ) !== 'new';

        
        _count_line_select[ COUNTERS.SELECT ]++;
        
        if ( _item_type === 'contacts' && !MANAGER.__instance_element_distributor.current_user.is_admin ) {
            // if a SI admin select a contact, he can do nothing by mass actions, only on his account
            return [ _lines_by_action, _count_line_select ];
        }
        
        if ( _is_change && !_is_deleted ) {
            _count_line_select[ COUNTERS.CHANGE ]++;
        }
        if ( _is_proposed ) {
            _count_line_select[ COUNTERS.PROPOSED ]++;
        }
        
        if ( _is_new ) {
            _count_line_select[ COUNTERS.NEW ]++;
            _lines_by_action[ ACTIONS.IMPORT ].push( $_line );
        }
        else {
            _lines_by_action[ ACTIONS.CREATE_FROM ].push( $_line );
            if ( !_is_editable ) {
                continue;
            }
            _lines_by_action[ ACTIONS.CLONE ].push( $_line );
            if ( _is_proposed ) {
                _lines_by_action[ ACTIONS.APPLY ].push( $_line );
                _lines_by_action[ ACTIONS.REJECT ].push( $_line );
                continue;
            }
            _lines_by_action[ ACTIONS.MASSIVE_CHANGE ].push( $_line );
            if ( !_is_deleted && !_is_proposed ) {
                _lines_by_action[ ACTIONS.DELETE ].push( $_line );
            }
            if ( !_is_deleted ) {
                if ( _is_enable ) {
                    _lines_by_action[ ACTIONS.DISABLE ].push( $_line );
                }
                else {
                    _lines_by_action[ ACTIONS.ENABLE ].push( $_line );
                }
            }
            if ( _is_change && !_is_deleted ) {
                _lines_by_action[ ACTIONS.CHANGES ].push( $_line );
            }
            if ( _is_submittable ) {
                if (_has_staging) {
                    _lines_by_action[ ACTIONS.UNLOCK ].push( $_line );
                }
                _lines_by_action[ ACTIONS.SUBMIT ].push( $_line );
            }
        }
    }
    return [ _lines_by_action, _count_line_select ];
}

function _select_unselect_one_line ( p_row ) {
    (p_row.data( "selected" ) === 1) ? p_row.data( "selected", 0 ) : p_row.data( "selected", 1 );
}

function _update_line_checkbox ( p_row ) {
    var _checkbox = p_row.find( ':first .changes-checkbox' );
    (p_row.data( 'selected' ) === 1) ? _checkbox.prop( 'checked', true ) : _checkbox.prop( 'checked', false );
}

function __remove_one_line ( p_row ) {
    p_row.remove();
}

///*====================================================================================================================*/

///*===================================== SELECTED COUNTER UPDATE ======================================================*/

function update_selected_count ( _count_line_select ) {
    __update_selected_counter( "#id-element-selected-count", _count_line_select[ COUNTERS.SELECT ] );
    __update_selected_counter( "#id-element-selected-new-count", _count_line_select[ COUNTERS.NEW ] );
    __update_selected_counter( "#id-element-selected-difference-count", _count_line_select[ COUNTERS.CHANGE ] );
    __update_selected_counter( "#id-element-selected-proposed-count", _count_line_select[ COUNTERS.PROPOSED ] );
    
    if ( _count_line_select[ COUNTERS.SELECT ] ) {
        document.getElementById( "id-element-selected-count-pop-up" ).textContent = _count_line_select[ COUNTERS.SELECT ];
    }
}

function __update_selected_counter ( p_id, p_nb ) {
    var box = $( p_id );
    box.html( p_nb );
    if ( p_nb === 0 ) {
        box.removeClass( 'number selected' );
    }
    else {
        box.addClass( 'number selected' );
    }
}

function update_launch_analyze_button ( nb_selected_rows ) {
    var _target = document.getElementById( 'analyze-button-div' );
    if ( !_target || !_target.classList.contains( 'shinken-active' ) ) {
        return;
    }
    if ( !nb_selected_rows ) {
        _target.setAttribute( "shi-tip-html", _( 'element.tooltip_analyzer_no_host_selected' ) );
        _target.classList.add( 'shinken-content-disabled' );
        return;
    }
    if ( nb_selected_rows >= MAX_ELEMENT_FOR_ANALYZER ) {
        _target.setAttribute( "shi-tip-html", _( 'element.tooltip_analyzer_too_many_host_selected' ) );
        _target.classList.add( 'shinken-content-disabled' );
        return;
    }
    _target.classList.remove( 'shinken-content-disabled' );
    _target.setAttribute( "shi-tip-html", '' );
}

///*==================================================================================================================*/


///*================================= Action button popovers informations ============================================*/

// Add if there is not already a popover the action button a information that some
// elements have not be deleted because they are protected against deletion
function add_protected_popover_btn_action ( title, content ) {
    var btn_launch = $( '#btn-action-launch' );
    // 'Protected Element'
    // 'Some element are protected against the deletion.'
    // only active one popover for the action button
    if ( btn_launch.attr( 'data-have-popover' ) == null ) {
        var popover = btn_launch.popover( { animation: false, title: title, content: content } );
        btn_launch.attr( 'data-popover', popover );
        popover.popover( 'show' );
        btn_launch.attr( 'data-have-popover', '1' );
    }
}

function clean_popover_btn_action () {
    var btn_launch = $( '#btn-action-launch' );
    if ( btn_launch.attr( 'data-have-popover' ) != null ) {
        btn_launch.data( 'popover' ).destroy();
        btn_launch.removeAttr( 'data-popover' );
        btn_launch.removeAttr( 'data-have-popover' );
    }
}

// Clean all sign of protected element warnings, like lines with element-protected and the action button popover
function clean_protected_element_warnings () {
    $( '.shinken-element-line.element-protected' ).removeClass( 'element-protected' );
    clean_popover_btn_action();
}

// We will do a clean of the warnings on the list after X seconds in the futur
function schedule_clean_protected_element_warnings () {
    setTimeout( clean_protected_element_warnings, 5000 );
}

// For each click on the page, clean if need the action popover
$( window ).on( 'click', function () {
    clean_popover_btn_action();
} );
///*====================================================================================================================*/

///*======================== ACTION ON SELECTED LINE ===================================================================*/

function generate_url_params ( _item_type, _item_state ) {
    
    var we_bypass_work_area = 1;
    if ( _item_type === ITEM_TYPE.HOSTS ) {
        var bypass_working_area = MANAGER.WorkFlowManager.getState();
        we_bypass_work_area     = (bypass_working_area === MANAGER.CONST.STATE.WORK_FLOW.STAGING ? '1' : '0');
    }
    
    var url_params = [
        'item_state=' + _item_state,
        'bypass_work_area=' + we_bypass_work_area,
        'ts=' + Date.now()
    ];
    return url_params.join( '&' );
}

function enable_element ( p_row, callback ) {
    var _id                  = p_row.attr( 'id' );
    var _item_type           = p_row.data( 'item-type' );
    var _item_state          = p_row.data( 'item-state' );
    var _item_name           = p_row.attr( 'data-item-name' );
    var _is_list_all_element = SHINKEN.HIGHWAY.is( COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT );
    if ( _is_list_all_element && _item_type === 'hosts' ) {
        if ( callback ) {
            callback();
        }
    }
    else {
        $.ajax( {
            url    : '/element/q/' + _item_type + '/enable/' + _id + '?' + generate_url_params( _item_type, _item_state ),
            success: function ( data ) {
                if ( callback ) {
                    callback( _compute_error_message( data, _item_name ) );
                }
            },
            error  : function ( data, txt ) {
                form_error( data, 'enable' );
            }
        } );
    }
}

function disable_element ( p_row, callback ) {
    var _id                  = p_row.attr( 'id' );
    var _item_type           = p_row.data( 'item-type' );
    var _item_state          = p_row.data( 'item-state' );
    var _item_name           = p_row.attr( 'data-item-name' );
    var _is_list_all_element = SHINKEN.HIGHWAY.is( COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT );
    if ( _is_list_all_element && _item_type === 'hosts' ) {
        if ( callback ) {
            callback();
        }
    }
    else {
        $.ajax( {
            url    : '/element/q/' + _item_type + '/disable/' + _id + '?' + generate_url_params( _item_type, _item_state ),
            success: function ( data ) {
                if ( callback ) {
                    callback( _compute_error_message( data, _item_name ) );
                }
            },
            error  : function ( data ) {
                form_error( data, 'disable' );
            }
        } );
    }
    
}

function delete_one_element ( p_row, callback ) {
    var _id                  = p_row.attr( 'id' );
    var _item_type           = p_row.attr( 'data-item-type' );
    var _item_state = p_row.attr( 'data-item-state' );
    var _item_name = p_row.attr( 'data-item-name' );
    var bypass_working_area = MANAGER.WorkFlowManager.getState();
    var _is_list_all_element = SHINKEN.HIGHWAY.is( COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT );
    if ( _is_list_all_element && _item_type === 'hosts' ) {
        if ( callback ) {
            callback();
        }
    }
    else {
        var path = '';
        if ( _item_type === 'hosts' && bypass_working_area === MANAGER.CONST.STATE.WORK_FLOW.WORKING_AREA ) {
            _item_state = 'working_area';
            path        = '/elements/delete/working_area/' + _item_type + '/' + _id + '?' + generate_url_params( _item_type, _item_state );
        }
        else {
            path = '/element/q/' + _item_type + '/delete/' + _id + '?' + generate_url_params( _item_type, _item_state ), {};
        }
        $.post( path )
         .success( function( data, res2 ) {
             var delete_state = data.shinken_return_code;
             if ( delete_state === SHINKEN_RETURN_CODE.DELETE.OK ) { // the deletion was authorized, we can clean the line
                 __remove_one_line( p_row );
             }
             var row_line;
             if ( delete_state === SHINKEN_RETURN_CODE.DELETE.PROTECTED ) {
                 row_line = $( '#' + _id );
                 row_line.addClass( 'element-protected' );
                 add_protected_popover_btn_action( _( 'element.protected_element' ), _( 'element.protected_element_content' ) );
             }
             else if ( delete_state === SHINKEN_RETURN_CODE.DELETE.OWN_USER ) {
                 row_line = $( '#' + _id );
                 row_line.addClass( 'element-protected' );
                 add_protected_popover_btn_action( _( 'element.protected_element' ), _( 'element.exception_suicide_not_authorized' ) );
        
             }
             if ( callback ) {
                 callback( _compute_error_message( data, _item_name ) );
             }
         } )
         .error( function ( data, txt ) {
                 form_error( data, 'delete' );
             }
         );
    }
}

function clone_one_element ( p_row, callback ) {
    var _id                  = p_row.attr( 'id' );
    var _item_type           = p_row.attr( 'data-item-type' );
    var _item_state          = p_row.attr( 'data-item-state' );
    var _item_name           = p_row.attr( 'data-item-name' );
    var _is_list_all_element = SHINKEN.HIGHWAY.is( COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT );
    if ( _is_list_all_element && _item_type === 'hosts' ) {
        if ( callback ) {
            callback();
        }
    }
    else {
        $.post( '/element/q/' + _item_type + '/clone/' + _id + '?' + generate_url_params( _item_type, _item_state ), {} )
         .success( function ( data ) {
             if ( callback ) {
                 callback( _compute_error_message( data, _item_name ) );
             }
         } )
         .error( function ( data ) {
                 form_error( data, 'clone' );
             }
         );
    }
}

function create_from_one_element ( p_row, callback ) {
    var _id                  = p_row.attr( 'id' );
    var _item_type           = p_row.attr( 'data-item-type' );
    var _item_state          = p_row.attr( 'data-item-state' );
    var _item_name           = p_row.attr( 'data-item-name' );
    var _is_list_all_element = SHINKEN.HIGHWAY.is( COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT );
    if ( _is_list_all_element && _item_type === 'hosts' ) {
        if ( callback ) {
            callback();
        }
    }
    else {
        $.post( '/element/q/' + _item_type + '/create-from/' + _id + '?' + generate_url_params( _item_type, _item_state ), {} )
         .success( function ( data ) {
             if ( callback ) {
                 callback( _compute_error_message( data, _item_name ) );
             }
         } )
         .error( function ( data, txt ) {
                 form_error( data, 'create_from' );
             }
         );
    }
}

function import_new_elements ( data_to_send, item_state, callback ) {
    __action_many_elements( data_to_send, item_state, 'validate', callback );
}


function import_difference_elements ( data_to_send, item_state, callback ) {
    __action_many_elements( data_to_send, item_state, 'validate-changes', callback );
}

function import_difference_one_element ( p_row, callback ) {
    __action_one_element( p_row, 'validate-changes', callback );
}

function apply_one_element ( p_row, callback ) {
    var _id        = p_row.attr( 'id' );
    var _item_type = p_row.attr( 'data-item-type' );
    var _item_name = p_row.attr( 'data-item-name' );
    apply_work_area( _id, _item_type, _item_name, callback );
}

function reject_one_element ( p_row, callback ) {
    var _id        = p_row.attr( 'id' );
    var _item_type = p_row.attr( 'data-item-type' );
    var _item_name = p_row.attr( 'data-item-name' );
    reject_work_area( _id, _item_type, _item_name, callback );
}


function submit_many_elements ( data_to_send, item_state, callback ) {
    __action_many_elements( data_to_send, item_state, 'submit_to_staging', callback );
}

function submit_one_element ( p_row, callback ) {
    
    var _id        = p_row.attr( 'id' );
    var _item_type = p_row.attr( 'data-item-type' );
    var _item_name = p_row.attr( 'data-item-name' );
    submit_to_staging( _id, _item_type, _item_name, callback );
}

function unlock_one_element ( p_row, callback ) {
    var _id        = p_row.attr( 'id' );
    var _item_type = p_row.attr( 'data-item-type' );
    unlock_work_area( _id, _item_type, callback );
}

function __action_one_element ( p_row, p_action, callback ) {
    var _id         = p_row.attr( 'id' );
    var _item_type  = p_row.attr( 'data-item-type' );
    var _item_state = p_row.attr( 'data-item-state' );
    var _res        = {};
    
    _res[ _id ] = true;
    
    $.post( '/element/q/' + _item_type + '/' + p_action + '/' + '?' + generate_url_params( _item_type, _item_state ), _res )
     .success( function ( data ) {
         callback( data );
     } )
     .error( function ( data, txt ) {
         if ( p_action === 'validate' ) {
             form_error( data, 'import_from_source' );
         }
         else {
             form_error( data, 'accept_from_source' );
         }
     } );
}

function __action_many_elements ( data_to_send, item_state, p_action, callback ) {
    var item_type  = null;
    var _all_types = Object.keys( data_to_send[ 'elements' ] );
    if ( _all_types.length > 1 ) {
        item_type = 'elements';
    }
    else {
        item_type = _all_types[ 0 ];
    }
    $.ajax( {
        url        : '/elements/q/' + p_action + '/' + '?' + generate_url_params( item_type, item_state ),
        type       : 'POST',
        contentType: 'application/json',
        data       : JSON.stringify( data_to_send ),
        dataType   : 'json'
    } )
     .success( function ( data ) {
         if ( data ) {
             switch ( data[ 'rc' ] ) {
                 case COMMUNICATION.CODE.FORBIDDEN:
                     if ( p_action === 'validate' ) {
                         form_error( data, 'import_from_source' );
                     }
                     else {
                         form_error( data, 'accept_from_source' );
                     }
                     return;
             }
         }
         callback( data );
     } )
     .error( function ( data, txt ) {
         if ( p_action === 'validate' ) {
             form_error( data, 'import_from_source' );
         }
         else {
             form_error( data, 'accept_from_source' );
         }
     } );
    
    
}


var __mass_action_interval = null;


function tick_ask_mass_action_update ( uuid, action ) {
    $.get( "/elements/mass_action/progress/", { "uuid": uuid } )
     .success( function ( data ) {
         var current = data[ 'current' ];
         var total   = data[ 'total' ];
    
         update_progress_bar( data[ 'current' ], data[ 'total' ] );
    
         if ( current >= total ) {
             clearInterval( __mass_action_interval );
             ask_menu_update();
             var validation_messages = data[ 'validation_messages' ];
             if ( validation_messages ) {
                 var localized_action_name = _( 'mass-actions.' + ACTIONS.CHANGES );
                 var type                  = validation_messages[ 'counter_error' ] ? MSG_TYPE_ERROR : MSG_TYPE_WARNING;
                 var msg                   = {
                     'type'         : type,
                     'is_persistent': true,
                     'messages'     : validation_messages,
                     'title'        : App.Scope.format( _( 'element.element_fail' ), localized_action_name, current - validation_messages.length, data[ 'counter_error' ], data[ 'counter_warning' ], current ) + '<br>'
                 };
                 sessionStorage.setItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG, JSON.stringify( msg ) );
                 form_success( 0 );
             }
             else {
                 form_success();
             }
             deselect_all();
         }
     } )
     .error( function ( data, txt ) {
         clearInterval( __mass_action_interval );
         form_error( data, action );
     } );
}

function prepare_mass_multi_action ( p_rows, p_fn_action, p_action ) {
    var objects_to_import = {};
    var _last_item_state  = 'new';
    var obj_count         = 0;
    $.each( p_rows, function ( _index, row ) {
        var p_row        = $( row );
        var _id          = p_row.attr( 'id' );
        var _item_type   = p_row.attr( 'data-item-type' );
        _last_item_state = p_row.attr( 'data-item-state' );
        if ( !objects_to_import.hasOwnProperty( _item_type ) ) {
            objects_to_import[ _item_type ] = [];
        }
        objects_to_import[ _item_type ].push( _id );
        obj_count += 1;
    } );
    
    var data_to_send = {
        'elements'    : objects_to_import,
        'object_count': obj_count
    };
    p_fn_action( data_to_send, _last_item_state, function ( data ) {
        if ( data ) {
            mass_action_uuid = data[ 'uuid' ];
            tick_ask_mass_action_update( mass_action_uuid, p_action );
            __mass_action_interval = setInterval( function () {
                tick_ask_mass_action_update( mass_action_uuid, p_action );
            }, 500 );
        }
        else {
            ask_menu_update();
            form_success( 0 );
        }
    } );
}

function _compute_error_message ( data, _item_name ) {
    var _to_return;
    var _data;
    if ( data ) {
        try {
            _data = JSON.parse( data );
        }
        catch ( e ) {
            _data = data;
        }
        switch ( _data.rc ) {
            case COMMUNICATION.CODE.SUCCESS:
                _to_return = '';
                break;
            case COMMUNICATION.CODE.UNAUTHORIZED:
                test_user_change();
                break;
            default:
                _to_return = App.Scope.format( _data.text, _item_name );
                break;
        }
    }
    return _to_return;
}

function __action_on_selected_elements ( p_rows, p_fn_action, p_action ) {
    __nb_action_done = 0;      // always reset nb_enabled_done from previous runs
    __KO_msg         = [];
    sessionStorage.removeItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG );
    disable_all_elements_button_menu(); // we are in an action, so disable all buttons
    var nb_selected_ids = p_rows.length;
    
    get_spinner( 'spinner-mass-action', '0', '0', '#FFFFFF' );
    
    // import are done as mass and not 1 by 1
    if ( p_action == ACTIONS.IMPORT || p_action == ACTIONS.CHANGES ) {
        prepare_mass_multi_action( p_rows, p_fn_action, p_action );
    }
    else {
        $.each( p_rows, function ( _index, row ) {
            p_fn_action( $( row ), function ( message ) {
                // update bar state
                __nb_action_done += 1;
                update_progress_bar( __nb_action_done, nb_selected_ids );
                if ( message ) {
                    __KO_msg.push( message );
                }
                
                if ( __nb_action_done >= nb_selected_ids ) {
                    ask_menu_update();
                    if ( __KO_msg.length !== 0 ) {
                        console.log( '__KO_msg ', __KO_msg );
                        var localized_action_name = _( 'mass-actions.' + p_action );
                        var msg                   = {
                            'type'         : MSG_TYPE_ERROR,
                            'nb_total'     : __nb_action_done,
                            'nb_error'     : __KO_msg.length,
                            'action'       : p_action,
                            'messages'     : __KO_msg,
                            'is_persistent': true,
                            'title'        : App.Scope.format( _( 'element.element_fail' ), localized_action_name, __nb_action_done - __KO_msg.length, __KO_msg.length, 0, __nb_action_done ) + '<br>'  // Warnings are set to zero because only change action can has warning
                        };
                        
                        sessionStorage.setItem( KEY_SESSION_STORAGE_SAVING_LOG_MSG, JSON.stringify( msg ) );
                        form_success( 0 );
                    }
                    else {
                        form_success();
                    }
                }
            } );
        } );
    }
    // At the end of the action, remove checks
    //deselect_all();
}

//====================================================================================================================//

// Update the progress bar is possible, like
function update_progress_bar ( current, total ) {
    var bar = $( '#elements-progress-bar' );
    // I don't trust javascript float, so I prefer to compare int for exit
    if ( current >= total ) {
        bar.css( 'width', '0%' );
        $( '#spinner-mass-action' ).empty();
        return;
    }
    // Ok in the middle
    var pct = parseInt( 100 * current / total );
    bar.css( 'width', '' + pct + '%' );
}

// The use did click on the action button, look at the selected option and do it
function show_comment_to_launch_select_action ( element ) {
    if ( !$( '#btn-action-launch-add-comment' ).hasClass( 'shinken-disabled' ) ) {
        var _element  = document.getElementById( "comment-to-action-launch" );
        var _bounding = element.getBoundingClientRect();
        _element.classList.add( "active" );
        _element.style.top  = (_bounding.top - 18) + 'px';
        _element.style.left = (_bounding.right + 6) + 'px';
        document.getElementById( "comment-to-action-launch-input" ).focus();
    }
}

function close_comment_to_launch_select_action ( disable ) {
    if ( disable ) {
        $( '#btn-action-launch-add-comment' ).addClass( 'shinken-disabled' );
    }
    document.getElementById( "comment-to-action-launch" ).classList.remove( "active" );
    document.getElementById( "comment-to-action-launch-input" ).value = "";
}

function launch_select_action ( with_comment ) {
    
    // Remove comment if the user click on 'launch' button
    if ( !with_comment ) {
        document.getElementById( "comment-to-action-launch-input" ).value = '';
    }
    else {
        document.getElementById( "comment-to-action-launch" ).classList.remove( "active" );
    }
    
    var ACTION                    = {};
    ACTION[ ACTIONS.ENABLE ]      = enable_element;
    ACTION[ ACTIONS.DISABLE ]     = disable_element;
    ACTION[ ACTIONS.IMPORT ]      = import_new_elements;
    ACTION[ ACTIONS.CHANGES ]     = import_difference_elements;
    ACTION[ ACTIONS.DELETE ]      = delete_one_element;
    ACTION[ ACTIONS.CLONE ]       = clone_one_element;
    ACTION[ ACTIONS.SUBMIT ]      = submit_one_element;
    ACTION[ ACTIONS.UNLOCK ]      = unlock_one_element;
    ACTION[ ACTIONS.APPLY ]       = apply_one_element;
    ACTION[ ACTIONS.REJECT ]      = reject_one_element;
    ACTION[ ACTIONS.CREATE_FROM ] = create_from_one_element;
    
    var action = CONTROLLER.List.mass_action.component_select.last_selected_key_name;
    
    if ( action === ACTIONS.MASSIVE_CHANGE ) {
        CONTROLLER.MassChange.reset();
        CONTROLLER.MassChange.goNextStep( _count_available_action()[ 0 ][ action ] );
        return;
    }
    
    var _selected_row = _count_available_action()[ 0 ][ action ];
    if ( _selected_row.length > 0 ) {
        if ( action !== ACTIONS.DELETE || (action === ACTIONS.DELETE && confirm( _( 'element.sure' ) )) ) {
            __action_on_selected_elements( _selected_row, ACTION[ action ], action );
        }
    }
}

//function get_filter_and_reload ( p_element ) {
//    var _param = "" + __get_filter_from_object_filter() + __get_filter_from_input() + __get_filter_from_select() + __get_filter_state_workflow();
//    var _url   = p_element.attr( 'page' );
//    if ( _param != '' ) {
//        _url = _url + '?filter=' + SHINKEN.TOOLS.STRING.utf8Encode( _param.substring( 0, _param.length - 1 ) );
//    }
//    location.assign( _url );
//}

//function __get_filter_state_workflow () {
//    var _param = "";
//    if ( in_working_area != undefined && in_working_area === true ) {
//        var bypass_working_area = MANAGER.WorkFlowManager.getState();
//        var save_in_staging     = (bypass_working_area === MANAGER.CONST.STATE.WORK_FLOW.STAGING ? '1' : '0');
//        _param                  = 'save_in_staging:' + save_in_staging + '~';
//    }
//    return _param;
//}

function __get_filter_from_input () {
    var _input_list = $( "input[id^='input']" );
    var _nb_input   = _input_list.length;
    var _param      = "";
    for ( var i = 0; i < _nb_input; i++ ) {
        var _input = $( _input_list[ i ] );
        var _value = _input.val();
        _value     = SHINKEN.TOOLS.STRING.trim( _value );
        if ( _value !== '' ) {
            var _filter_name = _input.attr( "data-filter" );
            _param           = _param + _filter_name + ':' + _value.replace( /~/gi, '%fq%' ).replace( /:/gi, '%fg%' ) + '~';
        }
    }
    return _param;
}

function __get_filter_from_select () {
    var _select_list = $( "select[id^='select']" );
    var _nb_select   = _select_list.length;
    var _param       = "";
    for ( var i = 0; i < _nb_select; i++ ) {
        var _select       = $( _select_list[ i ] );
        var _select_value = $( _select.find( 'option:selected' ) );
        if ( _select_value.attr( "data-filter" ) !== "" ) {
            var _filter_name = _select.attr( "data-filter" );
            _param           = _param + _filter_name + ':' + _select_value.attr( "data-filter" ).replace( /~/gi, '%fq%' ).replace( /:/gi, '%fg%' ) + '~';
        }
    }
    return _param;
}

function __get_filter_from_object_filter () {
    var _param   = "";
    var _filters = MANAGER.__instance_filter_distributor.getAllElements();
    for ( var i = 0, _size = _filters.length; i < _size; i++ ) {
        var _filter_name = _filters[ i ].getParentName();
        var _value       = _filters[ i ].getFinalValue();
        if ( _value != '' ) {
            _param = _param + _filter_name + ':' + _value.replace( /~/gi, '%fq%' ).replace( /:/gi, '%fg%' ) + '~';
        }
    }
    return _param;
}

//====================================================================================================================//

/*========================== PREVENT ANY ACTION IF A MASSIVE ACTION IS ONGOING =======================================*/
var __massive_action_in_progress = false;

/*=========================================== WORK_AREA ACTION ========================================================*/
function unlock_work_area ( _id, _type, callback ) {
    
    $.post( '/element/q/' + _type + '/unlock_work_area/' + _id + '?ts=' + Date.now(), {} )
     .success( function ( data ) {
         if ( callback ) {
             callback();
         }
         else {
             form_success();
         }
     } )
     .error( function ( data, txt ) {
         form_error( data, 'unlock' );
     } );
}

function submit_to_staging ( _id, _type, _item_name, callback ) {
    var comment = $( '#comment-to-action-launch-input' ).val();
    
    $.post( '/element/q/' + _type + '/submit_to_staging/' + _id + '?ts=' + Date.now(), { 'comment': comment } )
     .success( function ( data ) {
         if ( callback ) {
             callback( _compute_error_message( data, _item_name ) );
         }
         else {
             form_success();
         }
     } )
     .error( function ( data, txt ) {
         form_error( data, 'submit' );
     } );
}

function apply_work_area ( _id, _type, _item_name, callback ) {
    $.post( '/element/q/' + _type + '/apply_work_area/' + _id + '?ts=' + Date.now(), {} )
     .success( function ( data ) {
         if ( callback ) {
             callback( _compute_error_message( data, _item_name ) );
         }
         else {
             form_success();
         }
     } )
     .error( function ( data, txt ) {
         form_error( data, 'apply_proposed' );
     } );
}

function reject_work_area ( _id, _type, _item_name, callback ) {
    var comment = $( '#comment-to-action-launch-input' ).val();
    $.post( '/element/q/' + _type + '/reject_submit/' + _id + '?ts=' + Date.now(), { 'comment': comment } )
     .success( function ( data ) {
         if ( callback ) {
             callback( _compute_error_message( data, _item_name ) );
         }
         else {
             form_success();
         }
     } )
     .error( function ( data, txt ) {
         form_error( data, 'reject' );
     } );
}


//========================== Page hosts: launch analyze button    ====================================================

function redirect_to_analyzer () {
    var _all_lines = $( '.shinken-element-line' );
    
    var to_analyze = [];
    for ( var i = 0; i < _all_lines.length; i++ ) {
        var _line = $( _all_lines[ i ] );
        if ( _line.data( 'selected' ) !== 1 ) {
            continue;
        }
        to_analyze.push( _line.attr( 'id' ) );
    }
    // If we did select no element, bail out
    if ( to_analyze.length === 0 ) {
        return;
    }
    
    var host_to_analyze_uuids = to_analyze.join( ',' );
    
    // As we do not want to give the uuids as a GET,
    // we must simulate a form to give the uuids as POST to the other page
    var btn                  = $( '#analyze-button-redirect' );
    var shadow_form_analyzer = $( '<form action="/analyzers/server-analyzer?tab=tab-analyze-jobs-in-progress" name="shadow_form_analyzer" method="post" style="display:none;"><input type="text" name="hosts_to_analyze_uuids" value="' + host_to_analyze_uuids + '" /> <input type="text" name="hosts_to_analyze_state" value="stagging" /></form>' );
    // add to the dom
    btn.append( shadow_form_analyzer );
    // and run it
    document.forms[ 'shadow_form_analyzer' ].submit();
    
}

//********************************************  DOM IS READY   ******************************************************//
var doActionWhenDomReady_old = function ( e ) {
    update_launch_analyze_button( 0 );
    
    
    $( '.see-all-button .btn-elements' ).on( 'click', function ( e ) {
        e.preventDefault();
        var base_address = $( '.see-all-button .btn-elements' ).attr( 'href' );
        var user_filter  = window.location.search;
        var url          = (user_filter) ? base_address + user_filter : base_address;
        location.assign( url );
    } );
    //var $btnCleanFilter = $( '.btn-clean-filter' );
    //$btnCleanFilter.tooltip( {
    //    placement: 'right'
    //} );
    //$btnCleanFilter.on( 'click', function ( e ) {
    //    location.assign( location.pathname );
    //} );
    //$( "select[id^='select']" ).change( function ( p_event ) {
    //        var _select = $( this );
    //        var val     = _select.val();
    //        if ( val == '' ) {
    //            _select.removeClass( 'filled' );
    //        }
    //        else {
    //            _select.addClass( 'filled' );
    //        }
    //
    //        get_filter_and_reload( $( this ) );
    //    }
    //);
    // When there is a massive action, and so we are disabling the fact that the user can get out the page
    window.onbeforeunload = function () {
        if ( __massive_action_in_progress ) {
            return _( 'element.actions_still_in_progress' );
        }
    };
    
    
    //$( "input[id^='input']" ).keyup( function ( e ) {
    //    // Catch ENTER
    //    var _input = $( this );
    //    var val    = _input.val();
    //    if ( val == '' ) {
    //        _input.removeClass( 'filled' );
    //    }
    //    else {
    //        _input.addClass( 'filled' );
    //    }
    //
    //    if ( e.keyCode == 13 ) {
    //        get_filter_and_reload( $( this ) );
    //    }
    //} );
    
    // Events col-all-check
    $( '#all-changes-checkbox' ).change( function () {
        $( this ).is( ":checked" ) ? select_all() : deselect_all();
    } );
    // Events row
    $( '.shinken-element-line' ).on( 'click', function ( e ) {
        // Default event'll be apply on "a" and "i" elements
        if ( !$( e.target ).is( 'a, i' ) ) {
            _select_unselect_one_line( $( this ) );
            _update_line_checkbox( $( this ) );
            _select_action();
        }
    } );
    
    MANAGER.__instance_loading.setIsReady( true );
    //initAllElements();
};

////********************************************  NOUVELLE METHOD V02.06.01   *****************************************//
//
//var initAllElements  = function (){
//
//}
//var get_all_dom_elements  = function (){
//    return document.getElementsByClassName('shinken-element-line');
//}