%from shinken.log import logger
%from shinken.synchronizer.business.source.sourceinfo import SourceInfo
%from ...dao.def_items import PROP_DEFAULT_VALUE, WORKING_AREA_STATUS, WORKING_AREA_LAST_ACTION, ITEM_STATE, ITEM_TYPE, METADATA, VALUE_FORCE_DEFAULT, DEF_ITEMS
%from shinken.synchronizer.dao.helpers import split_and_strip_list, is_inherited
%import cgi
%from collections import namedtuple

%if 'title_page' not in locals():
    %title_page=title
%end

%include( '__shinken-lib', type='LIST')
%rebase( 'layout_skonf' , page_id='list', title=title_page)

%# This template will create css from our column_configuration
%include('__import_dynamics_css', _column_conf=_column_conf)

%area = mypage if in_working_area else 'staging'
%has_no_working_area= not(mypage == 'elements' or  mypage == 'hosts' or in_working_area)
%is_admin = user.is_admin()
%show_analyze_button = (item_type == ITEM_TYPE.HOSTS) and not in_working_area and is_admin
%ItemValue = namedtuple('ItemValue', ['displayed_value', 'flat_value'])

<script>
    var mypage          = '{{mypage}}';
    var in_working_area = '{{in_working_area}}' == 'True';
</script>

%beacon.beacon('template', 'import')

<div class='elements-panel'>
    %include('__print_progress_bar')

    <div id='top-list-container' data-area='{{ area }}' data-list-type='{{ mypage }}' data-list-type-has-no-working-area='{{ has_no_working_area }}'>
        %include( '__print_saving_log')
        %include( '__print_backend_log', backend_log_title=backend_log_title, backend_log_messages=backend_log_messages)
        %extra_class_action_panel = 'working-area-action-panel' if in_working_area else ''
        %extra_class_list_panel = 'working-area-list-panel' if in_working_area else ''
        %curr_page = '%s/%s'% (mypage, item_type) if in_working_area else mypage
        <div class='elements-action-panel {{extra_class_action_panel}}'>
            %show_add_button = not ( addpage == 'element' or ( not is_admin and addpage == 'contact' ) )
            %include('__top_title')

            <div class='elements-action'>
                <table class='shinken-table'>
                    <tr>
                        <td class='col-action'>
                            %include('__print_action_select', app=app, working_area=in_working_area, curr_page=curr_page, is_admin=is_admin)
                        </td>
                        <td class='col-info'>
                            <div class='wrapper-table-count-panel'>
                                <table id='table-count-panel'>
                                    <tr>
                                        <td class='col-element-count'>
                                            <span class='element-wrap'>{{app._('element.nb_elements')}}&nbsp;:&nbsp;</span>
                                        </td>

                                        %if is_admin:
                                            %if curr_page == 'hosts':
                                                <td class='col-element-proposed-count'>
                                                    <span class='element-wrap'>{{app._('element.proposed')}}&nbsp;:&nbsp;</span>
                                                </td>
                                            %else:
                                                <td class='col-element-new-count'>
                                                    <span class='element-wrap'>{{app._('element.new')}}&nbsp;:&nbsp;</span>
                                                </td>
                                                <td class='col-element-difference-count'>
                                                    <span class='element-wrap'>{{app._('element.difference')}}&nbsp;:&nbsp;</span>
                                                </td>
                                            %end
                                        %end
                                    </tr>
                                    <tr>
                                        <td class='col-element-count'>
                                            <div class='element-wrap'>
                                                <span id='id-element-selected-count'>0</span>
                                                <span>&nbsp;/</span>
                                                <span id="id-shinken-total-list-element-number" class='number normal'>{{nb_all_items}}</span>
                                            </div>
                                        </td>
                                        %if is_admin:
                                            %if curr_page == 'hosts':
                                                <td class='col-element-proposed-count'>
                                                    <div class='element-wrap'>
                                                        <span id='id-element-selected-proposed-count'>0</span>
                                                        <span>&nbsp;/</span>
                                                        <span class='number proposed'>{{nb_proposed_items}}</span>
                                                    </div>
                                                </td>
                                            %else:
                                                <td class='col-element-new-count'>
                                                    <div class='element-wrap'>
                                                        <span id='id-element-selected-new-count'>0</span>
                                                        <span>&nbsp;/</span>
                                                        <span id="id-shinken-total-new-list-element-number" class='number new'>{{nb_new_items}}</span>
                                                    </div>
                                                </td>
                                                <td class='col-element-difference-count'>
                                                    <div class='element-wrap'>
                                                        <span id='id-element-selected-difference-count'>0</span>
                                                        <span>&nbsp;/</span>
                                                        <span id="id-shinken-total-diff-list-element-number" class='number diffence'>{{nb_change_items}}</span>
                                                    </div>
                                                </td>
                                            %end
                                        %end
                                    </tr>
                                </table>
                            </div>
                            <div class='shinken-elements-navigation'>
                                %include('pagination_element', navi=navi, app=app, page='elements/' + curr_page, div_class='nomargin')
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    %beacon.beacon('template', 'top part')

    <div class='elements-list-panel {{extra_class_list_panel}}'>
        <div class='header-background'>
            <div class='header-inner'>
                <div class='header-row header-names'>
                    <div class='cell column-select-boxes'>
                        %_shinken_btn_clean_is_disabled = '' if filter else ' shinken-disabled'
                        <div class='content-clean-filter'>
                            {{!helper.helper_object.get_button_html(id_button='id-shinken-btn-clean-filter-list-all',icon_class='shinkon shinkon-broom', class_to_add='shinken-clean-filter-button%s' % _shinken_btn_clean_is_disabled, attribute_to_add="shi-tip-placement='right' shi-tip-html='%s'" % app._("element.delete_filter_hover"), onclick='CONTROLLER.List.cleanFilters()', onmouseenter='SHINKEN_TOOLTIP.showTooltip(this);', onmouseleave='SHINKEN_TOOLTIP.hideTooltip();')}}
                        </div>
                    </div>
                    %for column_name in _column_conf:
                        <div class='cell filter column-{{column_name}}'>
                            <div class='name'>{{!_column_conf[column_name]['label']}}</div>
                        </div>
                    %end
                    <div class='cell filter column-scroll'>
                    </div>
                </div>
                <div class='header-row header-values'>
                    <div class='cell column-select-boxes'>
                        <input id='all-changes-checkbox' class='all-changes-checkbox' type='checkbox' name='all-changes-checkbox'/>
                    </div>
                    %for _column_name, _column in _column_conf.iteritems():
                        %_property = _column_name
                        %_label = _column['label']
                        %_have_value_list = _column['have_value_list']
                        %value = filter.get(_property, '')
                        %value_class = '' if value == '' else 'shinken-active'
                        <div class='cell filter column-{{_property}}'>
                            %if _have_value_list:
                                %placeholder = '-- %s --' % app._('element.all')
                                %need_caret = True
                            %else:
                                %placeholder = app._('element.no_filter')
                                %need_caret = False
                            %end
                            {{!helper.helper_list.get_list_select_input_html(list_values.get(_property, []), _property, value, value_class, separator=[ '&', '|', '*', '!', '<', '>', '(', ')' ], separator_for_split=['|', '&', '(', ')'], placeholder=placeholder, need_caret=need_caret, with_helper_tip=True)}}
                        </div>
                    %end
                </div>
            </div>
        </div>

        %beacon.beacon('template', 'header part')
        <div class='body-background'>
            <div class='body-inner'>
                %if not items:
                    %no_items_message = app._('element.empty_list') % (app._('type.%s'%item_type[:-1]),app._('type.%s'%item_type))
                    %if filter:
                        %no_items_message = app._('element.empty_list_filter') % app._('type.%s'%item_type[:-1])
                    %elif mypage == 'my_working_area':
                        %no_items_message = app._('element.empty_list_in_my_working_area') % (app._('type.%s'%item_type[:-1]),app._('type.%s'%item_type))
                    %end
                    <div class='no-elements'>{{!no_items_message}}</div>
                %end

                %for item in items:
                    %if 'customs' in item: # object standard non groupe
                        %_id = item.get('customs',{}).get('_ID', app._('element.unknown'))
                    %else: #object groupe, _id est sur l'object directement
                        %_id = item.get('_id', app._('element.unknown'))
                    %end
                    %item_extra_info = items_extra_info[item.get_key()]
                    %work_area_status = item_extra_info.get('working_area_status', ItemValue('','')).flat_value
                   <div class='shinken-element-line {{item_extra_info["additional_classes"]}}' id='{{_id}}' data-selected='0' {{!item_extra_info['data_infos']}}>

                        <div class='cell column-select-boxes'>
                            %include('__print_td_checkbox', h=item, _id=_id)
                        </div>
                        %for _property, _column in _column_conf.iteritems():
                            %from_tpl_class_text = 'from-template-text' if is_inherited(_property, item) else ''
                            %extra_class = _column.get('extra_class', "")
                            <div class='cell column-{{_property}} {{extra_class}}'>
                                %include(_column['value_formatter'], _value=item_extra_info[_property])
                            </div>
                        %end
                    </div>
                %end
            </div>
        </div>
    </div>
</div>
%include('__list_elements_filters_help', app=app)
%beacon.beacon('template', 'content part')
%logger.log_perf(time_start, 'List page loaded with %s items' % (nb_all_items), 'Total time', min_time=0.001)
%beacon.beacon('done')
%beacon.print_time()
%beacon.dump()

