%import shinkensolutions.shinkenjson as json
%from shinken.synchronizer.plugins.elements.massive_change import __compute_massive_change_title
%from shinken.synchronizer.business.item_controller.massive_change.massive_change_type import MASSIVE_CHANGE_TYPE

<div id="id-shinken-mass-change-tunnel-step2" class="shinken-mass-change-tunnel-step">
    <div id="id-shinken-all-items" class="shinken-hidden">{{!json.dumps(all_items)}}</div>
    <table class="shinken-width-100 shinken-height-100 shinken-mass-change-container">
        <tr class="shinken-header-row">
            <td class="shinken-cell-title">
                <div class="shinken-title-container">
                    <table class="shinken-width-100 shinken-height-100">
                        <tr>
                            <td colspan="3">
                                <div class="shinken-title">
                                    {{__compute_massive_change_title(2, type_modification)}}
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <div class="shinken-nb-element-affected">
                                    {{!app._("mass-change.nb-element-affected").format(nb_elements, type_label)}}
                                    <div>
                                        %_trad =app._("mass-change.step-2.nb-checks-exclude") if type_modification == MASSIVE_CHANGE_TYPE.EXCLUDES else app._("mass-change.step-2.nb-checks-affected")
                                        {{!_trad.format(helper_object.get_counter_html(id='mass-change-checks-selected', class_to_add="shinken-in-text", number="0"))}}
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <div class="shinken-type-step">
                                    %if type_modification == MASSIVE_CHANGE_TYPE.EXCLUDES:
                                        {{app._('mass-change.step-2.type_exclude')}}
                                    %else:
                                        {{app._('mass-change.step-2.type_override')}}
                                    %end
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
            <td class="shinken-action-container-cell">
                <div class="shinken-width-100 shinken-button-table-container">
                    <table class="shinken-width-100 shinken-table-action-btn ">
                        <tr>
                            <td>
                                %if type_modification == MASSIVE_CHANGE_TYPE.EXCLUDES:
                                    {{!helper_object.get_button_html(id_button="id-shinken-btn-step2-next", label=app._('mass-change.button.show_recap'), onclick="CONTROLLER.MassChange.goNextStep()", datas={"name":"show_recap"}, class_to_add="shinken-disabled-if-not-set shinken-disabled")}}
                                %else:
                                    {{!helper_object.get_button_html(id_button="id-shinken-btn-step2-next", label=app._('mass-change.button.configure'), onclick="CONTROLLER.MassChange.goNextStep()", class_to_add="shinken-disabled shinken-disabled-if-not-set")}}
                                %end
                            </td>
                        </tr>
                        <tr>
                            <td>
                                {{!helper_object.get_button_html(label=app._('mass-change.button.return'), onclick="CONTROLLER.MassChange.goPreviousStep(event)", datas={"name":"return"})}}
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>
        %list_check_col_span = 2
        %if type_modification == MASSIVE_CHANGE_TYPE.EXCLUDES:
            %group_name = 'mass-change'
            %group_name_label = '-mass-change'
            %current_tab = 'checks'
            %list_check_col_span = 1
            <tr>
                <td class="shinken-hidden">
                    <table class="shinken-mass-change-navigation">
                        <tr class="shinken-window-group" data-name="{{group_name}}" onclick="MANAGER.EventManager.clickOnWindowNavigation(event,'{{group_name}}')">
                            %include( "__print_element_td_tab", app=app, name=current_tab , label=app._('element.%s' % current_tab), group_name=group_name, has_properties=True )
                        </tr>
                    </table>
                </td>
                <td class="shinken-mass-change-property-step">
                    <table>
                        <tr>
                            <td>
                                <div {{!helper.get_window_target_div('checks', group_name_label, 'checks', extra_class='shinken-host-check-window-container', extra_attr='data-tab-selected="2"')}}>
                                    <div id="id-shinken-exclude-property-container">
                                        <table class="shinken-prop-table">
                                            {{!helper.get_string_input(item, 'service_excludes', item_type, is_disabled=False, mass_change=True)}}
                                        </table>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr class="shinken-user-container-row">
                            <td colspan="{{list_check_col_span}}" class="shinken-form-container-cell shinken-height-100">
                                <div class="shinken-scrollable-container">
                                    %include( "massive_change/step_2/massive_change_list_checks" )
                                </div>
                            </td>
                        </tr>
                    </table>
                </td>
                <td class="shinken-help-container-cell" rowspan="1">
                    <div class="shinken-help-container">
                        %include( "__print_right_help_bloc", changes=False, app=app)
                    </div>
                </td>
            </tr>
        %else:
            <tr class="shinken-user-container-row">
                <td colspan="{{list_check_col_span}}" class="shinken-form-container-cell shinken-height-100">
                    <div class="shinken-scrollable-container">
                        %include( "massive_change/step_2/massive_change_list_checks" )
                    </div>
                </td>
            </tr>
        %end
    </table>
</div>

