%from shinkensolutions.toolbox.box_tools_string import ToolsBoxString

%is_syncui = item.get('source', {}).get('value', '').strip() == 'syncui'

<div class="shinken-table-show-item-container-global">
    %if has_error:
    <div class="shinken-table-show-item-container">
        <table class="shinken-table-show-item shinken-table-warning">
            <thead>
            <tr>
                <th><span class="shinken-table-header">{{app._('element.warning')}}</span></th>
            </tr>
            </thead>
            <tbody>
                    <tr>
                        <td class="shinken-table-data">{{ error_text }} </td>
                    </tr>
                </tbody>
            </table>
        </div>
    %else:
        %if origin_item_info:
            {{!origin_item_info.to_html(item, item_type)}}
        %end

        %as_error= "" if not import_errors and not import_warnings else "as_error"

        <div class="shinken-table-show-item-container">
            <h4>{{app._('source.element_table_detail')}}</h4>
            <table class="shinken-table-show-item shinken-table-info{{as_error}} striped">
                <thead>
                    <tr>
                        <th><span class="shinken-table-header">{{app._('source.key')}}</span></th>
                        <th><span class="shinken-table-header">{{app._('source.value')}}</span></th>
                        %if has_more_informations_on_element:
                            <th><span class="shinken-table-header">{{app._('source.more_informations')}}</span></th>
                        %end
                    </tr>
                </thead>
                <tbody>
                    %for key in keys:
                        <tr class="shinken-table-source-data">
                            <td><div class="shinken-table-data">{{key}}</div></td>
                            %no_data = True if ToolsBoxString.unescape_XSS(item[key]['value']) == 'no_data' else False
                            <td><div class="shinken-table-data {{item[key]['protected_class']}}" data-no-data="{{no_data}}">
                                %if no_data:
                                    {{app._('element.no_data')}}
                                %else:
                                    %if type(item[key]['value']) is list:
                                        %values = ', '.join(item[key]['value'])
                                        {{ToolsBoxString.unescape_XSS(values)}}
                                    %elif is_syncui and key == 'imported_from':
                                        {{!item[key]['value']}}
                                    %else:
                                        {{ToolsBoxString.unescape_XSS(item[key]['value'])}}
                                    %end
                                %end

                            </div>
                            </td>
                            %if has_more_informations_on_element:
                                <td><div class="shinken-table-data more-informations-data">{{ToolsBoxString.unescape_XSS(item[key].get('more_informations', ''))}}</div></td>
                            %end
                        </tr>
                    %end
                </tbody>
            </table>
            %include("__item_list_detail_warnings_or_errors", app=app, errors=import_errors, error_type='error')
            %include("__item_list_detail_warnings_or_errors", app=app, errors=import_warnings, error_type='warning')
        </div>
    %end
</div>