%if run is not None:
%state = run.get('state', '').replace('/ /g', '-' ).lower()
%state_txt = 'main.state-%s' %state

%sync_time = ""
%if 'synchronization_time' in run:
%sync_time = app.helper.print_date(run['synchronization_time'])
%end
<div class="shinken-prev-import">
    %if state == "running":
        <p>
            <span class="bold">{{app._('source.run_at')}} {{sync_time}}</span>
            <br/>
            <span class="tag-state {{state.replace(' ', '-')}}">{{app._(state_txt.replace(' ','_'))}}</span>
        </p>

    %else:
        <div class="shinken-alert shinken-alert-ghost-{{ state }} shinken-alert-block">
            <div class="shinken-output-block">
                <table class="shinken-width-100">
                    <tbody>
                    <tr>
                        <td class="shinken-cell-status">
                            <span class="tag-state {{state.replace(' ', '-')}}">{{app._(state_txt.replace(' ','_'))}}</span>
                        </td>
                        <td class="shinken-output-text-column">
                            <span class="shinken-output-text">
                                {{!run['output']}}
                            </span>
                        </td>
                        <td class="shinken-cell-date">
                            <span class="bold">{{sync_time}}</span>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

            %errors = run.get('errors', [])
            %warnings = run.get('warnings', [])
            %merged_warnings = run.get('merged_warnings', [])
            %merged_errors = run.get('merged_errors', [])
            %if errors:
            <div class='alert-error shinken-alert shinken-alert-ghost-critical shinken-error-critical'>
                <div class="shinken-alert-title">{{app._('source.errors')}}&nbsp;:&nbsp;</div>
                <ul class="shinken-status-list">
                    %for error in errors:
                    <li>
                        {{ !error }}
                    </li>
                    %end
                </ul>
            </div>
            %end

            %if warnings:
            <div class='alert-error shinken-alert shinken-alert-ghost-warning shinken-error-warning'>
                <div class="shinken-alert-title">{{app._('source.warnings')}}&nbsp;:&nbsp;</div>
                <ul class="shinken-status-list">
                    %for warning in warnings:
                    <li>
                        {{ !warning }}
                    </li>
                    %end
                </ul>
            </div>
            %end

            %if merged_errors:
            <div class='alert-error shinken-alert shinken-alert-ghost-critical shinken-error-critical'>
                <div class="shinken-alert-title">{{app._('source.merged_errors')}}&nbsp;:&nbsp;</div>
                <ul class="shinken-status-list">
                    %for error in merged_errors:
                    <li>
                        {{ !error }}
                    </li>
                    %end
                </ul>
            </div>
            %end

            %if merged_warnings:
            <div class='alert-error shinken-alert shinken-alert-ghost-warning shinken-error-warning'>
                <div class="shinken-alert-title">{{app._('source.merged_warnings')}}&nbsp;:&nbsp;</div>
                <ul class="shinken-status-list">
                    %for warning in merged_warnings:
                    <li>
                        {{ !warning }}
                    </li>
                    %end
                </ul>
            </div>
            %end

            %if run.get('was_clean',False):
            <div class="col-sm-12 col-md-12 col-lg-12">
                <div class="block-container">
                    <div class="content">
                        <span class="title">{{!run['output']}}</span>
                    </div>
                </div>
            </div>
            %end

            %if state != 'critical' and not run.get('was_clean',False):
                <div class='shinken-alert shinken-alert-ghost-ok shinken-alert-ok'>
                    <div class="shinken-alert-title">{{app._('source.execution_result')}} :</div>
                    %if 'last_actions' in run:
                        <div class="shinken-last-actions">
                            %last_action = run['last_actions']
                            <div class="shinken-alert-title shinken-alert-title-info">{{result_title_info}} :</div><br>
                            %for item_type, possible_actions in last_action.iteritems():
                                <h4>{{ app._('type.%s'%item_type)}}:</h4><br>

                                %for possible_action, actions in last_action[item_type].iteritems():
                                    <div class="shinken-last-actions">
                                        <b>{{app._('source.action_%s'%possible_action)}}:</b>
                                        %for action in actions:
                                            <table class="table bordered striped">
                                                <thead>
                                                <th>{{app._('source.key')}}</th>
                                                <th>{{app._('source.value')}}</th>
                                                </thead>
                                                <tbody>
                                                %saved = action
                                                %keys = saved.keys()
                                                %keys.sort()
                                                %for k in keys:
                                                    %value = saved.get(k, {})
                                                    <tr>
                                                        <td>{{k}}</td>
                                                        <td>{{value}}</td>
                                                    </tr>
                                                %end
                                                </tbody>
                                            </table>
                                            <br>
                                        %end
                                    </div>
                                %end
                            %end
                        </div>
                    %end
                    <div class="shinken-last-actions">
                        %saved = run.get('saved', {})
                        %is_latest_run = run.get('is_latest_run', False)
                        %keys = saved.keys()
                        <div class="shinken-alert-title shinken-alert-title-info">{{app._('source.sent_elements')}} :</div><br>
                        <div class="shinken-last-actions">
                        %if keys:
                            <table class="table bordered striped">
                                <thead>
                                <th>{{app._('source.type')}}</th>
                                <th>{{app._('source.count')}}</th>
                                </thead>
                                <tbody>
                                %keys.sort()
                                %for k in keys:
                                    %if k not in ALL_ITEM_TYPES:
                                        %continue
                                    %end
                                    %value = saved.get(k, {})
                                    %if not isinstance(value, int):
                                        %value = value.get('nb_elements', 0)
                                    %end
                                    <tr>
                                        %if is_latest_run :
                                            <td><a href="?tab=tab-detail-last-run&filter=class:{{k}}">{{k}}</a></td>
                                        %else:
                                            <td>{{k}}</td>
                                        %end
                                        <td>{{value}}</td>
                                    </tr>
                                %end
                                </tbody>
                            </table>
                        %else:
                            <div class="shinken-no-element-source-message">{{app._('source.no_element_source_execution')}}</div>
                        %end
                        </div>
                    </div>
                </div>
            %end
        </div>
    %end
</div>
%else:
<div class="shinken-prev-import">
    <div class="shinken-output-block">
        <span class="shinken-output-text">
            {{app._('source.no_details')}}
        </span>
    </div>
</div>
%end