%if not source_json.get('enabled', False):
%mod_class = 'shinken-content-disabled'
%analyzer_tooltip_message = app._('element.tooltip_analyzer_disabled')
%else:
%mod_class = 'shinken-active'
%analyzer_tooltip_message = ''
%end

%class_disable = ''
%if mod.properties['type'] == 'discovery-import' and not mod.try_database_connection():
    %class_disable = 'shinken-disabled'
%end
<div class="shinken-discovery-tab-container {{class_disable}}">
    <div class="table-head-js scroll-head content responsive">
        <table class="table striped bordered" role="grid">
            <thead>
            <tr role="row">
                <th>{{app._('discovery.network_name')}}</th>
                <th>{{app._('discovery.iprange')}}</th>
                <th>{{app._('discovery.notes')}}</th>
                <th>
                    <span class="col-md-3s">{{app._('discovery.enabled')}}</span>
                    <span class="col-md-9s">
                        <div class="btn-shinken btn-blue text-ellipsis pull-right" id="id-shinken-add-button" title="{{app._('discovery.add_new_scan')}}" onclick="CONTROLLER.Source.configurePlageIp('{{source.get_name()}}','new')"><i class="icon-plus"></i>&nbsp;{{app._('discovery.add')}}</div>
                    </span>

                </th>
            </tr>
            </thead>
        </table>
    </div>


    <div class="table-body-js scroll-body content responsive scroll-without-filter ">
        <table class="table striped bordered shinken-table" role="grid">
            <tbody>
            %if mod.properties['type'] in ('discovery-import', 'server_analyzer'):
                %if mod.properties['type'] == 'discovery-import':
                <div class="shinken-col-sm-12">
                    <div class="shinken-text-disabled">{{mod._('source.database_unavailable')}}</div>
                </div>
                %end
            %for conf in discovery_confs:
            %hname = conf.get('discovery_name', 'unknown')
            %_identif = conf.get('_id', '')
            %is_enabled = "1" if conf.get('enabled', "") else "0"
            <tr class="shinken-network-scan-row" data-id="{{_identif}}" data-is-active={{is_enabled}}>
                <td class='discovery_name cut-long '>
                    <div class="shinken-link" onclick="CONTROLLER.Source.configurePlageIp('{{source.get_name()}}', '{{_identif}}')">
                        <span class="shinken-network-scan-link shinken-label">{{hname}}</span>
                        <span class="shinken-network-scan-link shinkon-cog"></span>
                    </div>
                </td>
                <td class='ip-range cut-long '>{{conf.get('iprange','')}}</td>
                <td class='notes cut-long '>{{conf.get('notes', '')}}</td>
                <td class='enabled cut-long '>
                    %if mod_type == 'server_analyzer':
                    <form action="/analyzers/{{source.get_name()}}?tab=tab-analyze-jobs-in-progress" class="analyzer-form pull-right show-button-analyze-if-discovery-activated" name="shadow_form_analyzer" method="post">
                        <input type="hidden" name="ip_to_analyze" value={{",".join(conf["string_iprange"])}} />
                        <input type="hidden" name="hosts_to_analyze_state" value="discovery"/>
                        <input type="hidden" name="discovery_name" value="{{conf['discovery_name']}}"/>
                        <div class="analyze-button {{ mod_class }}" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this);" onmouseleave="SHINKEN_TOOLTIP.hideTooltip();" shi-tip-placement="left" shi-tip-html="{{ analyzer_tooltip_message }}">
                            <button type="submit" class="btn btn-elements analyzer-analyze-button">
                                <i class="icon-search"></i>&nbsp;{{app._('element.analyze')}}
                            </button>
                        </div>
                    </form>
                    %end
                    <div class="content">
                        <table class="column-enabled-table">
                            <tr class="table-background-grey">
                                <td>
                                    <div class="switch-button-wrapper" data-source-name="{{hname}}" onclick="MANAGER.EventManager.clickOnActivatedDiscoverySource('{{sname}}', '{{_identif}}')">
                                        <div class="switch-button"></div>
                                    </div>
                                </td>
                                <td class="column-enabled-label show-if-discovery-activated disable-selection">
                                    {{app._('discovery.enabled')}}
                                </td>
                                <td class="column-enabled-label hide-if-discovery-activated disable-selection">
                                    {{app._('discovery.disabled')}}
                                </td>
                            </tr>
                        </table>
                    </div>
                </td>
            </tr>
            %end
            %end
            </tbody>
        </table>
    </div>
</div>