#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.
from check_shinken_module_metrology_writer import CheckGraphiteForWriter
from shinkensolutions.lib_checks.common import RaiseOnExitOptionParser
from shinkensolutions.lib_checks.graphite import GRAPHITE_CONF_FILE, validate_graphite_check_option_parser

VERSION = '0.1'


def _init_parser():
    parser = RaiseOnExitOptionParser(
        '%prog [options] [--help]',
        version='%prog ' + VERSION,
        epilog='This script allows you to check Graphite server. '
               'It will connect to the server using SSH, check Graphite state, and then return an exit code, outputs, and performance data. '
               'Please specify -w and -c options if you want to add thresholds on the space used by Graphite. You have to use the option -m to select either the standalone or Shinken mode.'
    )
    parser.add_option('-H', '--hostname', dest='hostname', help='Hostname to connect to, where Graphite is hosted. Mandatory.')
    parser.add_option('-p', '--port', dest='ssh_port', type='int', default=22, help='SSH port to connect to. Default : 22')
    parser.add_option('-i', '--ssh-key', dest='ssh_key_file', default='~/.ssh/id_rsa', help='SSH key file to use. By default it will take ~/.ssh/id_rsa.')
    parser.add_option('-u', '--user', dest='user', default='shinken', help='remote user to use. By default shinken.')
    parser.add_option('-P', '--passphrase', dest='passphrase', default='', help='SSH key passphrase. By default will use void.')
    parser.add_option('-s', '--graphite_port', dest='graphite_port', default=2003, help='Graphite Socket. Default : 2003')
    parser.add_option('-d', '--graphite_data_location', dest='data_location', default='/opt/graphite/storage/whisper', help='Graphite Data Location. Default : /opt/graphite/storage/whisper')
    parser.add_option('-U', '--graphite_user', dest='graphite_user', default='apache', help='Graphite user. Default : apache')
    parser.add_option('-w', '--warning', dest='warning', default=85, help='Warning value for Graphite space usage. In percent. Default : 85%')
    parser.add_option('-c', '--critical', dest='critical', default=95, help='Critical value for Graphite space usage. In percent. Default : 95%')
    parser.add_option('-f', '--conf-file', dest='conf_file', default='/opt/graphite/conf/carbon.conf', help='Carbon configuration file path. Default : /opt/graphite/conf/carbon.conf')
    parser.add_option('-D', '--graphite_disks', dest='graphite_disks', default='', help='Filter for disk I/O : list of disks separated by commas. Default no filter')
    parser.add_option('-W', '--warning-io', dest='storage_io_warning', default=85, help='Warning value for Graphite io usage. In percent. Default : 85%')
    parser.add_option('-C', '--critical-io', dest='storage_io_critical', default=95, help='Critical value for Graphite io usage. In percent. Default : 95%')

    parser.add_option(u'-n', u'--cache', dest=u'graphite_cache_name', default=u'carbon-cache', help=u'Name for the graphite relay process. Default : carbon-relay')
    parser.add_option(u'-R', u'--relay', dest=u'graphite_relay_name', default=u'carbon-relay', help=u'Name for the graphite cache process. Default : carbon-cache')
    
    return parser


def main():
    parser = _init_parser()
    opts = validate_graphite_check_option_parser(parser)
    
    check_graphite = CheckGraphiteForWriter(
        graphite_disks=opts.graphite_disks,
        storage_io_warning=opts.storage_io_warning,
        storage_io_critical=opts.storage_io_critical,
        graphite_hostname=opts.hostname,
        graphite_port=opts.graphite_port,
        ssh_port=opts.ssh_port,
        ssh_key_file=opts.ssh_key_file,
        passphrase=opts.passphrase,
        user=opts.user,
        graphite_location=opts.data_location,
        graphite_user=opts.graphite_user,
        storage_usage_warning=opts.warning,
        storage_usage_critical=opts.critical,
        graphite_cache_name=opts.graphite_cache_name,
        graphite_relay_name=opts.graphite_relay_name,
        graphite_conf_file=GRAPHITE_CONF_FILE,
    )
    
    check_graphite.check_and_set_output_result()


if __name__ == '__main__':
    main()
