MONGO_HOST='localhost'
MONGO_PORT=27017
MONGO_USE_SSH=''
MONGO_SSH_KEY=~shinken/.ssh/id_rsa
MONGO_SSH_USER="shinken"
MONGO_SSH_ACTIVE_TUNNEL=""

function silent_cp() {
  cp "$@" &> /dev/null
}

function display_mongo_help () {
    printf "\nMongo connection parameters:\n"
    printf "************************************************************************************\n"
    printf "*** WARNING : **********************************************************************\n"
    printf "*** Use specific parameters to connect to mongoDB only if the data that needs to be\n"
    printf "*** backed up/restored can't be accessed using the default shinken connection\n"
    printf "*** settings ( localhost:27017 ).\n"
    printf "** Keep in mind that depending on your data location, you may have to use different\n"
    printf "** settings depending on the shinken-backup/shinken-restore options\n"
    printf "** ( for example: different parameters for --configuration and --user ).\n"
    printf "************************************************************************************\n"
    printf "  --mongo-host [hostname|IP]  : hostname or IP of MongoDB server ( %s )\n" "${MONGO_HOST}"
    printf "  --mongo-port [port]         : MongoDB server port ( %s )\n" "${MONGO_PORT}"
    printf "  --mongo-use-ssh             : enable SSH to connect to MongoDB server ( %s )\n" "${MONGO_USE_SSH:-no}"
    printf "  --mongo-ssh-key [filename]  : SSH private key used to connect to MongoDB server (  %s )\n" "${MONGO_SSH_KEY}"
    printf "  --mongo-ssh-user [username] : user on MongoDB server to use for SSH connection ( %s )\n" "${MONGO_SSH_USER}"
    printf "\n\n"
}

function parse_mongo_opt () {
    case "$1" in
    --mongo-host)
        # when second parameter is empty or starting with - (maybe another option ?) return missing parameter code
        if [ -z "$2" ] || [ "${2:0:1}" = '-' ]
        then
            return 1
        fi
        echo "MONGO_HOST=\"\$2\"; shift 2"
        return 0
        ;;
    --mongo-port)
        if [ -z "$2" ] || [ "${2:0:1}" = '-' ]
        then
            return 1
        fi
        echo "MONGO_PORT=\"\$2\"; shift 2"
        return 0
        ;;
    --mongo-use-ssh)
        echo "MONGO_USE_SSH=\"yes\"; shift"
        return 0
        ;;
    --mongo-ssh-key)
        if [ -z "$2" ] || [ "${2:0:1}" = '-' ]
        then
            return 1
        fi
        echo "MONGO_SSH_KEY=\"\$2\"; MONGO_USE_SSH=\"yes\"; shift 2"
        return 0
        ;;
    --mongo-ssh-user)
        if [ -z "$2" ] || [ "${2:0:1}" = '-' ]
        then
            return 1
        fi
        echo "MONGO_SSH_USER=\"\$2\"; MONGO_USE_SSH=\"yes\"; shift 2"
        return 0
        ;;
    *)
        return 3
        ;;
    esac
}

function close_mongo_tunnel() {
    if [ -z "${MONGO_SSH_ACTIVE_TUNNEL}" ]
    then
        return 0
    fi
    # Enable some debug :
    # echo "Closing port forwarding from ${MONGO_HOST}:${MONGO_PORT} to ${MONGO_ORIGINAL_HOST}:${MONGO_ORIGINAL_PORT}"
    ssh -S "${MONGO_SSH_ACTIVE_TUNNEL}" -o "ControlMaster=auto" -o "LogLevel=QUIET" -O "exit" echo &>/dev/null
    MONGO_SSH_ACTIVE_TUNNEL=''
    trap - EXIT
    MONGO_HOST=${MONGO_ORIGINAL_HOST}
    MONGO_ORIGINAL_HOST=''
    MONGO_PORT=${MONGO_ORIGINAL_PORT}
    MONGO_ORIGINAL_PORT=''
}

function prepare_mongo_tunnel() {
    local LOCAL_PORT
    close_mongo_tunnel
    if [ -z "${MONGO_USE_SSH}" ]
    then
        return 0
    fi
    MONGO_SSH_ACTIVE_TUNNEL=~/".ssh_${MONGO_SSH_USER}@${MONGO_HOST}:$MONGO_PORT.$$"
    if [ -e "${MONGO_SSH_ACTIVE_TUNNEL}" ]
    then
        # This file should not be here, cleaning up
        ssh -S "${MONGO_SSH_ACTIVE_TUNNEL}" -o "ControlMaster=auto" -o "LogLevel=QUIET" -O "exit" echo &>/dev/null
        rm -f "${MONGO_SSH_ACTIVE_TUNNEL}"
    fi
    for I in $(seq 1 10)
    do
        LOCAL_PORT=$(( RANDOM + 1024 + I ))
        if ssh -4 -f -N -o "ControlMaster=auto" -S "${MONGO_SSH_ACTIVE_TUNNEL}" -o "LogLevel=QUIET" -o "PreferredAuthentications=publickey" -o "ExitOnForwardFailure=true" -o "BatchMode=yes" -o "UserKnownHostsFile=/dev/null" -o "StrictHostKeyChecking=no" -L "127.0.0.1:${LOCAL_PORT}:127.0.0.1:${MONGO_PORT}" -i "${MONGO_SSH_KEY}" -l "${MONGO_SSH_USER}" "${MONGO_HOST}" &>/dev/null
        then
            MONGO_ORIGINAL_HOST=${MONGO_HOST}
            MONGO_ORIGINAL_PORT=${MONGO_PORT}
            MONGO_PORT=${LOCAL_PORT}
            MONGO_HOST='127.0.0.1'
            # Enable some debug :
            # echo "Forwarding data to MongoDB server from ${MONGO_HOST}:${MONGO_PORT} to ${MONGO_ORIGINAL_HOST}:${MONGO_ORIGINAL_PORT}"
            trap close_mongo_tunnel EXIT
            return 0
        fi
    done
    MONGO_SSH_ACTIVE_TUNNEL=''
    return 1
}
