# !/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (C) 2013-2021:
# This file is part of Shinken Enterprise, all rights reserved.
import os


def rename_graphite_checks_metrics_files(folders_to_rename):
    g_did_run = False
    graphite_data_folder_path = u'/opt/graphite/storage/whisper/'
    
    # Maybe the server do not have graphite whisper, because it's a drbd spare server
    if not os.path.exists(graphite_data_folder_path):
        return g_did_run
    
    for folder in os.listdir(graphite_data_folder_path):
        host_folder = graphite_data_folder_path + folder
        if not os.path.isdir(host_folder):
            continue
        
        for subfolder in os.listdir(host_folder):
            service_folder = os.path.join(host_folder, subfolder)
            if not os.path.isdir(service_folder):
                continue
            
            for service_file in os.listdir(service_folder):
                if service_file not in folders_to_rename:
                    continue
                old_name = os.path.join(service_folder, service_file)
                new_name = os.path.join(service_folder, folders_to_rename[service_file])
                os.rename(old_name, new_name)
                g_did_run = True
    return g_did_run
