SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT = (function ( self ) {
    self.DOM                               = {};
    self.TEST                              = {};
    self.ACTION                            = {};
    //********************************************  GET DOM ELEMENT   ****************************************//
    self.DOM.elementsUserSelected          = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name ).querySelectorAll( ".shinken-list-selected-in-select .shinken-container-tag" );
    };
    self.DOM.line                          = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name );
    };
    self.DOM.plusButton                    = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name ).querySelector( '.container-btn-plus' );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.addSelectedElement         = function ( timeout, property_name, element_to_add ) {
        return SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR.ACTION.clickOnOptionProperty( timeout, property_name, PROPERTY.CONST.SELECTOR.MAIN, element_to_add, true );
    };
    self.ACTION.clickOnPlus                = function ( timeout, property_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.plusButton( property_name ) );
        }, timeout );
        return 500;
    };
    self.ACTION.removeTagInSelectedElement = function ( timeout, property_name, index ) {
        setTimeout( function () {
            var _selected_tags = self.DOM.elementsUserSelected( property_name );
            var _target        = _selected_tags[ index ].querySelector( ".shinken-close-icon" );
            _target.click();
        }, timeout );
        return 500;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.numberSelectedElement        = function ( timeout, property_name, number_expected ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'MULTI_SELECT.numberSelectedElement', property_name + " --> " + number_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.elementsUserSelected( property_name ), number_expected );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.isState                      = function ( timeout, property_name, state ) {
        var _to_return = 10;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'MULTI_SELECT.isState', property_name + " --> " + state );
        
        SHINKEN.TOOLS.TEST_AUTO_PROPERTY.TEST.isState( timeout, property_name, state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _text        = "";
            var _plus_status = COMPONENT.CONST.BTN_STATE.OFF;
            switch ( state ) {
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER:
                    _text        = "Valeurs sélectionnées et héritées des modèles";
                    _plus_status = COMPONENT.CONST.BTN_STATE.ON;
                    break;
                case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                    _text = "Par défaut [ Aucun ]";
                    break;
                case PROPERTY.CONST.STATE_PROPERTY.USER_SET:
                    _text = "Valeurs sélectionnées";
                    if ( SHINKEN.TOOLS.TEST_AUTO_PROPERTY.GETTER.saveValue( property_name ) === PROPERTY.CONST.NONE_TO_LINK ) {
                        _text = "Aucun";
                    }
                    break;
            }
            var _dom_selector_title = SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.selector( property_name, PROPERTY.CONST.SELECTOR.MAIN, SHINKEN.TOOLS.TEST_AUTO_PROPERTY.CONST.UNDER_SELECTOR.SELECTOR_TITLE );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_selector_title, _text, "dom_selector_title" );
            self.TEST.plusState( 0, property_name, _plus_status );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.isMainSelectorOptionState    = function ( timeout, property_name, option_name, state ) {
        var selector = SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.selector( property_name, PROPERTY.CONST.SELECTOR.MAIN );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR.TEST.isOptionState( 0, selector, option_name, state );
        }, timeout );
        return 100;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.validUserInteraction         = function ( timeout, property_name ) {
        var _to_return = 0;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'validUserInteraction', property_name );
        SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS", timeout );
        var _dom_list_select  = SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.selector( property_name, PROPERTY.CONST.SELECTOR.MAIN, SHINKEN.TOOLS.TEST_AUTO_PROPERTY.CONST.UNDER_SELECTOR.LIST_SELECT );
        var _dom_filter_input = SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.selector( property_name, PROPERTY.CONST.SELECTOR.MAIN, SHINKEN.TOOLS.TEST_AUTO_PROPERTY.CONST.UNDER_SELECTOR.FILTER_INPUT );
        
        _to_return += SHINKEN.TOOLS.TEST_AUTO_PROPERTY.ACTION.setValue( timeout + _to_return, property_name, "" );
        _to_return += self.TEST.isState( timeout + _to_return, property_name, PROPERTY.CONST.STATE_PROPERTY.INHERITANCE );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( timeout + _to_return, _dom_list_select, SHINKEN.TOOLS.TEST_AUTO_PROPERTY.CONST.UNDER_SELECTOR.LIST_SELECT );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.click( timeout + _to_return, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_SINGLE_SELECT.DOM.mainSelector( property_name, true ) );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( timeout + _to_return, _dom_list_select, SHINKEN.TOOLS.TEST_AUTO_PROPERTY.CONST.UNDER_SELECTOR.LIST_SELECT );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( timeout + _to_return, _dom_filter_input, SHINKEN.TOOLS.TEST_AUTO_PROPERTY.CONST.UNDER_SELECTOR.FILTER_INPUT );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.hasFocus( timeout + _to_return, _dom_filter_input, SHINKEN.TOOLS.TEST_AUTO_PROPERTY.CONST.UNDER_SELECTOR.FILTER_INPUT );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( timeout + _to_return, _dom_filter_input, "test_auto_valid" );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( timeout + _to_return, _dom_filter_input, SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT.getDownEvent(), 3 );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( timeout + _to_return, _dom_filter_input, SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT.getEnterEvent() );
        _to_return += self.TEST.isState( timeout + _to_return, property_name, PROPERTY.CONST.STATE_PROPERTY.USER_SET );
        _to_return += self.TEST.numberSelectedElement( timeout + _to_return, property_name, 1 );
        _to_return += self.ACTION.removeTagInSelectedElement( timeout + _to_return, property_name, 0 );
        _to_return += self.TEST.isState( timeout + _to_return, property_name, PROPERTY.CONST.STATE_PROPERTY.INHERITANCE );
        
        _to_return += SHINKEN.TOOLS.TEST_AUTO_PROPERTY.ACTION.setValue( timeout + _to_return, property_name, "test_auto_valid,test_auto_valid_2,test_auto_valid_3" );
        _to_return += self.TEST.isState( timeout + _to_return, property_name, PROPERTY.CONST.STATE_PROPERTY.USER_SET );
        _to_return += self.TEST.numberSelectedElement( timeout + _to_return, property_name, 3 );
        _to_return += self.ACTION.removeTagInSelectedElement( timeout + _to_return, property_name, 1 );
        _to_return += self.TEST.numberSelectedElement( timeout + _to_return, property_name, 2 );
        _to_return += self.TEST.isState( timeout + _to_return, property_name, PROPERTY.CONST.STATE_PROPERTY.USER_SET );
        
        _to_return += SHINKEN.TOOLS.TEST_AUTO_PROPERTY.ACTION.setValue( timeout + _to_return, property_name, PROPERTY.CONST.CUSTOM_SELECT.NONE );
        _to_return += self.TEST.isState( timeout + _to_return, property_name, PROPERTY.CONST.STATE_PROPERTY.USER_SET );
        
        _to_return += SHINKEN.TOOLS.TEST_AUTO_PROPERTY.ACTION.setValue( timeout + _to_return, property_name, "" );
        SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", timeout + _to_return );
        return _to_return;
    };
    self.TEST.validUserInteractionPlus     = function ( timeout, property_name, is_hidden ) {
        var _to_return = 0;
        if ( is_hidden ) {
            _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( timeout + _to_return, self.DOM.plusButton( property_name ) );
            return _to_return;
        }
        var _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'validUserInteractionPlus', property_name );
        SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS", timeout );
        var _btn_plus = self.DOM.plusButton( property_name );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( timeout + _to_return, _btn_plus );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.click( timeout + _to_return, _btn_plus );
        _to_return += self.TEST.isState( timeout + _to_return, property_name, PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR.ACTION.clickOnOptionProperty( timeout + _to_return, property_name, PROPERTY.CONST.SELECTOR.MAIN, 'test_auto_valid', true );
        _to_return += self.TEST.isState( timeout + _to_return, property_name, PROPERTY.CONST.STATE_PROPERTY.INHERITANCE_AND_USER );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_COMPONENT_SELECTOR.ACTION.clickOnOptionProperty( timeout + _to_return, property_name, PROPERTY.CONST.SELECTOR.MAIN, 'null', true );
        _to_return += self.TEST.isState( timeout + _to_return, property_name, PROPERTY.CONST.STATE_PROPERTY.USER_SET );
        SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", timeout + _to_return );
        return _to_return;
    };
    self.TEST.selectedElementStatus        = function ( timeout, property_name, _to_test ) {
        var _to_return    = 10;
        var _switch_value = __shinken_test_type + "-" + __phase;
        if ( !_to_test ) {
            _to_test = [];
        }
        switch ( _switch_value ) {
            case "00005-1":
                _to_test = [SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_ERROR_DISABLED];
                break;
            case "00010-1":
                switch ( property_name ) {
                    case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                        _to_test = [SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET];
                        break;
                    case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                        _to_test = [SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT];
                        _to_return += 500;
                        break;
                }
                break;
            case "00010-2":
                switch ( property_name ) {
                    case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                        _to_test = [SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET];
                        break;
                    case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                        _to_test = [SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT];
                        _to_return += 1000;
                        break;
                }
                break;
            case "00010-3":
                switch ( property_name ) {
                    case PROPERTY.CONST.NAME.VIEW_CONTACTS:
                        _to_test = [
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET,
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET,
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.DISABLED,
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.NEW,
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET
                        ];
                        break;
                    case PROPERTY.CONST.NAME.EDITION_CONTACTS:
                        _to_test = [
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT,
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT,
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT_DISABLED,
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT_NEW,
                            SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET
                        ];
                        _to_return += 2000;
                        break;
                }
                break;
            case "00015-1":
                _to_test = [
                    SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_VALID,
                    SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_VALID,
                    SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_DISABLED,
                    SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_UNKNWON,
                    SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_UNKNWON,
                    SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_USELESS,
                    SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_NEW
                ];
                _to_return += 3000;
                break;
            case "00025-3":
                _to_test = [SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.IN_WORKING_AREA];
                break;
            case "00024-2":
            case "00025-4":
            case "00026-1":
            case "00026-2":
            case "00026-3":
            case "00026-4":
                _to_test = [SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET];
                break;
            case "00124-1":
                _to_test = [SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.DISABLED, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.NEW, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET];
                break;
            case "00124-2":
                _to_test = [SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.DISABLED, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET, SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.NEW];
                break;
        }
        
        setTimeout( function () {
            var _tags = self.DOM.elementsUserSelected( property_name );
            if ( _to_test.length !== _tags.length ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "testTagStatus ==> Size of element selected [" + _tags.length + "] is not the same than the array to test" + _to_test.length );
                return;
            }
            var _timeout = 0;
            for ( var i = 0, _size_i = _to_test.length; i < _size_i; i++ ) {
                switch ( _to_test[ i ] ) {
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_ERROR_DISABLED:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(255, 0, 0)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ].querySelector( ".shinken-tag-cube" ), "backgroundColor", "rgb(230, 130, 69)" );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_VALID:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(94, 216, 121)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_DISABLED:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(230, 130, 69)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        _timeout += SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _tags[ i ].querySelector( 'tbody' ), 'mouseenter' );
                        SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _( "element.tooltip_disabled" ) );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_UNKNWON:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(247, 243, 243)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        _timeout += SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _tags[ i ].querySelector( 'tbody' ), 'mouseenter' );
                        SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _( "element.tooltip_undefined" ) );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_USELESS:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(193, 193, 193)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        _timeout += SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _tags[ i ].querySelector( 'tbody' ), 'mouseenter' );
                        SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _( "element.tooltip_already_included" ).substring( 0, 25 ) );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USE_NEW:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(255, 239, 58)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        _timeout += SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _tags[ i ].querySelector( 'tbody' ), 'mouseenter' );
                        SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _( "element.tooltip_new" ) );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgba(30, 30, 30, 0.8)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(255, 255, 255)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        _timeout += SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _tags[ i ].querySelector( 'tbody' ), 'mouseenter' );
                        SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _( "element.tooltip_edition_contact_not_expert" ) );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT_DISABLED:
                        if ( __version_shinken < "V02.08.02" ) {
                            break;
                        }
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(255, 255, 255)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        _timeout += SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _tags[ i ].querySelector( 'tbody' ), 'mouseenter' );
                        SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _( "element.tooltip_disabled" ) );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.USER_SET_EDITION_NO_RIGHT_NEW:
                        if ( __version_shinken < "V02.08.02" ) {
                            break;
                        }
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(255, 255, 255)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        _timeout += SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _tags[ i ].querySelector( 'tbody' ), 'mouseenter' );
                        SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _( "element.tooltip_new" ) );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.DISABLED:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(230, 130, 69)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.NEW:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(255, 239, 58)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        break;
                    case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST.TAG.STATUS.IN_WORKING_AREA:
                        SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _tags[ i ], "backgroundColor", "rgb(255, 207, 157)" );
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tags[ i ].querySelector( '.shinken-tag-cube' ), "le cube du tag " + _tags[ i ].innerText );
                        break;
                }
            }
        }, timeout );
        
        return _to_return;
    };
    self.TEST.tagUseCheckCount             = function ( timeout, property_name ) {
        var _to_return    = 10;
        var _switch_value = __shinken_test_type + "-" + __phase;
        var _to_test      = [];
        switch ( _switch_value ) {
            case "00015-1":
                _to_test = [1, 0, 0, 0, 0, 0, 0];
                break;
        }
        
        setTimeout( function () {
            var _tags = self.DOM.elementsUserSelected( property_name );
            if ( _to_test.length !== _tags.length ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "testTagStatus ==> Size of element selected is not the same than the array to test" );
                return;
            }
            for ( var i = 0, _size_i = _tags.length; i < _size_i; i++ ) {
                var _dom_tag_checks = _tags[ i ].querySelector( '.shinken-checks-tag-label' );
                var _to_test_value  = _dom_tag_checks ? parseInt( _dom_tag_checks.innerText ) : 0;
                SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _to_test[ i ], _to_test_value, "check in use for " + _tags.innerText );
            }
        }, timeout );
        
        return _to_return;
    };
    self.TEST.plusState                    = function ( timeout, property_name, state_expected ) {
        setTimeout( function () {
            if ( !MANAGER.__instance_property_distributor.getElement( property_name ).has_plus ) {
                state_expected = COMPONENT.CONST.BTN_STATE.DISABLED;
            }
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'statePlus', "" + state_expected, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.plusButton( property_name ), "DISABLED" );
                    break;
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'statePlus', "" + state_expected, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.plusButton( property_name ).querySelector( '.shinken-btn-plus-option[data-value="ON"]' ), "ON" );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( self.DOM.plusButton( property_name ).querySelector( '.shinken-btn-plus-option[data-value="OFF"]' ), "OFF" );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.DOM.line( property_name ).dataset, 'statePlus', "" + state_expected, '[--1--]' );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( self.DOM.plusButton( property_name ).querySelector( '.shinken-btn-plus-option[data-value="ON"]' ), "ON" );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.plusButton( property_name ).querySelector( '.shinken-btn-plus-option[data-value="OFF"]' ), "OFF" );
                    break;
            }
        }, timeout );
        return 500;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnBtnPlus             = function ( timeout, property_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.plusButton( property_name ) );
        }, timeout );
        return 1000;
    };
    self.ACTION.setBtnPlus                 = function ( timeout, property_name, status ) {
        setTimeout( function () {
            switch ( status ) {
                case COMPONENT.CONST.BTN_STATE.DISABLED:
                    break;
                case COMPONENT.CONST.BTN_STATE.OFF:
                case COMPONENT.CONST.BTN_STATE.ON:
                    if ( parseInt( self.DOM.line( property_name ).dataset.statePlus ) !== status ) {
                        self.ACTION.clickOnBtnPlus( 0, property_name );
                    }
                    break;
            }
        }, timeout );
        return 1000;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT || {} );

SHINKEN.TOOLS.TEST_AUTO_PROPERTY_MULTI_SELECT_CONST = {
    TAG: {
        STATUS: {
            USE_ERROR_DISABLED                : 1,
            USE_VALID                         : 11,
            USE_DISABLED                      : 12,
            USE_UNKNWON                       : 13,
            USE_USELESS                       : 14,
            USE_NEW                           : 15,
            USER_SET                          : 2,
            USER_SET_EDITION_NO_RIGHT         : 3,
            USER_SET_EDITION_NO_RIGHT_DISABLED: 31,
            USER_SET_EDITION_NO_RIGHT_NEW     : 32,
            DISABLED                          : 4,
            NEW                               : 5,
            IN_WORKING_AREA                   : 6
        }
    }
};