SHINKEN.TOOLS.TEST_AUTO_WEATHER = (function ( self ) {
    self.DOM                    = {};
    self.TEST                   = {};
    self.TEST.WIDGET                 = {};
    self.TEST.JS                = {};
    self.ACTION                 = {};
    self.CONST                       = {
        STATE_DISPLAY: {
            HIDDEN              : 0,
            VISIBLE             : 1,
            VISIBLE_AND_DISABLED: 2
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.pageContainer      = function () {
        return document.getElementById( 'id-shinken-page-container' );
    };
    self.DOM.infoBar            = function () {
        return self.DOM.pageContainer().querySelector( '.shinken-info-bar' );
    };
    self.DOM.infoBarShinkenLogo = function () {
        return self.DOM.infoBar().querySelector( '.shinken-logo' );
    };
    self.DOM.infoBarGenerateAt  = function () {
        return self.DOM.infoBar().querySelector( '.shinken-generate-at' );
    };
    self.DOM.infoBarTimer       = function () {
        return self.DOM.infoBar().querySelector( '.shinken-container-clock' );
    };
    self.DOM.getElement       = function (type_element) {
        switch ( type_element ) {
            case 'button_mode_edit':
            case 'button_back_to_previous_preview':
            case 'button_external_links':
            case 'popup_external_links':
                return SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.DOM.getElement(type_element);
            case 'logo_shinken':
                return self.DOM.infoBarShinkenLogo();
            case 'generate_at':
                return self.DOM.infoBarGenerateAt();
            case 'timer_icon':
                return self.DOM.infoBarTimer();
        }
    };
    self.DOM.getAllWidgets       = function () {
        return self.DOM.pageContainer().querySelectorAll(".shinken-widget");
    };
    self.DOM.getAllWidgetsSeparators = function () {
        return self.DOM.pageContainer().querySelectorAll( "[data-type=\"separator_widget\"]" );
    };
    
    self.DOM.getWidgetSeparator = function ( index ) {
        return self.DOM.getAllWidgetsSeparators()[ index ];
    };
    self.DOM.getWidgetTitle     = function () {
        return self.DOM.self.DOM.pageContainer().querySelector( '[data-type="separator_widget"]' );
    };
    self.DOM.getWidgetWeather   = function () {
        return self.DOM.self.DOM.pageContainer().querySelector( "[data-type=\"separator_widget\"]" );
    };
    self.DOM.getWidget          = function ( widget_type, widget_index ) {
        switch ( widget_type ) {
            case WIDGET.CONST.TYPE.SEPARATOR:
                return self.DOM.getWidgetSeparator( widget_index );
            case WIDGET.CONST.TYPE.TITLE:
                return self.DOM.getWidgetTitle();
            case WIDGET.CONST.TYPE.WEATHER:
                return self.DOM.getWidgetWeather( widget_index );
        }
    };
    self.DOM.getWidgetArea      = function ( widget_type, widget_index, widget_area ) {
        var _dom = self.DOM.getWidget( widget_type, widget_index );
        switch ( widget_area ) {
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY:
                return _dom.querySelector( '.shinken-cell-left' );
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA._KEY:
                return _dom.querySelector( '.shinken-cell-right' );
            case WIDGET.CONST.PARAM.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY:
                return _dom.querySelector( '.shinken-widget-separator-title' );
        }
    };
    
    
    //self.DOM.getWidgetTitleTitleArea       = function () {
    //    return self.DOM.getWidgetTitle().querySelector(".shinken-widget-title-content");
    //};
    //self.DOM.getWidgetWeatherNameArea       = function () {
    //    return self.DOM.getWidgetWeather().querySelector(".shinken-widget-title-content");
    //};
    
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.displayState = function ( timeout, type_element, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayState', state, type_element );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getElement(type_element);
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "1" );
                    break;
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, type_element );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "pointerEvents", 'none' );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.3" );
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.countWidget = function ( timeout, total_number_element_expected ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.countWidget', total_number_element_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.getAllWidgets(), total_number_element_expected, "total number widget" );
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.stateArea     = function ( timeout, widget_type, widget_index, widget_area, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.areaWidgetSeparatorState', widget_area + " --> " + state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_element = self.DOM.getWidgetArea( widget_type, widget_index, widget_area );
            
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom_element, "width", 0 );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_element, widget_area );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.textColor = function ( timeout, widget_type, widget_index, widget_area, color ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.changeColorInTitleArea' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getWidgetArea( widget_type, widget_index, widget_area ), "color", color );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.textAlign = function ( timeout, widget_type, widget_index, widget_area, alignment ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.changeColorInTitleArea' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getWidgetArea( widget_type, widget_index, widget_area ), "text-align",alignment );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    //********************************************  ACTION   **************************************************//
    //********************************************  CONSTANT **************************************************//
    self.CONST = {
        STATE_DISPLAY: {
            HIDDEN : 0,
            VISIBLE: 1,
            VISIBLE_AND_DISABLED: 2
        }
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WEATHER || {} );
