//__lib__ lib_common
'use strict';

COMPONENT.InputWithDropDown           = function ( dom_element, parent, use_quotes, type ) {
    // dom_element
    // current_value
    // original_value
    // placeholder
    // is_protected
    // is_resizable
    this.init( dom_element, parent, use_quotes, type );
};
COMPONENT.InputWithDropDown.prototype = {
    init                       : function ( dom_element, parent, use_quotes, type ) {
        this.parent = parent;
        this.initCounters( parent );
        this.type            = type;
        this.dom_element     = dom_element;
        this.uuid            = SHINKEN.TOOLS.STRING.buildUUID();
        this.input           = new COMPONENT.Input( this.dom_element.querySelector( '.shinken-input-table' ), parent || this, true );
        this.select          = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container' ), PROPERTY.CONST.TYPES.SINGLE_SELECT, false, this, false, true );
        this.separators      = this.dom_element.dataset.separator.split( "$^$" );
        this.separator_regex = new RegExp( "[" + this.separators.join( "" ) + "]" );
        if ( use_quotes == undefined ) {
            use_quotes = false;
        }
        this.use_quotes = !!use_quotes;
    },
    //********************************************  EVENT LISTENER  **************************************************//
    keydown                    : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.select.moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.select.moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.select.validSelectedOrFirstElement();
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, key_code ) ) {
                    event.preventDefault();
                    event.stopPropagation();
                }
        }
    },
    askComputeAfterChange      : function ( dom_element, parent ) {
        this.input.askComputeAfterChange( dom_element, parent || this );
    },
    clickOnItemSelector        : function ( parent_name, key_name, event ) {
        if ( event ) {
            event.stopPropagation();
        }
        var _previous_value     = this.input.getValue();
        var first_part          = _previous_value.substring( 0, this.first_separator );
        var second_part         = _previous_value.substring( this.last_separator, _previous_value.length );
        var _is_specific_option = false;
        if ( event ) {
            var _parent_dom = DOM.Service.findParentElementWithDataSet( event.target, 'type', 10 );
            if ( _parent_dom && _parent_dom.dataset.type === 'is-always-visible' ) {
                _is_specific_option = true;
            }
        }
        if ( _is_specific_option ) {
            this.input.setValueFromJs( key_name );
        }
        else {
            this.input.setValueFromJs( first_part + key_name + second_part );
        }
        this.setCurrentFilter( true );
    },
    clickOnInput               : function () {
        this.setCurrentFilter();
    },
    //********************************************  SETTER GETTER   **************************************************//
    setIsProtected             : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? "password" : this.type );
    },
    setPlaceholder             : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        this.placeholder = to_set;
        this.input.setPlaceholder( to_set );
    },
    setValidationRules         : function ( _to_set ) {
        this.input.setValidationRules( _to_set );
    },
    hasBeenChanged             : function () {
        return this.current_value !== this.original_value;
    },
    getParentName              : function () {
        return this.parent.getParentName();
    },
    getChildrenObject              : function () {
        return [ this.input ];
    },
    getValue                   : function () {
        return this.input.getValue();
    },
    setValueFromJs             : function ( to_set ) {
        this.input.setValueFromJs( to_set );
    },
    getFinalValue              : function () {
        if ( this.timeout_ask_compute_after_change ) {
            clearTimeout( this.timeout_ask_compute_after_change );
            this.computeAfterChange();
        }
        return this.getValue();
    },
    setCurrentFilter           : function ( focus_on_last_separator, bypass_do_filter, validation_done ) {
        if ( this.select.list_element.list.length > 0 ) {
            this.select.openSelector();
        }
        var _value           = this.input.getValue();
        var _previous_filter = this.current_filter ? this.current_filter : "";
        var _cursor_position = this.input.dom_element.selectionStart;
        this.first_separator = 0;
        this.last_separator  = _value.length;
        
        var _in_quotes = false;
        for ( var i = 0; i < _cursor_position; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.first_separator = i + 1;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        for ( i = _cursor_position; i < _value.length; i++ ) {
            if ( SHINKEN.TOOLS.ARRAY.contains( this.separators, _value[ i ] ) && !this.isReallyInQuotes( _in_quotes ) ) {
                this.last_separator = i;
                break;
            }
            if ( _value[ i ] === '"' ) {
                _in_quotes = !_in_quotes;
            }
        }
        
        if ( (this.first_separator) >= this.last_separator ) {
            this.current_filter = "";
        }
        else {
            this.current_filter = _value.substring( this.first_separator, this.last_separator ).trim();
        }
        if ( focus_on_last_separator ) {
            this.input.restoreCursorLocation( this.last_separator );
        }
        
        if ( SHINKEN.TOOLS.STRING.startsWith( this.current_filter, "=" ) ) {
            this.current_filter = this.current_filter.substring( 1 );
        }
        if ( this.use_quotes ) {
            this.current_filter = this.current_filter.replace( /"/g, '' );
        }
        this.select.setResearchDisplay( this.current_filter );
        if ( !bypass_do_filter || this.current_filter !== _previous_filter ) {
            this.select.doFilter( this.current_filter );
        }
        if ( !validation_done ) {
            this.validateValueInput();
        }
    },
    hasAutoSelect              : function () {
        return this.select.hasAutoSelect();
    },
    getDataSetLink             : function () {
        return this.select.getDataSetLink();
    },
    getListElement             : function () {
        return this.select.getListElement();
    },
    getStatus                  : function () {
        return this.input.getStatus();
    },
    //********************************************  COMPUTE   **************************************************//
    addValidationRule          : function ( to_add, type ) {
        this.input.addValidationRule( to_add, type );
    },
    computeAfterChange         : function ( validation_done ) {
        this.setCurrentFilter( false, !this.input.need_validation, validation_done );
    },
    //********************************************  UPDATE VIEW   **************************************************//
    hidePopup                  : function () {
        this.select.hidePopup();
    },
    //********************************************  VALIDATION   **************************************************//
    validSelectedOrFirstElement: function () {
        this.select.validSelectedOrFirstElement();
    },
    validateValueInput         : function () {
        this.input.validateValueInput();
    },
    finishActionBeforeReload   : function () {
        this.input.finishActionBeforeReload();
    },
    doActionAfterChange        : function () {
        this.computeAfterChange();
    },
    isReallyInQuotes           : function ( in_quotes ) {
        return this.use_quotes ? in_quotes : false;
    },
    //********************************************  OTHERS *****************************************************//
    applySiblingSettings : function (component) {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputWithDropDown, SHINKEN.OBJECT.CounterInterface );