//__lib__ lib_common
'use strict';
SHINKEN_LIST.Lines           = function ( dom_element, type ) {
    //contents
    //mapping
    //mapping_parents
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Lines.prototype = {
    init               : function ( dom_element ) {
        this.initContents( dom_element.querySelectorAll( '.shinken-list-line' ) );
    },
    initContents       : function ( dom_elements ) {
        this.contents        = [];
        this.mapping         = {};
        this.mapping_parents = {};
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.add( dom_elements[ i ] );
        }
    },
    addMappingParent   : function ( parent_uuid, uuid ) {
        if ( !parent_uuid ) {
            if ( !this.mapping_parents[ uuid ] ) {
                this.mapping_parents[ uuid ] = [];
            }
        }
        else {
            if ( !this.mapping_parents[ parent_uuid ] ) {
                this.mapping_parents[ parent_uuid ] = [];
            }
            this.mapping_parents[ parent_uuid ].push( this.mapping[ uuid ] );
        }
    },
    removeMappingParent: function ( parent_uuid, _to_remove ) {
        if ( parent_uuid ) {
            SHINKEN.TOOLS.ARRAY.removeElement( this.mapping_parents[ parent_uuid ], _to_remove );
        }
    },
    add                : function ( dom_element ) {
        var _to_add = new SHINKEN_LIST.Line( dom_element, this.type );
        this.contents.push( _to_add );
        this.mapping[ _to_add.getUUID() ] = _to_add;
        this.addMappingParent( _to_add.parent_uuid, _to_add.uuid );
    },
    remove             : function ( uuid ) {
        var _to_remove = this.mapping[ uuid ];
        delete this.mapping[ uuid ];
        this.removeMappingParent( _to_remove.parent_uuid, _to_remove );
        SHINKEN.TOOLS.ARRAY.removeElement( this.contents, _to_remove );
    },
    getByUUID          : function ( uuid ) {
        return this.mapping[ uuid ];
    },
    //********************************************  COLLAPSE  *****************************************************//
    toggleCollapse      : function ( uuid ) {
        this.mapping[ uuid ].toggleCollapse( this.mapping_parents[ uuid ] );
    },
    setIsCollapseAllData: function ( to_set ) {
        var _keys = Object.keys( this.mapping_parents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.mapping[ _current_key ].setIsCollapsed( to_set, this.mapping_parents[ _current_key ] );
        }
    },
    //********************************************  SELECTION  *****************************************************//
    setSelectAllData       : function ( to_set ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setIsSelected( to_set );
        }
    },
    getNbSelected          : function () {
        return this.getSelected().length;
    },
    getSelected            : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].isSelected() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    getNotSelected         : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].is_selected !== SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    setAllLinesDataSet     : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
        }
    },
    isAllActiveLineSelected: function () {
        var _nb_active = 0;
        var _current;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ].isSelectedOrFiltered();
            switch ( _current ) {
                case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                    _nb_active++;
                    break;
                case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                    return false;
            }
        }
        return !!_nb_active;
    },
    //********************************************  FILTERS  *****************************************************//
    applyFilter               : function ( filters ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].applyFilter( filters );
        }
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.filterParentWithNoChildren();
                break;
        }
    },
    filterParentWithNoChildren: function () {
        var _current;
        var _filter;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered !== SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN ) {
                continue;
            }
            if ( _current.parent_uuid ) {
                continue;
            }
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            for ( var j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
                if ( this.contents[ j ].parent_uuid === _current.getUUID() && this.contents[ j ].is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.OFF ) {
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
                    break;
                }
            }
            _current.setFilter( _filter );
        }
    },
    hideAllLines              : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setFilter( SHINKEN_LIST.CONST.FILTER.STATUS.ON );
        }
    },
    getNotFiltered            : function () {
        var _to_return = [];
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( !this.contents[ i ].isFiltered() ) {
                _to_return.push( this.contents[ i ] );
            }
        }
        return _to_return;
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave  : function ( type ) {
        var _to_return = type === CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE ? {} : [];
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.isSelected() ) {
                switch ( this.type ) {
                    case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                        switch ( type ) {
                            case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                                _current_data = _current.getDataToSave( type );
                                if ( !_to_return[ _current.host.getUUID() ] ) {
                                    _to_return[ _current.host.getUUID() ] = [];
                                }
                                _to_return[ _current.host.getUUID() ].push( _current_data );
                                break;
                            
                            default:
                                _to_return.push( _current.getDataToSave( type ) );
                                break;
                        }
                        break;
                    default:
                        _to_return.push( _current.getDataToSave( type ) );
                        break;
                }
            }
        }
        return _to_return;
    },
    getDataToExport: function ( headers ) {
        var _to_return = [];
        var _to_add;
        var _current;
        var _current_data;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( _current.is_filtered ) {
                continue;
            }
            _to_return.push( _current.getDataToExport( headers ) );
        }
        return _to_return;
    }
};