//priority 10
//__lib__ lib_common
var CLIPBOARD_SERVICE = (function ( self ) {
    "use strict";
    self.dom_textarea     = null;
    self.dom_parent       = null;
    self.dom_button       = null;
    self.dom_text_to_copy = null;
    self.type             = null;
    
    self.TYPE      = {};
    self.TYPE.TEXT = 'text';
    self.TYPE.HTML = 'html';
    
    self.setContent = function ( dom_event, value ) {
        var _dom_button = DOM.Service.findParentElementWithClass( dom_event, 'shinken-button', 10 );
        setValueTextArea( value );
        self.dom_textarea.select();
        var status = false;
        try {
            status = document.execCommand( 'copy' );
            displayResult( status, _dom_button );
            setValueTextArea( '' );
        }
        catch ( err ) {
            console.log( 'Unable to copy.' );
        }
    };
    init();
    
    //private
    function init () {
        setTimeout( function () {
            createDomTextArea();
        }, 1000 );
    }
    
    function createDomTextArea () {
        self.dom_textarea    = document.createElement( 'textarea' );
        self.dom_textarea.id = 'id-shinken-copy-clipboard-container';
        var _body            = document.querySelector( 'body' );
        _body.appendChild( self.dom_textarea );
    }
    
    
    function setValueTextArea ( to_set ) {
        self.dom_textarea.value = to_set;
    }
    
    
    function displayResult ( status, dom_button ) {
        var _text     = status ? _( 'copy_service.copySuccess' ) : _( 'copy_service.copyFail' );
        var _state    = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        var _position = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, _position, 2000 );
    }
    
    
    return self;
    
})( {} );