//__lib__ lib_common
'use strict';

SHINKEN_GRID.Cell           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cell.prototype = {
    init: function ( data ) {
        this.position_x = 0;
        this.position_y = 0;
        this.content    = "";
        this.class      = "shinken-grid-cell shinken-draggable";
        this.type       = "default";
        this.uuid       = SHINKEN.TOOLS.STRING.buildUUID();
        this.updateData( data );
    },
    
    //********************************************  EVENT LISTENER  *****************************************************//
    getClosestPosition: function () {
        var _x = DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.LEFT );
        var _y = DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.TOP );
        //TODO GREG A OPTIMISER
        this.setPosition( Math.round( _x / this.tile_pixel_size ), Math.round( _y / this.tile_pixel_size ) );
    },
    setPosition       : function ( new_x, new_y ) {
        this.position_x = Math.max( 0, Math.min( this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ] - this.getComputedWidth(), new_x ) );
        this.position_y = Math.max( 0, new_y );
        DOM.Service.setStyles( this.dom_element, { "top": this.position_y * this.tile_pixel_size, "left": this.position_x * this.tile_pixel_size } );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildrenObject    : function () {
        return [this.content];
    },
    getChildrenObjectDict: function () {
        var _to_return                                           = {};
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ] = this.content;
        return _to_return;
    },
    _getObjectToJson     : function () {
        var _to_return                                              = {};
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ] = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ];
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ] = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ];
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ]      = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ];
        _to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ];
        return _to_return;
    },
    //********************************************  OTHERS  *****************************************************//
    
    //********************************************  COMPUTE  *****************************************************//
    computeMapping: function ( mapping ) {
        if ( this.content ) {
            this.content.computeMapping( mapping );
        }
    },
    updateSize    : function ( tile_pixel_size ) {
        this.tile_pixel_size = tile_pixel_size;
        DOM.Service.setStyles( this.dom_element, this.getStyle() );
        this.dom_element.className = this.getClass();
        this.content.updateSize();
    },
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  FORM  *****************************************************//
    //********************************************  HTML   **************************************************//
    
    computeHtml     : function ( shinken_grid, extra_class ) {
        if ( extra_class ){
            this.class += " " + extra_class;
        }
        this.tile_pixel_size                                                  = shinken_grid.tile_pixel_size;
        this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = shinken_grid[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ];
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = shinken_grid[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ];
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = shinken_grid[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ];
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = shinken_grid[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ];
        
        this.dom_element = DOM.Service.createElement( "div", this.getAttribute() );
        
        var _to_add_container = DOM.Service.createElement( "div", { class: 'shinken-grid-cell-container shinken-height-100' } );
        
        
        DOM.Service.addElementTo( _to_add_container, this.dom_element );
        DOM.Service.addElementTo( this.dom_element, shinken_grid.dom_element );
        this.content.setDomElementParent( _to_add_container );
        this.content.computeHtml( this.tile_pixel_size * this.getComputedWidth(), this.tile_pixel_size * this.height );
    },
    getAttribute    : function () {
        var _to_return = {
            class: this.getClass(),
            style: DOM.Service.styleToHtml( this.getStyle() ),
            id   : this.uuid
        };
        //if ( this.type === 'default' ) {
        //    _to_return[ "onmousedown" ] = "MANAGER.DragNDropManager.dragStartSingle(event)";
        //    _to_return[ "onmouseup" ]   = "CONTROLLER.Weather.computeNewPosition('" + this.uuid + "');";
        //}
        return _to_return;
    },
    getClass        : function () {
        var _to_return     = this.class;
        var _computed_size = this.tile_pixel_size * this.getComputedWidth();
        //_to_return += " " + DOM.Service.computeWidthClass( _computed_size );
        return _to_return;
    },
    getComputedWidth: function () {
        return this.width === "all" ? this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ] : this.width;
    },
    getStyle        : function () {
        var _to_return                       = {};
        _to_return[ DOM.CONST.STYLE.WIDTH ]  = this.tile_pixel_size * this.getComputedWidth();
        _to_return[ DOM.CONST.STYLE.HEIGHT ] = this.tile_pixel_size * this.height;
        _to_return[ DOM.CONST.STYLE.TOP ]    = this.tile_pixel_size * this.position_y;
        _to_return[ DOM.CONST.STYLE.LEFT ]   = this.tile_pixel_size * this.position_x;
    
        var _padding = parseInt( DOM.BodyService.getWidth() * this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] / 100 );
        if ( !_to_return[ DOM.CONST.STYLE.WIDTH ]  || ! _to_return[ DOM.CONST.STYLE.HEIGHT ] ){
            _padding = 0;
        }
        else {
            if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] !== SHINKEN_GRID.CONST.SPECIAL_VALUE.SEPARATION_GRID_ELEMENT_MAX_UNLIMITED ) {
                _padding = Math.min( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] );
            }
            _padding                              = Math.max( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ] );
            
        }
        _to_return[ DOM.CONST.STYLE.PADDING ] = _padding / 2;
        return _to_return;
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateData : function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData    : function ( key, value ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.SHINKEN_GRID_CELL_UUID:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH:
                this[ key ] = value;
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT:
                this.initContent( value );
                break;
            case SHINKEN.OBJECT.CONST.VALIDATION.FIELD.MESSAGES:
                this.setMessages( value );
                break;
        }
    },
    initContent: function ( data ) {
        this.content = WIDGET.factory( data );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.InterfaceHtml );

