//__lib__ lib_common
'use strict';

SHINKEN_GRID.Grids           = function ( default_values ) {
    //content = []
    //mapping_uuid_content = {}
    this.default_values = default_values;
};
SHINKEN_GRID.Grids.prototype = {
    init: function ( data ) {
        this.content = [];
        this.type    = null;
        this._initGrid( data );
        this._computeMapping();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    computeNewPosition: function ( uuid ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeNewPosition( uuid );
        }
    },
    onMouseMove       : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, 'shinken-parent-mouse-move-listener', 30 );
        if ( !_parent_dom_element ) {
            return;
        }
        this.getGridByUUID( _parent_dom_element.dataset.gridUuid ).onMouseMove( event );
    },
    onMouseLeave      : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( event.target, 'shinken-parent-mouse-leave-listener', 30 );
        if ( !_parent_dom_element ) {
            return;
        }
        this.getGridByUUID( _parent_dom_element.dataset.gridUuid ).onMouseLeave( event );
    },
    onScroll          : function ( event ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].onScroll( event );
        }
    },
    mouseWheel        : function ( event ) {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].mouseWheel( event );
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setType          : function ( to_set ) {
        this.type = to_set;
    },
    getGridByUUID    : function ( grid_uuid ) {
        return SHINKEN.TOOLS.ARRAY.findFirstElementWith( this.content, 'uuid', grid_uuid );
    },
    getChildrenObject: function () {
        return this.content;
    },
    getChildrenObjectDict   : function () {
        return this.content;
    },
    //********************************************  COMPUTE  *****************************************************//
    _computeMapping: function () {
        this.mapping_uuid_content = {};
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeMapping( this.mapping_uuid_content );
        }
    },
    computeSizes   : function () {
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeSizes();
        }
    },
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  HTML   **************************************************//
    computeHtml: function ( dom_parent ) {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-grids" } );
        DOM.Service.addElementTo( this.dom_element, dom_parent );
        for ( var i = 0, _size_i = this.content.length; i < _size_i; i++ ) {
            this.content[ i ].computeHtml( this.dom_element );
        }
    },
    //********************************************  UPDATE DATA   **************************************************//
    reset            : function () {
        this.content = [];
        DOM.Service.removeElement( this.dom_element );
    },
    _initGrid        : function ( data ) {
        for ( var i = 0, _size_i = data.length; i < _size_i; i++ ) {
            this.content.push( new SHINKEN_GRID.Grid( this.default_values, data[ i ] ) );
        }
    },
    updateContentData: function ( data ) {
        var _keys = Object.keys( data );
        var _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( this.mapping_uuid_content[ _current_key ] ) {
                for ( var j = 0, _size_j = this.mapping_uuid_content[ _current_key ].length; j < _size_j; j++ ) {
                    this.mapping_uuid_content[ _current_key ][ j ].updateData( data[ _current_key ] );
                }
            }
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grids, SHINKEN.OBJECT.ShinkenObjectJson );