SHINKEN_MODAL = (function ( self ) {
    "use strict";
    self.PLACEMENT              = {};
    self.PLACEMENT.LEFT         = 'left';
    self.PLACEMENT.RIGHT        = 'right';
    self.PLACEMENT.TOP          = 'top';
    self.PLACEMENT.TOP_LEFT     = 'top-left';
    self.PLACEMENT.TOP_RIGHT    = 'top-right';
    self.PLACEMENT.BOTTOM       = 'bottom';
    self.PLACEMENT.BOTTOM_LEFT  = 'bottom-left';
    self.PLACEMENT.BOTTOM_RIGHT = 'bottom-right';
    self.PLACEMENT.MARGIN       = 0;
    
    self.DOM_STYLE      = {};
    self.DOM_STYLE.TOP  = 'top';
    self.DOM_STYLE.LEFT = 'left';
    
    self.DEFAULT           = {};
    self.DEFAULT.TIMER_POP = 100;
    self.MAX_TRY_IN_SCREEN = 10;
    
    self.TYPE                      = {};
    self.TYPE.SLA_THRESHOLD        = "shinken-sla-threshold";
    self.TYPE.SLA_THRESHOLD_DAYS   = "shinken-sla-threshold-days";
    self.TYPE.SLA_THRESHOLD_WIDGET = "shinken-sla-threshold-widget";
    
    var __id_element_to_bind;
    var __classes_added;
    var __container;
    var __dom_modal;
    var __pos_top;
    var __pos_left;
    var __width;
    var __height;
    var __timeout_pop;
    var __timer_pop;
    var __placement;
    var __type;
    var __has_modal    = false;
    var ___margin_top  = false;
    var ___margin_left = false;
    
    self.toggleModal = function ( event, dom_element ) {
        event.stopPropagation();
        if ( !dom_element ) {
            return;
        }
        var _id = dom_element.getAttribute( 'shi-mod-id' );
        
        if ( __id_element_to_bind && __id_element_to_bind !== _id ) {
            self.cleanModal();
        }
        
        if ( !__id_element_to_bind || __id_element_to_bind !== _id ) {
            setIdElementToBind( _id );
            bindModalToDomElement( dom_element );
            dom_element.classList.add( "shinken-modal-active" );
        }
        else {
            self.cleanModal();
        }
    };
    
    self.cleanModal           = function () {
        if ( __id_element_to_bind ) {
            var _old_dom = document.querySelector( '[shi-mod-id="' + __id_element_to_bind + '"]' );
            if ( _old_dom ) {
                _old_dom.classList.remove( "shinken-modal-active" );
            }
        }
        setActive( false );
        __container.style.top  = '-500px';
        __container.style.left = '-500px';
        __id_element_to_bind   = '';
        __dom_modal.innerHTML  = '';
        clearTimeout( __timeout_pop );
    };
    self.setValue             = function ( to_set ) {
        __dom_modal.innerHTML = to_set;
    };
    self.getCurrentType       = function () {
        return __type;
    };
    self.hasActiveModal       = function () {
        return __has_modal;
    };
    self.isCurrentActiveModal = function ( id ) {
        return __id_element_to_bind === "" + id;
    };
    
    // private
    function bindModalToDomElement ( dom_element ) {
        init( dom_element );
        self.setValue( dom_element.getAttribute( 'shi-mod-html' ) );
        getSize();
        setPosition( dom_element );
        
        setTimeout( function () {
            setActive( true );
        }, __timer_pop );
    }
    
    function init ( dom_element ) {
        if ( !__container ) {
            __container = document.querySelector( '#shinken-modal-container' );
        }
        __dom_modal = __container.querySelector( '.shinken-modal' );
        __placement = dom_element.getAttribute( 'shi-mod-placement' );
        
        setType( dom_element );
        setTimerPop( dom_element );
    }
    
    function setIdElementToBind ( id ) {
        __id_element_to_bind = id;
    }
    
    
    function setActive ( _bool ) {
        __has_modal = _bool;
        if ( _bool ) {
            __container.classList.add( 'shinken-modal-active' );
        }
        else {
            __container.classList.remove( 'shinken-modal-active' );
        }
    }
    
    function setTimerPop ( element ) {
        __timer_pop = element.getAttribute( 'shi-mod-timer-pop' ) || self.DEFAULT.TIMER_POP;
    }
    
    function setType ( element ) {
        __type                        = element.getAttribute( 'shi-mod-type' ) || false;
        __container.dataset.modalType = __type;
    }
    
    function computeMarginPosition () {
        switch ( __type ) {
            case self.TYPE.SLA_THRESHOLD:
            case self.TYPE.SLA_THRESHOLD_DAYS:
            case self.TYPE.SLA_THRESHOLD_WIDGET:
                ___margin_top  = 5;
                ___margin_left = 5;
                break;
            default:
                ___margin_top  = self.PLACEMENT.MARGIN;
                ___margin_left = self.PLACEMENT.MARGIN;
                break;
        }
    }
    
    function setPosition ( element_to_bind ) {
        if ( !__placement ) {
            __placement = self.PLACEMENT.TOP;
        }
        
        var _rect       = element_to_bind.getBoundingClientRect();
        var _width_rect = cleanRectWidth( _rect );
        if ( !_width_rect ) {
            return; //ELEMENT NOT DISPLAYED
        }
        computeMarginPosition();
        
        switch ( __placement ) {
            case self.PLACEMENT.TOP:
                __pos_top  = (_rect.top - __height - ___margin_top);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.TOP_LEFT:
                __pos_top  = (_rect.top - __height - ___margin_top);
                __pos_left = (_rect.left - (__width / 2) * 5 / 3 + _width_rect / 2 - ___margin_left);
                break;
            case self.PLACEMENT.TOP_RIGHT:
                __pos_top  = (_rect.top - __height - ___margin_top);
                __pos_left = (_rect.left + _width_rect / 2 - (__width / 6) + ___margin_left);
                break;
            case self.PLACEMENT.LEFT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left - __width - ___margin_left);
                break;
            case self.PLACEMENT.RIGHT:
                __pos_top  = (_rect.top + _rect.height / 2 - __height / 2);
                __pos_left = (_rect.left + _width_rect + ___margin_left);
                break;
            case self.PLACEMENT.BOTTOM:
                __pos_top  = (_rect.bottom + ___margin_top);
                __pos_left = (_rect.left + _width_rect / 2 - __width / 2);
                break;
            case self.PLACEMENT.BOTTOM_LEFT:
                __pos_top  = (_rect.bottom + ___margin_top);
                __pos_left = (_rect.left - (__width / 2) * 5 / 3 + _width_rect / 2 - ___margin_left);
                break;
            case self.PLACEMENT.BOTTOM_RIGHT:
                __pos_top  = (_rect.bottom + ___margin_top);
                __pos_left = (_rect.left + _width_rect / 2 - (__width / 6) + ___margin_left);
                break;
        }
        
        if ( isInScreen() ) {
            __timeout_pop = setTimeout( function () {
                __container.style.top  = __pos_top + 'px';
                __container.style.left = __pos_left + 'px';
            }, __timer_pop );
        }
        else {
            setPosition( element_to_bind );
        }
    }
    
    function cleanRectWidth ( _rect ) {
        var _to_return = Math.min( _rect.width, 600 );
        if ( __classes_added ) {
            if ( __classes_added.indexOf( '300' ) !== -1 ) { //BGL  A REFAIRE PROPRE
                _to_return = Math.min( _to_return, 300 );
            }
        }
        return _to_return;
    }
    
    function getSize () {
        var _sizes = __dom_modal.getBoundingClientRect();
        __width    = _sizes.width;
        __height   = _sizes.height;
    }
    
    function isInScreen () {
        var _to_return        = true;
        var _placement_origin = __placement;
        var _try              = 0;
        if ( __pos_left < -10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.RIGHT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( (__pos_left + __width) > window.innerWidth - 10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.TOP_LEFT:
                case self.PLACEMENT.RIGHT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
            }
        }
        else if ( __pos_top < -10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.TOP:
                    __placement = self.PLACEMENT.BOTTOM;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.TOP_LEFT:
                    __placement = self.PLACEMENT.BOTTOM_LEFT;
                    break;
                case self.PLACEMENT.TOP_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.BOTTOM_RIGHT;
                    break;
            }
        }
        else if ( (__pos_top + __height) > window.innerHeight - 10 ) {
            _to_return = false;
            switch ( __placement ) {
                case self.PLACEMENT.BOTTOM:
                    __placement = self.PLACEMENT.TOP;
                    break;
                case self.PLACEMENT.LEFT:
                case self.PLACEMENT.BOTTOM_LEFT:
                    __placement = self.PLACEMENT.TOP_LEFT;
                    break;
                case self.PLACEMENT.BOTTOM_RIGHT:
                case self.PLACEMENT.RIGHT:
                    __placement = self.PLACEMENT.TOP_RIGHT;
                    break;
            }
        }
        _try++;
        if ( _try > self.MAX_TRY_IN_SCREEN ) { //CASE WHERE THE TOOLTIP HAS NO PLACE TO BE DISPLAYED
            __placement = _placement_origin;
            _to_return  = true;
        }
        return _to_return;
    }
    
    return self;
})( {} );