#!/bin/bash


if [[ $EUID != 0 ]]; then
    printf "\033[31m Error: please launch this script as root\033[0m\n"
    exit 2
fi

if [[ ! -f lib/install_lib/patch.conf ]]; then
    printf "\033[31m Error: please launch the patch from its directory\033[0m\n"
    exit 2
fi

. lib/install_lib/patch.conf

. lib/common.sh

assert_dir_versions_and_patch_installations_exists

mkdir -p "${LOG_PATH}"

args_list=""
for arg in "$@"; do
    args_list="$args_list \"$arg\""
done

# The script command do not manage the -e on centos 7, so try it before run the real script call
script_arg=" -e "
script -e -c 'ls > /dev/null' -q 2>/dev/null
if [ $? != 0 ];then
   script_arg=""
   echo "Please Note that the install-patch.sh return exit code is only available on centos 7."
fi

# Real launch
script $script_arg -c "lib/install_lib/install-patch.sh $args_list" -q "${LOG_PATH}/shinken.enterprise.patch.log"
# The exit will be valid only for centos7
exit $?
