import datetime
import time
from django.conf import settings
from graphite.render.grammar import grammar
from graphite.render.datalib import fetchData, TimeSeries
from graphite.logger import log

def evaluateTarget(requestContext, target, search_by_name=True):
  tokens = grammar.parseString(target)
  # log.info('/RENDER: evaluateTarget:: tokens:%s' % tokens)
  result = evaluateTokens(requestContext, tokens, search_by_name=search_by_name)

  if type(result) is TimeSeries:
    return [result] #we have to return a list of TimeSeries objects

  else:
    return result


def evaluateTokens(requestContext, tokens, search_by_name=True):
  if tokens.expression:
    return evaluateTokens(requestContext, tokens.expression, search_by_name=search_by_name)

  elif tokens.pathExpression:
    return fetchData(requestContext, tokens.pathExpression, search_by_name=search_by_name)

  elif tokens.call:
    func = SeriesFunctions[tokens.call.func]
    args = [evaluateTokens(requestContext, arg, search_by_name=search_by_name) for arg in tokens.call.args]
    return func(requestContext, *args)

  elif tokens.number:
    if tokens.number.integer:
      return int(tokens.number.integer)

    elif tokens.number.float:
      return float(tokens.number.float)

  elif tokens.string:
    return str(tokens.string)[1:-1]

  elif tokens.boolean:
    return tokens.boolean[0] == 'true'


#Avoid import circularities
from graphite.render.functions import SeriesFunctions
