<?php
/*******************************************************************************
 *
 * CoreAuthorisationModMultisite.php - Authorsiation module based on the
 *                                     permissions granted in Check_MK multisite
 *
 * Copyright (c) 2004-2016 NagVis Project (Contact: info@nagvis.org)
 *
 * License:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************/

class CoreAuthorisationModShinken extends CoreAuthorisationModule {
    public $rolesConfigurable = false;
    private $auth;

    public function __construct() {
        //echo "<br />construct";
    }

    public function parsePermissions($sUsername = null) {
        global $CORE;
        if ($sUsername !== null) {
            die('parsePermissions() with username is not supported');
        }
        $perms = array(
            'General'  => array('*' => array('*' => true)),
            //'User'     => array('setOption' => array('*' => true)),
            'Search'   => array('view' => array('*' => true)),
            'Rotation' => array('view' => array('*' => true)),
            'Overview' => array('view' => array('*' => true)),
            'Auth'     => array('logout' => array('*' => true)),
            'MainCfg'  => array('edit' => array('*' => true)),
            //'*'  => array('*' => array('*' => true)),
        );
        $perms['Overview']['edit']  = array('*' => true);
        $perms['Map']['view']    = array('*' => true);

        return $perms;
    }

    public function getUserRoles($userId) {
        // $userId is now the username
        return array();
        die("getUserRoles($userId)");
        return array(0 => array('name' => 'Administrators'));
        // [ { roleId, name }, ... ]
    }

    public function getAllRoles() {
        // die('getAllRoles');
        // User menu -> Manage Users
        return array();
        // [ { roleId, name }, ... ]
    }

    // I want to get rid of those :(
    public function isPermitted($sModule, $sAction, $sObj = null) {
        die("isPermitted($sModule, $sAction, $sObj) - should never be called");
        return false;
    }

    public function deletePermission($mod, $name) {
        return false;
        // $mod -> Map, Rotation
    }

    public function createPermission($mod, $name) {
        return false;
    }

    public function roleUsedBy($roleId) {
        die("roleUsedBy($roleId)");
        return array();
        // [ name , ... ]
    }

    public function deleteRole($roleId) {
        return false;
    }

    public function deleteUser($userId) {
        return false;
    }

    public function updateUserRoles($userId, $roles) {
        return false;
        // roles = [roleId, ...]
    }

    public function getRoleId($sRole) {
        die("getRoleId($sRole)");
        return 0;
    }

    public function getAllPerms() {
        die('getAllPerms');
        return array();
        // [ { permId, mod, act, obj }, ... ]
    }

    public function getRolePerms($roleId) { 
        die("getRolePerms($roleId)");
        return array();
        // [ permId => true, ... ]
    }

    public function updateRolePerms($roleId, $perms) {
        // $perms = [ permId, ... ]
        return false;
    }

    public function checkRoleExists($name) {
        die("checkRoleExists($name)");
        return false;
    }

    public function createRole($name) {
        die("createRole($name)");
        return true;
    }

    private function checkUserExistsById($id) {
        die('checkUserExistsById');
        return false;
    }

    public function getUserId($sUsername) {
        die('getUserId');
        return 0;
    }
}
?>
