
<?php
// Try to authenticate user using Shinken cookie
class CoreLogonShinkenCookie {

    private function getCookie($cookie_name) {
        $headers = getallheaders();
        $cookies_from_headers = Array();
        if (isset($headers['Cookie'])) {
            $cookies_from_headers = $headers['Cookie'];
        } else {
            return null;
        }

        foreach(explode(';', $cookies_from_headers) as $key => $value) {
            preg_match('/^(.*?)=(.*?)$/', trim($value), $matches);
            $cookies[$matches[1]] = $matches[2];
        }

        if (!isset($cookies[$cookie_name])) {
            return null;
        }

        return $cookies[$cookie_name];
    }

    public function check() {
        global $AUTH, $CORE;

        // Get connection parameters from configuration file
        $protocol = cfg("global", "shinken_auth_protocol");
        $port     = cfg("global", "shinken_auth_port");
        $address  = cfg("global", "shinken_auth_address");
        $shinken_admin_only     = cfg("global", "shinken_auth_restrict_to_shinken_admin");
        if ($shinken_admin_only == '1') {
            $shinken_admin_only = true;
        } else {
            $shinken_admin_only = false;
        }
        if ($address == '') {
            // If no address defined, get address from default backend socket
            $default_backend_name = cfg('defaults', 'backend');
            $socket = cfg('backend_' .$default_backend_name[0], 'socket');
            preg_match("/^tcp:(.*):\w*/", $socket, $matches);
            $address = $matches[1];
        }

        $url = $protocol. '://' .$address. ':' .$port. '/auth_nagvis';
        $data = array('restrict_to_shinken_admin' => base64_encode($shinken_admin_only));

        $cookie = $this->getCookie('user');
        if ($cookie == null) {
            return false;
        }

        $options = array(
            'http' => array(
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n" .
                             "Cookie: user=" .$cookie. "\r\n",
                'method'  => 'POST',
                'content' => http_build_query($data)
            )
        );

        $context  = stream_context_create($options);
        $result = @file_get_contents($url, false, $context);

        if ($result != false) {
            $username = $result;
        } else {
            return false;
        }

        $AUTH->setTrustUsername(true);
        $AUTH->passCredentials(Array('user' => $username,
                                     'userId' => $username));

        return $AUTH->isAuthenticated();
    }
}

?>
