#!/usr/bin/python

# Copyright (C) 2013:
#    Gabes Jean, j.gabes@shinken-solutions.com
#
# This file is part of Shinken Enterprise, all rights reserved.

import optparse
import subprocess
import os
import sys
import datetime
from pymongo.connection import Connection

KEYS = ['view_contacts', 'notification_contacts', 'edition_contacts', 'view_contact_groups', 'notification_contact_groups', 'edition_contact_groups']

def system_call(command):
    p = subprocess.Popen([command], stdout=subprocess.PIPE, shell=True)
    return p.stdout.read()

if not os.getuid() == 0:
    print "ERROR: this script must be run as root"
    sys.exit(2)

# Please put them in the GOOD order for application if need!

if __name__ == '__main__':
    parser = optparse.OptionParser("%prog ", description="This tool is used to remove all contacts from all hosts of your configuration. "
                                                         "Before doing so, performs a shinken-backup in /tmp. The list of contact keys that can be removed are:\n- %s." % "\n -".join(KEYS))
    parser.add_option('-v', '--verbose', dest='verbose', action='store_true', help="Show verbose output")
    parser.add_option('-a', '--all', dest='all', action='store_true', help="Remove all contact keys (from the above list) from hosts and host templates.")
    parser.add_option('--key', dest='key', action='store', help="Choose a specific contact key to be removed from all hosts and host templates." )
    
    opts, args = parser.parse_args()
    now = datetime.datetime.now()
    ret = system_call('/etc/init.d/shinken status')
    if 'RUNNING pid ' in ret:
        sys.exit("Please shut down Shinken before running this script.")
    
    # Look if the user ask for local or global, and if not, guess
    run_all = opts.all

    if opts.key and opts.key not in KEYS:
        sys.exit("Error: Only %s keys are allowed." % KEYS)

    if opts.key and run_all:
        sys.exit("Error: You cannot ask for a run one and run all option. Please choose")
    if not opts.key and not run_all:
        parser.print_help()
        sys.exit(0)

    today = datetime.datetime.now()
    os.system('shinken-backup --configuration --output-name "backup-before-contact-removal" --output-directory /tmp')
    
    any_run = False
    con = Connection()
    db = con.synchronizer
    states = ['stagging', 'production', 'working-area']
    for state in states:
        col = getattr(db, 'configuration-%s-host' % state)
        for h in col.find({}):
            fixed = False
            if opts.key and opts.key in h:
                del h[opts.key]
                fixed = True
                any_run = True
            elif opts.all:
                for key in KEYS:
                    if key in h:
                        del h[key]
                        fixed = True
                        any_run = True
            if fixed:
                col.update({'_id': h['_id']}, h)
                if opts.verbose:
                    if 'name' in h:
                        print "Cleaned host template %s (in %s database)" % (h.get('name', 'unknown'), state)
                    else:
                        print "Cleaned host %s (in %s database)" % (h.get('host_name', 'unknown'), state)
    if any_run:
        print "Successfully removed %s from all hosts." % ('all contact data' if not opts.key else opts.key)
    else:
        print "Did not find any data to be removed. No change were made."