#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2017:
#    shinken-solutions.com
#
# This file is part of Shinken Enterprise, all rights reserved.

import optparse
import sys
import json
from pymongo.connection import Connection

KEY_TO_ANONYME = [
    'password',
    'passphrase',
    'passe',
    'domainuser',
    'mssqluser',
    'mysqluser',
    'oracle_user',
    'ssh_user',
    'login',
    'address',
]
STATES = [
    'stagging',
    'production',
    'working-area'
]
CLASS = [
    'host',
    'command',
    'timeperiod',
    'contact',
    'contactgroup',
    'hostgroup',
    'businessimpactmodulation',
    'notificationway',
    'escalation',
    'macromodulation',
    'resultmodulation',
    'service'
]


# Print iterations progress
def printProgressBar(iteration, total, prefix='', suffix='', decimals=1, length=100, fill='█'):
    """
    Call in a loop to create terminal progress bar
    @params:
        iteration   - Required  : current iteration (Int)
        total       - Required  : total iterations (Int)
        prefix      - Optional  : prefix string (Str)
        suffix      - Optional  : suffix string (Str)
        decimals    - Optional  : positive number of decimals in percent complete (Int)
        length      - Optional  : character length of bar (Int)
        fill        - Optional  : bar fill character (Str)
    """
    percent = ("{0:." + str(decimals) + "f}").format(100 * (iteration / float(total)))
    filledLength = int(length * iteration // total)
    bar = fill * filledLength + '-' * (length - filledLength)
    sys.stdout.write('\r%s |%s| %s%% %s' % (prefix, bar, percent, suffix))
    sys.stdout.flush()
    # Print New Line on Complete
    if iteration == total:
        print


def reload_conf(host, file):
    load_conf = json.load(open(file, 'r'))
    
    con = Connection(host)
    db = con.synchronizer
    progress = 1
    progress_state_class = 0
    TOTAL = 100 * len(STATES) * len(CLASS)
    printProgressBar(0, TOTAL, prefix='Restoration :', suffix='Start', length=50)
    for state in STATES:
        for _class in CLASS:
            col = getattr(db, 'configuration-%s-%s' % (state, _class))
            col.drop()
            percent = 0
            if _class not in load_conf[state]:
                print 'skip state [%s]'%_class
                continue
            nb_item = len(load_conf[state][_class])
            for item in load_conf[state][_class]:
                sy = item.get('_SYNC_KEYS', None)
                if sy:
                    item['_SYNC_KEYS'] = sy.split(',')
                col.insert(item)
                percent += 1
                progress = progress_state_class * 100 + percent * 100 / nb_item
                printProgressBar(progress, TOTAL, prefix='Restoration :', suffix='%s-%s               ' % (state, _class), length=50)
            progress_state_class += 1
            progress = progress_state_class * 100 - 1
            printProgressBar(progress, TOTAL, prefix='Restoration :', suffix='%s-%s               ' % (state, _class), length=50)
    
    printProgressBar(TOTAL, TOTAL, prefix='Restoration :', suffix='Complete                             ', length=50)


def dump_conf(host, output_file, query):
    remap = {}
    out = {}
    counter = 0
    
    TOTAL = 100 * len(STATES) * len(CLASS)
    progress = 1
    progress_state_class = 0
    
    printProgressBar(0, TOTAL, prefix='Exporting :', suffix='Start', length=50)
    print 'Connect to host [%s]' % host
    con = Connection(host)
    db = con.synchronizer
    for state in STATES:
        out[state] = {}
        for _class in CLASS:
            out[state][_class] = []
            # print '\nstate-class [%s-%s]' % (state, _class)
            col = getattr(db, 'configuration-%s-%s' % (state, _class))
            items = list(col.find(query))
            percent = 0
            nb_item = len(items)
            for item in items:
                del item.get('last_modification', {}).get('change', [])[:]
                for property, value in item.iteritems():
                    if isinstance(value, list):
                        value = ','.join(value)
                        item[property] = value
                    for clean_key in KEY_TO_ANONYME:
                        if clean_key in property.upper():
                            new_value = remap.get(value, '%s-%s' % (property, counter))
                            counter += 1
                            remap[value] = new_value
                    # if 'host' == _class and 'host_name' == property:
                    #     new_value = remap.get(value, '%s-%s' % (property, counter))
                    #     counter += 1
                    #     remap[value] = new_value
                percent += 1
                progress = progress_state_class * 100 + percent * 100 / nb_item
                printProgressBar(progress, TOTAL, prefix='Exporting   :', suffix='%s-%s               ' % (state, _class), length=50)
                
                out[state][_class].append(item)
            
            progress_state_class += 1
            progress = progress_state_class * 100 - 1
            printProgressBar(progress, TOTAL, prefix='Exporting   :', suffix='%s-%s               ' % (state, _class), length=50)
    
    printProgressBar(TOTAL, TOTAL, prefix='Exporting   :', suffix='Complete                             ', length=50)
    
    print 'Dumping in json'
    json_dump = json.dumps(out)
    i = 0
    old_values = remap.keys()
    old_values.sort(key=lambda i: len(i) * -1)
    for old_value in old_values:
        new_value = remap[old_value]
        json_dump = json_dump.replace(old_value, new_value)
        printProgressBar(i, len(remap), prefix='Obfuscating :', suffix='', length=50)
        i += 1
    printProgressBar(len(remap), len(remap), prefix='Obfuscating :', suffix='Complete', length=50)
    
    print 'Validating json '
    try:
        json_object = json.loads(json_dump)
    except ValueError, e:
        print 'ERROR : Invalidating json !!!'
    
    print 'Saving file : %s' % output_file
    with open(output_file, 'w+') as file:
        file.write(json_dump)


if __name__ == '__main__':
    parser = optparse.OptionParser("%prog ", description="This tool extract your conf and hide %s keys" % ','.join(KEY_TO_ANONYME))
    parser.add_option('-f', '--file', dest='file', action='store', default='extract.json', help="File where base is extract")
    parser.add_option('', '--host', dest='host', action='store', default='localhost', help="Mongo host ip")
    parser.add_option('-v', '--verbose', dest='verbose', action='store_true', help="Show verbose output")
    parser.add_option('-k', '--keys', dest='keys', action='store', default='', help="Set key to filter default: --keys=\"%s\" " % ','.join(KEY_TO_ANONYME))
    parser.add_option('-r', '--reload', dest='reload', action='store_true', default=False, help="Reload a conf extracted")
    parser.add_option('-q', '--query', dest='query', action='store', default='', help="Mongo query use for the dump")
    
    opts, args = parser.parse_args()
    if opts.keys:
        KEY_TO_ANONYME = opts.keys.split(',')
    host = opts.host
    file = opts.file
    query = {}
    if opts.query:
        for q in opts.query.split(','):
            if q.split(':')[0].startswith('or'):
                toto = {}
                new_query = {}
                new_query['$or'] = [query, toto]
                toto[q.split(':')[0][2:].strip()] = q.split(':')[1]
                query = new_query
            else:
                query[q.split(':')[0]] = q.split(':')[1]
    print query
    
    KEY_TO_ANONYME = [s.upper() for s in KEY_TO_ANONYME]
    
    if opts.reload:
        reload_conf(host, file)
    else:
        dump_conf(host, file, query)
