#!/usr/bin/python

# Copyright (C) 2013:
#    Gabes Jean, j.gabes@shinken-solutions.com
#
# This file is part of Shinken Enterprise, all rights reserved.

import optparse
import subprocess
import os
import sys
import datetime
from pymongo.connection import Connection

def system_call(command):
    p = subprocess.Popen([command], stdout=subprocess.PIPE, shell=True)
    return p.stdout.read()


if not os.getuid() == 0:
    print "ERROR: this script must be run as root"
    sys.exit(2)

# Please put them in the GOOD order for application if need!

if __name__ == '__main__':
    parser = optparse.OptionParser("%prog [-u user] [-l] [hive_id]", description="This tool is used to set the default hive for a user. ")
    parser.add_option('-u', '--user', dest='user', action='store', help="The user name to which the screen is to be assigned")
    parser.add_option('-l', '--list', dest='list', action='store_true', help="Display the list of hives instead of updating a user's default hive")
    
    opts, args = parser.parse_args()
    
    now = datetime.datetime.now()
    
    if not opts.list:
        ret = system_call('/etc/init.d/shinken status')
        if 'RUNNING pid ' in ret:
            sys.exit("Please shut down Shinken before running this script.")
        
    
    
    if not opts.list and not opts.user:
        parser.print_help()
        sys.exit(1)
    
    if len(args) > 0:
        hive_id = args[-1]
    elif not opts.list:
        sys.exit("Error: you must set the ID of the hive on the command line")
    
    con = Connection()
    db = con.shinken
    
    # Search for the right screen
    try:
        hive_col = getattr(db, 'hive')
        user_col = getattr(db, 'user')
        if opts.list:
            print "List of hives:\n"
            print "%-30s %-30s %s" % ("Hive name","User name", "Hive ID")
            print "%-30s %-30s %s" %( "---------","---------", "-------")
            for hive in hive_col.find({}):
                owner = user_col.find_one({'uuid':hive['owner']['uuid']})
                print "%-30s %-30s %s " %(hive['name'], owner['userName'], hive['uuid'])
            sys.exit(0)
            
        hive = hive_col.find_one({'uuid': hive_id})
        if not hive:
            raise NameError("Hive [%s] not found" % hive_id)
        
        user = user_col.find_one({'userName': opts.user})
        if not user:
            raise NameError("User [%s] not found" % opts.user)
        
        default_hive = {'type': 'hive', 'uuid' : hive['uuid']}
        if 'prefs' in user:
            user['prefs']['defaultScreen'] = default_hive
        else:
            user['prefs'] = {'defaultScreen': default_hive}
            
        user_col.update({'_id': user['_id']}, user)
        print "User's [%s] new default hive is [%s] "%(opts.user, hive_id)
    except Exception as e:
        sys.exit("Error : %s" % e)
