#!/usr/bin/python


from shinkensolutions.localinstall import create_context_file, POSSIBLE_DAEMONS
import optparse
import os

# We are in the tarball, so we can find our installation path ourselve
installation_path = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

parser = optparse.OptionParser('', version="%prog ")

for daemon_type in POSSIBLE_DAEMONS:
    parser.add_option('--%snode' % daemon_type, dest="%snode" % daemon_type)

# central node means all
parser.add_option('--centralnode', dest="centralnode")
parser.add_option('--code-version', dest="code_version")
parser.add_option('--installer-version', dest="installer_version")

opts, args = parser.parse_args()

enabled_daemons = []
if opts.centralnode:
    enabled_daemons = POSSIBLE_DAEMONS[:]  # get a copy, we never know who will use it ;)
else:
    for daemon_type in POSSIBLE_DAEMONS:
        if getattr(opts, '%snode' % daemon_type, None) is not None:
            enabled_daemons.append(daemon_type)

code_version = opts.code_version
installer_version = opts.installer_version

create_context_file(code_version, installation_path, enabled_daemons, installer_version)
