try:
    import ssl
except ImportError:
    ssl = None

try:
    # Note: the cherrypy lib in ssl have a bug where socket_errors_to_ignore is not available
    # in the ssl part, so link it to the lib before load the ssl part
    from cherrypy.wsgiserver import wsgiserver2
    from cherrypy import wsgiserver as cheery_wsgiserver
    
    cheery_wsgiserver.socket_errors_to_ignore = wsgiserver2.socket_errors_to_ignore
except ImportError:
    cheery_wsgiserver = None

from shinken.log import logger

from .bottle import ServerAdapter


# CherryPy is allowing us to have a HTTP 1.1 server, and so have a KeepAlive
class CherryPyServerHTTP(ServerAdapter):
    def run(self, handler):  # pragma: no cover
        daemon_thread_pool_size = 64
        # Note: this can be call for host/port (TCP/IP) or with just bind_addr=unix socket (used by some modules)
        bind_addr = self.options.get('bind_addr', '')
        if not bind_addr:
            server = cheery_wsgiserver.CherryPyWSGIServer((self.host, self.port), handler, numthreads=daemon_thread_pool_size, shutdown_timeout=1)
        else:
            # NOTE: use a smaller thread pool for such modules, they do not need as much as the core
            server = cheery_wsgiserver.CherryPyWSGIServer(bind_addr, handler, numthreads=8, shutdown_timeout=1)
        logger.info('Initializing a CherryPy backend on [%s:%s] with %d threads' % (self.host, self.port, daemon_thread_pool_size))
        use_ssl = self.options['use_ssl']
        ssl_cert = self.options['ssl_cert']
        ssl_key = self.options['ssl_key']
        
        if use_ssl:
            server.ssl_certificate = ssl_cert
            server.ssl_private_key = ssl_key
        
        try:
            server.start()
        finally:
            server.stop()
