#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

from abc import ABCMeta
from abc import abstractmethod
from exceptions import NotImplementedError


# TODO provide Lookup parameter for get functions
class DataProvider:
    __metaclass__ = ABCMeta
    
    
    @abstractmethod
    def find_item_by_name(self, item_name, item_type='', item_state='', item_source='', lookup=None):
        raise NotImplementedError()
    
    
    @abstractmethod
    def find_item_by_id(self, item_id, item_type='', item_state='', item_source='', lookup=None):
        raise NotImplementedError()
    
    
    @abstractmethod
    def find_items(self, item_type, item_state='', item_source='', where=None, lookup=None):
        raise NotImplementedError()
    
    
    @abstractmethod
    def find_merge_state_items(self, item_type, item_states, item_source='', where=None, lookup=None):
        raise NotImplementedError()
    
    
    @abstractmethod
    def find_double_link_items(self, item_link_name, item_type_link_to, item_type='', item_state='', item_source=''):
        raise NotImplementedError()
    
    
    @abstractmethod
    def save_item(self, item, item_type='', item_state='', item_source=''):
        raise NotImplementedError()
    
    
    @abstractmethod
    def delete_item(self, item, item_type='', item_state='', item_source=''):
        raise NotImplementedError()
    
    
    @abstractmethod
    def count_items(self, item_type, item_state='', item_source='', where=None):
        raise NotImplementedError()
    
    
    @abstractmethod
    def update_all_item(self, item_state, update):
        raise NotImplementedError()
    
    
    @abstractmethod
    def copy_state(self, from_state, to_state):
        raise NotImplementedError()
    
    
    @abstractmethod
    def find_in_transaction(self, item_id, item_type, item_state):
        raise NotImplementedError()
    
    
    @abstractmethod
    def start_transaction(self, transaction_uuid):
        raise NotImplementedError()
    
    
    @abstractmethod
    def commit_transaction(self, transaction_uuid):
        raise NotImplementedError()

