#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from .component_select_options import ComponentOption
from ..business.item_controller.massive_change.massive_change_step import MASSIVE_CHANGE_STEP


class MassChangeFilterActionSelect:
    DEFAULT = "___ALL___"
    LIST = [DEFAULT, "OK", "NOK"]
    
    
    def __init__(self, selected_value, app):
        self.entries = [ComponentOption('action', True, i, selected_value == i, 0, label=app._('mass-change.input.filter-action.%s' % i)) for i in MassChangeFilterActionSelect.LIST]


class MassChangeFilterActionExcludeSelect:
    DEFAULT = "___ALL___"
    LIST = [DEFAULT, "___EMPTY___", "BY_ID", "BY_NAME", "BY_NAME_AND_ID"]
    
    
    def __init__(self, selected_value, app):
        self.entries = [ComponentOption('action', True, i, selected_value == i, 0, label=app._('mass-change.input.filter-action-exclude.%s' % i)) for i in MassChangeFilterActionExcludeSelect.LIST]


class MassChangeActionSelect:
    DEFAULT = "NONE"
    LIST = [DEFAULT, "ADD", "ADD_SYNCHRO", "MOVE", "SET_OR_CREATE", "REPLACE", "REMOVE", "REMOVE_SYNCHRO", "REMOVE_ALL_EXCEPT", "SET", "SET_SYNCHRO", "EMPTY", "FORCE_TO_DEFAULT"]
    
    
    def __init__(self, selected_value, app):
        self.entries = [ComponentOption('action', True, i, selected_value == i, 0, label=app._('mass-change.input.action.%s' % i)) for i in MassChangeActionSelect.LIST]


class MassChangeActionExtraMultiSelectSelect:
    DEFAULT = "NONE"
    LIST = [DEFAULT, "BEFORE", "AFTER", "FIRST", "LAST"]
    
    
    def __init__(self, selected_value, app):
        self.entries = [ComponentOption('action-extra', True, i, selected_value == i, 0, label=app._('mass-change.input.extra-action.%s' % i)) for i in MassChangeActionExtraMultiSelectSelect.LIST]


class MassChangeCounterSelect:
    DEFAULT = "___ALL___"
    EMPTY = "___EMPTY___"
    NOT_EMPTY = "___NOT_EMPTY___"
    LIST = [DEFAULT, EMPTY, "ERROR", "WARNING", NOT_EMPTY]
    
    
    def __init__(self, selected_value, app, helper_object, error_counter_nb, warning_counter_nb):
        self.entries = []
        for _current in MassChangeCounterSelect.LIST:
            _to_add = ComponentOption('counters', True, _current, selected_value == _current, 0)
            _label = "" if _current == MassChangeCounterSelect.NOT_EMPTY else app._('mass-change.input.counters.%s' % _current)
            if _current == "___EMPTY___":
                _to_add.text = _label
                _to_add.label = _label
            elif _current == MassChangeCounterSelect.DEFAULT:
                _to_add.text = _label
                _to_add.label = _label
            elif _current == "ERROR":
                _to_add.text = helper_object.get_counter_html(number=_label, class_to_add="shinken-error-counter", extra_attribute="data-is-discreet='1'")
                _to_add.label = "<span class='shinken-counter shinken-error-counter' data-number='?'><span class='shinken-counter-label'><span class='shinken-counter-extra-label'></span>&nbsp;&nbsp;</span></span>"
            elif _current == "WARNING":
                _to_add.text = helper_object.get_counter_html(number=_label, class_to_add="shinken-warning-counter", extra_attribute="data-is-discreet='1'")
                _to_add.label = "<span class='shinken-counter shinken-warning-counter' data-number='?'><span class='shinken-counter-label'><span class='shinken-counter-extra-label'></span>&nbsp;&nbsp;</span></span>"
            elif _current == MassChangeCounterSelect.NOT_EMPTY:
                _to_add.text = "%s&%s" % (helper_object.get_counter_html(number=app._('mass-change.input.counters.ERROR'), class_to_add="shinken-error-counter"),
                                          helper_object.get_counter_html(number=app._('mass-change.input.counters.WARNING'), class_to_add="shinken-warning-counter"))
                _label1 = "<span class='shinken-counter shinken-error-counter' data-number='?'><span class='shinken-counter-label'><span class='shinken-counter-extra-label'></span>&nbsp;&nbsp;</span></span>"
                _label2 = "<span class='shinken-counter shinken-warning-counter' data-number='?'><span class='shinken-counter-label'><span class='shinken-counter-extra-label'></span>&nbsp;&nbsp;</span></span>"
                _to_add.label = "%s%s" % (_label1, _label2)
            self.entries.append(_to_add)


class MassChangePlusSelect:
    DEFAULT = "NONE"
    LIST = ["___ALL___", DEFAULT, "ON", "OFF"]
    
    
    def __init__(self, selected_value, app, helper_object):
        self.entries = []
        for _current in MassChangePlusSelect.LIST:
            _to_add = ComponentOption('plus-action', True, _current, selected_value == _current, 0)
            _label = app._('mass-change.input.plus-action.%s' % _current)
            _to_add.text = helper_object.build_icon_plus(_current, label=_label)
            if _current == "___ALL___":
                _to_add.label = _label
            else:
                _to_add.label = helper_object.build_icon_plus(_current)
            self.entries.append(_to_add)


class MassChangeHelperHtml(object):
    @staticmethod
    def get_command_arg_html(value):
        if not value:
            return ''
        return '<div class="shinken-check-command-value">%s</div>' % value


class MassChangeHelper(object):
    
    def __init__(self, app, helper):
        self.app = app
        self.helper = helper
    
    
    def get_cell_mass_change_counter_filter_html(self, name, class_to_add="", error_counter_nb="", warning_counter_nb=""):
        _entries_dict = MassChangeCounterSelect(MassChangeCounterSelect.DEFAULT, self.app, self.helper.helper_object, error_counter_nb, warning_counter_nb)
        
        _selector_html = self.helper.helper_component.get_selector_html(entries=_entries_dict.entries, select_label=True)
        
        _to_return = []
        _to_return.append('''<td class ="shinken-list-filter shinken-select-container %s" data-name="%s" data-state-selector="0" data-object-type="shinken-list-filter" data-type="select-single">''' % (class_to_add, name))
        _to_return.append('''   %s''' % _selector_html)
        _to_return.append('''</td>''')
        return ''.join(_to_return)
    
    
    def get_cell_mass_change_plus_filter_html(self, name, class_to_add=""):
        _entries_dict = MassChangePlusSelect("___ALL___", self.app, self.helper.helper_object)
        
        _selector_html = self.helper.helper_component.get_selector_html(entries=_entries_dict.entries, select_label=True)
        
        _to_return = []
        _to_return.append('''<td class ="shinken-list-filter shinken-select-container %s" data-name="%s" data-state-selector="0" data-object-type="shinken-list-filter" data-type="select-single">''' % (class_to_add, name))
        _to_return.append('''   %s''' % _selector_html)
        _to_return.append('''</td>''')
        return ''.join(_to_return)
    
    
    def get_cell_mass_change_action_filter_html(self, step):
        if step == MASSIVE_CHANGE_STEP._2:
            entries_dict = MassChangeFilterActionExcludeSelect(MassChangeFilterActionExcludeSelect.DEFAULT, self.app)
        else:
            entries_dict = MassChangeFilterActionSelect(MassChangeFilterActionSelect.DEFAULT, self.app)
        
        selector_mass_change_action = self.helper.helper_component.get_selector_html(entries=entries_dict.entries, select_label=True)
        
        _to_return = []
        _to_return.append('''<td class ="shinken-list-filter shinken-action-cell shinken-select-container" data-name="action" data-state-selector="0" data-object-type="shinken-list-filter" data-type="select-single">''')
        _to_return.append('''   %s''' % selector_mass_change_action)
        _to_return.append('''</td>''')
        return ''.join(_to_return)
    
    
    def get_cell_mass_change_action_html(self, item_type, item_prop, default):
        mass_change_action = MassChangeActionSelect(MassChangeActionSelect.DEFAULT, self.app)
        
        selector_mass_change_action = self.helper.helper_component.get_selector_html(item_prop=item_prop, entries=mass_change_action.entries, select_label=True)
        
        _to_return = []
        _to_return.append('''%s''' % self.get_cell_mass_change_plus_html(item_type, item_prop))
        _to_return.append('''<td class="mass-change-action-cell">''')
        _to_return.append('''   <div>''')
        _to_return.append(
            '''       <div class="shinken-select-container" data-state-selector="0" data-name="mass_change_action" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()">%s</div>''' % selector_mass_change_action)
        _to_return.append('''   </div>''')
        _to_return.append('''</td>''')
        _to_return.append('''%s''' % self.get_cell_mass_change_default_cell_html(default))
        return ''.join(_to_return)
    
    
    def get_cell_mass_change_default_cell_html(self, default):
        if not default:
            default = self.app._('element.none')
        _to_return = []
        _to_return.append('''<td class="mass-change-default-label-cell">''')
        _to_return.append('''   <div class="shinken-label-container">''')
        _to_return.append('''       %s''' % self.helper.get_default_string_html('', 'default_or_herited'))
        _to_return.append('''       %s''' % self.helper.get_default_string_html('', 'default'))
        _to_return.append('''       %s''' % self.helper.get_default_string_html('', 'forced'))
        _to_return.append('''       <span class="shinken-default-value shinken-between-bracket">%s</span>''' % default)
        _to_return.append('''   </div>''')
        _to_return.append('''</td>''')
        return ''.join(_to_return)
    
    
    def get_cell_mass_change_action_extra_multiselect_html(self, item_type, item_prop):
        mass_change_action = MassChangeActionExtraMultiSelectSelect(MassChangeActionExtraMultiSelectSelect.DEFAULT, self.app)
        
        selector_mass_change_action = self.helper.helper_component.get_selector_html(item_prop=item_prop, entries=mass_change_action.entries, select_label=True)
        
        _to_return = []
        _to_return.append('''<td class="mass-change-action-extra-cell">''')
        _to_return.append('''   <div>''')
        _to_return.append(
            '''       <div class="shinken-select-container" data-state-selector="0" data-name="mass_change_action_extra" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()">%s</div>''' % selector_mass_change_action)
        _to_return.append('''   </div>''')
        _to_return.append('''</td>''')
        return ''.join(_to_return)
    
    
    def get_cell_mass_change_single_for_multiselect_html(self, name, item_type, item_prop, entries, default_text):
        selector_html = self.helper.helper_component.get_selector_html(
            item_prop=item_prop,
            default_text=default_text,
            default_text_forced=default_text,
            entries=entries,
            none_text=default_text,
            has_no_default=False,
            has_no_research=False,
            select_label=True,
            mass_change=True
        )
        
        _to_return = []
        _to_return.append('''<td class="mass-change-element-extra-cell" data-name="%s">''' % name)
        _to_return.append('''   <div>''')
        _to_return.append('''       <div class="shinken-select-container" data-state-selector="0" data-name="%s" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()">%s</div>''' % (name, selector_html))
        _to_return.append('''   </div>''')
        _to_return.append('''</td>''')
        return ''.join(_to_return)
    
    
    def get_cell_mass_change_label(self, label=""):
        if not label:
            label = self.app._('mass-change.label.enter_a_value')
        _to_return = []
        _to_return.append('''<td class="shinken-mass-change-element-label-cell">''')
        _to_return.append('''   <div class="shinken-label">%s</div>''' % label)
        _to_return.append('''</td>''')
        return ''.join(_to_return)
    
    
    def get_cell_mass_change_plus_html(self, item_type, item_prop):
        plus_action = MassChangePlusSelect(MassChangePlusSelect.DEFAULT, self.app, self.helper.helper_object)
        
        selector_plus_action = self.helper.helper_component.get_selector_html(item_prop=item_prop, entries=plus_action.entries, select_label=True)
        
        _to_return = []
        _to_return.append('''<td class="mass-change-plus-action-cell">''')
        _to_return.append('''   <div>''')
        _to_return.append('''       <div class="shinken-select-container" data-state-selector="0" data-name="mass_change_plus_action">%s</div>''' % selector_plus_action)
        _to_return.append('''   </div>''')
        _to_return.append('''</td>''')
        return ''.join(_to_return)
    
    
    def get_cell_mass_change_root_default_data(self):
        _to_return = []
        _to_return.append('''data-is-mass-change="1"''')
        _to_return.append('''data-mass-change-action-state="%s"''' % MassChangeActionSelect.DEFAULT)
        _to_return.append('''data-mass-change-action-extra-state="%s"''' % MassChangeActionExtraMultiSelectSelect.DEFAULT)
        _to_return.append('''data-mass-change-plus-action-state="%s"''' % MassChangePlusSelect.DEFAULT)
        return ''.join(_to_return)
