SHINKEN.TOOLS.TEST_AUTO_CHECK_TAB = (function ( self ) {
    self.getModeCheck                            = function () {
        return document.getElementById( "id-shinken-window-checks-target" ).dataset.tabSelected;
    };
    self.getCheckExcludeStatus                   = function ( id_host, id_check, dfe ) {
        return self.getCheckInPageHostDomElement( id_host, id_check, dfe ).dataset.excludeStatus;
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.getHostInPageHostDomElement             = function ( id ) {
        return document.getElementById( "id-host-in-page-host-" + id );
    };
    self.getAllCheckInPageHost                   = function () {
        return document.querySelectorAll( ".shinken-check-line:not(.shinken-override-unvalid)" );
    };
    self.getAllCheckOverrideUnvalidInPageHost    = function () {
        return document.querySelectorAll( ".shinken-container-host-in-page-host.shinken-container-unvalid-override" );
    };
    self.getAllPropertyOverrideUnvalidInPageHost = function () {
        return document.querySelectorAll( ".shinken-check-line.shinken-override-unvalid" );
    };
    self._buildCheckID                           = function ( id_host, id_check, dfe ) {
        var _to_return = id_host + "-" + id_check;
        if ( typeof dfe === 'string' ) {
            _to_return = _to_return + "-" + dfe;
        }
        return _to_return;
    };
    self.getCheckInPageHostDomElement            = function ( id_host, id_check, dfe ) {
        return document.getElementById( "id-shinken-check-line-" + self._buildCheckID( id_host, id_check, dfe ) );
    };
    self.getCheckOverrideInterface               = function ( id_host, id_check, dfe ) {
        return document.getElementById( "tr-check-override-" + self._buildCheckID( id_host, id_check, dfe ) );
    };
    self.getTryCheckRun                          = function ( id_host, id_check, dfe ) {
        return document.getElementById( "tr-check-run-" + self._buildCheckID( id_host, id_check, dfe ) );
    };
    self.getCheckInPageHostCountersDomElement    = function ( id_host, id_check, dfe ) {
        return self.getCheckInPageHostDomElement( id_host, id_check, dfe ).querySelectorAll( ".shinken-tab-check-col-name .shinken-counter" );
    };
    self._getTagModulation                       = function ( id_host, id_check, dfe ) {
        return self.getCheckInPageHostDomElement( id_host, id_check, dfe ).querySelector( '.shinken-tag-modulation' );
    };
    self.getCheckInPageHostOverrideStatus        = function ( id_host, id_check, dfe ) {
        return self.getCheckInPageHostDomElement( id_host, id_check, dfe ).dataset.overrideStatus;
    };
    self.getCfgOverrideText                      = function () {
        return document.querySelector( ".shinken-override-cfg-format-value .shinken-override-cfg-format-text" );
    };
    self.getButtonOverride                       = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-button-container" );
    };
    self.getButtonExcludeByID                    = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-check-exclude-tag.shinken-exclude-by-id" );
    };
    self.getButtonExcludeByIDClean               = function ( id_host, id_check, dfe ) {
        var _dom = self.getButtonExcludeByID( id_host, id_check, dfe );
        return _dom.querySelector( ".shinken-btn-clean" );
    };
    self.getButtonExcludeByName                  = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-check-exclude-tag.shinken-exclude-by-name" );
    };
    self.getButtonExcludeNot                     = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-check-exclude-tag.shinken-not-exclude" );
    };
    self.getButtonExcludeDFE                     = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-check-exclude-tag.shinken-not-exclude-dfe" );
    };
    self.getHiddenTag                            = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-tab-check-col-name .shinken-check-hidden" );
    };
    self.getDuplicatedTag                        = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-tab-check-col-name .shinken-check-duplicate" );
    };
    self.getTagInformation                       = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-information-tag" );
    };
    self.getTagError                             = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-tab-check-col-dfe .tag-error" );
    };
    self.getTryCheckButtons                      = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-buttons-try-check-container" );
    };
    self.getTryCheckButtonClose                      = function ( id_host, id_check, dfe ) {
        var _check = self.getTryCheckButtons( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-hide-eval" );
    };
    self.getCommand                              = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( ".shinken-macro-container" );
    };
    self.getMacrosInCommand                      = function ( id_host, id_check, dfe, class_to_find ) {
        return self.getCommand( id_host, id_check, dfe ).querySelectorAll( "." + class_to_find );
    };
    self.getWindowTabCounter                     = function () {
        return document.querySelector( "#id-shinken-window-checks .shinken-window-total-counter" );
    };
    self.getCleanAllButton                       = function ( id_host, id_check, dfe ) {
        var _button_override = self.getButtonOverride( id_host, id_check, dfe );
        return _button_override.querySelector( '.shinken-btn-clean' );
    };
    self.getTryCheckCommandLine                  = function ( id_host, id_check, dfe ) {
        return self.getTryCheckRun( id_host, id_check, dfe ).querySelector( '.result-check-content .shinken-try-check-command-container .content .code' );
    };
    self.getTryCheckEvaluationLine               = function ( id_host, id_check, dfe ) {
        return self.getTryCheckRun( id_host, id_check, dfe ).querySelector( '.result-check-content .shinken-try-check-evaluation-container .content .code' );
    };
    self.getTryCheckStatus                       = function ( id_host, id_check, dfe ) {
        return self.getTryCheckRun( id_host, id_check, dfe ).querySelector( '.table-execution:not(.shinken-matching-modulation) tbody .col-result' );
    };
    self.getTryCheckResult                       = function ( id_host, id_check, dfe ) {
        return self.getTryCheckRun( id_host, id_check, dfe ).querySelector( '.table-execution:not(.shinken-matching-modulation) .shinken-output-short .shinken-content-try-check' );
    };
    self.getTryCheckFlatPerformanceData          = function ( id_host, id_check, dfe ) {
        return self.getTryCheckRun( id_host, id_check, dfe ).querySelector( '.shinken-execution-table .shinken-output-frame.shinken-metric-flat .shinken-content-try-check' );
    };
    self.getTryCheckTablePerformanceData         = function ( id_host, id_check, dfe ) {
        return self.getTryCheckRun( id_host, id_check, dfe ).querySelector( '.shinken-metrics-table' );
    };
    self.getTryCheckMessagePerformanceData       = function ( id_host, id_check, dfe ) {
        return self.getTryCheckRun( id_host, id_check, dfe ).querySelector( '.shinken-tooltip-message' );
    };
    self.getTryCheckStatusModulate               = function ( id_host, id_check, dfe ) {
        return self.getTryCheckRun( id_host, id_check, dfe ).querySelector( '.table-execution.shinken-matching-modulation tbody .col-result' );
    };
    self.getCheckNameTagLabel                    = function ( id_host, id_check, dfe ) {
        var _check = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
        return _check.querySelector( '.shinken-tab-check-col-name .shinken-label .shinken-link' );
    };
    //********************************************  ACTION   **************************************************//
    self.cleanAllOverridesByButton               = function ( timeout, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _dom = self.getCleanAllButton( id_host, id_check, dfe );
            //SHINKEN.TOOLS.TEST_AUTO_DOM.click(0, _dom);
            //SHINKEN.TOOLS.TEST_AUTO_DOM.dispatchEvent( 100, document.activeElement, SHINKEN.TOOLS.TEST_AUTO_KEY_EVENT.getEnterEvent() );
            
            //J AI PAS REUSSI A PASSER LA POPUP DONC JE FAIS UN RACCOOURCI...
            var _check_in_page_host = App.Elements.ChecksTab.getCheckInHostElement( _dom.getAttribute( 'onclick' ).split( "'" )[ 1 ] );
            _check_in_page_host.cleanOverride();
            App.Elements.ChecksTab.askUpdateOverrideFormatCfg();
        }, timeout );
        return 1000;
    };
    self.runTryCheck                             = function ( timeout, class_button, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _dom    = self.getCheckInPageHostDomElement( id_host, id_check, dfe );
            var _button = _dom.querySelector( '.' + class_button );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _button );
        }, timeout );
        return 1000;
    };
    self.closeTryCheckPanel                             = function ( timeout, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _button = self.getTryCheckButtonClose( id_host, id_check, dfe );
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button, 'button close try check ' + self._buildCheckID( id_host, id_check, dfe ) );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _button );
            SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 200, _button, 'button close try check ' + self._buildCheckID( id_host, id_check, dfe ) );
        }, timeout );
        return 1000;
    };
    self.goToMode                                = function ( tab_id, timeout ) {
        setTimeout( function () {
            document.querySelector( ".shinken-check-mode-menu-tab[data-value='" + tab_id + "']" ).click();
        }, timeout );
        return 150;
    };
    self.openOrCloseOverrideInterface            = function ( timeout, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _need_pulsate = self.getModeCheck() !== OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE;
            var _status       = self.getCheckInPageHostOverrideStatus( id_host, id_check, dfe );
            var _button       = self.getButtonOverride( id_host, id_check, dfe );
            switch ( _status ) {
                case OBJECT.CONST.OVERRIDE_STATUS.OFF:
                    _button.querySelector( ".shinken-not-override" ).click();
                    break;
                case OBJECT.CONST.OVERRIDE_STATUS.ON:
                    _button.querySelector( ".shinken-overridden" ).click();
                    break;
            }
            if ( _need_pulsate ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasPulsate( document.querySelector( '.shinken-check-mode-menu-tab[data-value="1"]' ), "Clignotement du bouton surcharge", 2000 );
            }
        }, timeout );
        return 2000;
    };
    self.clickOnButtonExclude                    = function ( timeout, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _mode_check     = self.getModeCheck();
            var _status_exclude = self.getCheckExcludeStatus( id_host, id_check, dfe );
            switch ( _mode_check ) {
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                    switch ( _status_exclude ) {
                        case OBJECT.CONST.EXCLUDE_STATUS.OFF:
                            return;
                        case OBJECT.CONST.EXCLUDE_STATUS.BY_NAME:
                            var _dom = self.getButtonExcludeByName( id_host, id_check, dfe );
                            break;
                        case OBJECT.CONST.EXCLUDE_STATUS.BY_ID:
                            var _dom = self.getButtonExcludeByID( id_host, id_check, dfe );
                            break;
                    }
                    var _current_timeout = SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
                    setTimeout( function () {
                        SHINKEN.TOOLS.TEST_AUTO.__hasPulsate( document.querySelector( '.shinken-check-mode-menu-tab[data-value="2"]' ), "Clignotement du bouton exclude", 2000 );
                    }, _current_timeout );
                    break;
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                    var _dom = self.getButtonExcludeNot( id_host, id_check, dfe );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
                    break;
            }
        }, timeout );
        return 2000;
    };
    self.clickOnButtonRemoveExclude              = function ( timeout, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _mode_check = self.getModeCheck();
            switch ( _mode_check ) {
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                    break;
                case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                    var _dom = self.getButtonExcludeByIDClean( id_host, id_check, dfe );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
                    break;
            }
        }, timeout );
        return 2000;
    };
    //********************************************  TEST   **************************************************//
    self.testNbHostInPageHost                    = function ( timeout, nb_expected ) {
        setTimeout( function () {
            var _number_present = App.Elements.ChecksTab.getListHostInPageHost().length;
            if ( _number_present !== nb_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "le nombre d'host_in_page_host n'est pas égale à " + nb_expected + " ==> [" + _number_present + "]" );
            }
        }, timeout );
        return 10;
    };
    self.testNbCheckInPageHost                   = function ( timeout, nb_counter, nb_visible, nb_hidden ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_WINDOW.testCounter( 0, "id-shinken-window-checks", undefined, undefined, nb_counter );
            var _checks_dom_line = self.getAllCheckInPageHost();
            var _hidden          = 0;
            var _visible         = 0;
            for ( var i = 0, _size_i = _checks_dom_line.length; i < _size_i; i++ ) {
                if ( _checks_dom_line[ i ].classList.contains( "shinken-check-hidden-container" ) ) {
                    _hidden++;
                }
                else {
                    _visible++;
                }
            }
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _hidden, nb_hidden, "check caché" );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _visible, nb_visible, "check visible" );
        }, timeout );
        return 10;
    };
    self.testCounterCheck                        = function ( timeout, nb_error, nb_warning, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _counters = self.getCheckInPageHostCountersDomElement( id_host, id_check, dfe );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.hasCounterValue( 0, _counters[ 0 ], nb_error );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.hasCounterValue( 0, _counters[ 1 ], nb_warning );
        }, timeout );
        return 10;
    };
    self.testInactiveOverrideCheckReason         = function ( timeout, text_array ) {
        setTimeout( function () {
            var _checks_dom_line = self.getAllCheckOverrideUnvalidInPageHost();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _checks_dom_line.length, text_array.length, "NB CHECK OVERRIDE INACTIVE" );
            for ( var i = 0, _size_i = _checks_dom_line.length; i < _size_i; i++ ) {
                var _current = _checks_dom_line[ i ].querySelector( ".shinken-title" );
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _current, text_array[ i ], 'Inactivity text for check' );
            }
        }, timeout );
        return 10;
    };
    self.testNbInactiveOverrideCheck             = function ( timeout, nb_expected_check, nb_expected_property ) {
        setTimeout( function () {
            var _checks_dom_line = self.getAllCheckOverrideUnvalidInPageHost();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _checks_dom_line.length, nb_expected_check, "NB CHECK OVERRIDE INACTIVE" );
            var _checks_dom_line_property = self.getAllPropertyOverrideUnvalidInPageHost();
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _checks_dom_line_property.length, nb_expected_property, "NB PROPERTY OVERRIDE INACTIVE" );
        }, timeout );
        return 10;
    };
    self.validOverrideInterface                  = function ( timeout, status, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _row_override = self.getCheckOverrideInterface( id_host, id_check, dfe );
            switch ( status ) {
                case OBJECT.CONST.OVERRIDE_STATUS.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _row_override, 'override interface for ' + self._buildCheckID( id_host, id_check, dfe ) );
                    break;
                case OBJECT.CONST.OVERRIDE_STATUS.ON:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _row_override, 'override interface for ' + self._buildCheckID( id_host, id_check, dfe ) );
                    break;
            }
        }, timeout );
        return 50;
    };
    self.hasOverrideButtonStatus                 = function ( timeout, status, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _button     = self.getButtonOverride( id_host, id_check, dfe );
            var _mode_check = self.getModeCheck();
            switch ( status ) {
                case OBJECT.CONST.OVERRIDE_STATUS.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.getCheckInPageHostDomElement( id_host, id_check, dfe ).dataset, 'overrideStatus', status );
                    switch ( _mode_check ) {
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-not-override" ) );
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-overridden" ) );
                            break;
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button.querySelector( ".shinken-not-override" ) );
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "color", "rgb(0, 0, 0)" );
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "cursor", "pointer" );
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-overridden" ) );
                            break;
                    }
                    break;
                case OBJECT.CONST.OVERRIDE_STATUS.ON:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.getCheckInPageHostDomElement( id_host, id_check, dfe ).dataset, 'overrideStatus', status );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-not-override" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button.querySelector( ".shinken-overridden" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "cursor", "pointer" );
                    switch ( _mode_check ) {
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "backgroundColor", "rgb(0, 0, 0)" );
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "color", "rgb(255, 255, 255)" );
                            break;
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "backgroundColor", "rgb(0, 0, 0)" );
                            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "color", "rgb(255, 255, 255)" );
                            //?? Pkoi Ces couleurs?? a retester!!!
                            //SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "backgroundColor", "rgb(147, 213, 243)" );
                            //SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-overridden" ), "color", "rgb(0, 0, 0)" );
                            break;
                    }
                    break;
                case OBJECT.CONST.OVERRIDE_STATUS.DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( self.getCheckInPageHostDomElement( id_host, id_check, dfe ).dataset, 'overrideStatus', "0" );
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button.querySelector( ".shinken-not-override" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button.querySelector( ".shinken-overridden" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "cursor", "pointer" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "backgroundColor", "rgba(0, 0, 0, 0)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "color", "rgb(0, 0, 0)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "opacity", "0.2" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button.querySelector( ".shinken-not-override" ), "pointer-events", "none" );
                    break;
            }
        }, timeout );
        return 50;
    };
    self.hasExcludeButtonStatus                  = function ( timeout, status, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _button_by_id          = self.getButtonExcludeByID( id_host, id_check, dfe );
            var _button_by_name        = self.getButtonExcludeByName( id_host, id_check, dfe );
            var _button_by_not_exclude = self.getButtonExcludeNot( id_host, id_check, dfe );
            var _button_dfe            = self.getButtonExcludeDFE( id_host, id_check, dfe );
            
            
            var _mode_check = self.getModeCheck();
            switch ( status ) {
                case OBJECT.CONST.EXCLUDE_STATUS.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_id );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_name );
                    switch ( _mode_check ) {
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_not_exclude );
                            break;
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                            if ( dfe ) {
                                SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_not_exclude );
                                SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_dfe );
                                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _button_dfe, "Exclusion spécifique non disponible" );
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button_dfe, "cursor", "not-allowed" );
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button_dfe.querySelector( '.shinken-label-exclude' ), "opacity", "0.4" );
                                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _button_dfe.querySelector( '.shinken-label' ), "font-style", "italic" );
                            }
                            else {
                                SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_by_not_exclude );
                            }
                            break;
                    }
                    break;
                case OBJECT.CONST.EXCLUDE_STATUS.BY_ID:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_by_id );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_name );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_not_exclude );
                    break;
                case OBJECT.CONST.EXCLUDE_STATUS.BY_NAME:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_by_name );
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_id );
                    switch ( _mode_check ) {
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.NORMAL:
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.OVERRIDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _button_by_not_exclude );
                            break;
                        case OBJECT.CONST.MODE_OVERRIDE_EXCLUDE.EXCLUDE:
                            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button_by_not_exclude );
                            break;
                    }
                    break;
            }
        }, timeout );
        return 50;
    };
    self.validOverridenButton                    = function ( timeout, nb_error, nb_warning, id_host, id_check, dfe ) {
        setTimeout( function () {
            self.hasOverrideButtonStatus( 0, OBJECT.CONST.OVERRIDE_STATUS.ON, id_host, id_check, dfe );
            var _button = self.getButtonOverride( id_host, id_check, dfe ).querySelector( ".shinken-overridden" );
            var _error  = _button.querySelector( '.shinken-counter.shinken-error-counter' );
            if ( nb_error ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.hasCounterValue( 0, _error, nb_error );
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _error, "tag error" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _error, "tag error" );
            }
            var _warning = _button.querySelector( '.shinken-counter.shinken-warning-counter' );
            if ( nb_warning ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.hasCounterValue( 0, _warning, nb_warning );
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _warning, "tag warning" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _warning, "tag warning" );
            }
        }, timeout );
        return 50;
    };
    self.validTagInformation                     = function ( timeout, state_expected, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _dom_tag_info = self.getTagInformation( id_host, id_check, dfe );
            switch ( state_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "tag information" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_info, "tag information" );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.validCleanAllButton                     = function ( timeout, state_expected, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _dom = self.getCleanAllButton( id_host, id_check, dfe );
            switch ( state_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, "button delete all" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, "button delete all" );
                    break;
            }
        }, timeout );
        return 10;
    };
    self.validTagError                           = function ( timeout, state_expected, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _timeout       = 0;
            var _dom_tag_error = self.getTagError( id_host, id_check, dfe );
            switch ( state_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_error, "tag Error DFE" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom_tag_error, "background-color", "rgb(217, 83, 79)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom_tag_error, "color", "rgb(255, 255, 255)" );
                    switch ( __shinken_test_type + "-" + __phase ) {
                        case "00020-1":
                            _timeout += SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _dom_tag_error, 'mouseenter' );
                            _timeout += SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.containsText( _timeout, _( "element.tooltip_dfe_link_on_data" ).substring( 0, 25 ) );
                            _timeout += SHINKEN.TOOLS.TEST_AUTO_DOM.click( _timeout, _dom_tag_error );
                            _timeout += SHINKEN.TOOLS.TEST_AUTO_WINDOW.isSelected( _timeout, "id-shinken-window-datas" );
                            _timeout += SHINKEN.TOOLS.TEST_AUTO_WINDOW.isSelected( _timeout, "id-shinken-window-checks", true );
                            break;
                    }
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_error, "tag Error DFE" );
                    break;
            }
        }, timeout );
        return 100;
    };
    //********************************************  TEST TRY CHECK   **************************************************//
    self.validTryCheckButton                     = function ( timeout, state_expected, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _dom_tag_info = self.getTryCheckButtons( id_host, id_check, dfe );
            switch ( state_expected ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "try check button" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_info, "try check button" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "try check button" );
                    var _timeout = SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( _timeout, _dom_tag_info, 'mouseenter' );
                    SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.containsText( _timeout, _( "element.no_run_bp_rule" ) );
                    break;
            }
        }, timeout );
        return 200;
    };
    self.validStatusTryCheckAfterRun             = function ( timeout, status_expected, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _dom_tag_status = self.getTryCheckStatus( id_host, id_check, dfe );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_tag_status, status_expected, 'Status du try check run' );
        }, timeout );
        return 200;
    };
    self.validStatusTryCheckAfterRunModulate     = function ( timeout, status_expected, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _dom_tag_status = self.getTryCheckStatusModulate( id_host, id_check, dfe );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_tag_status, status_expected, 'Status du try check run après modulation' );
        }, timeout );
        return 200;
    };
    self.validResultTryCheckAfterRun             = function ( timeout, id_host, id_check, dfe ) {
        var _text_expected = "";
        var _switch_value  = __shinken_test_type + "-" + __phase;
        
        switch ( _switch_value ) {
            case "00122-4":
            case "00122-6":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST._00122.RESULT;
                break;
        }
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.getTryCheckResult( id_host, id_check, dfe ), _text_expected, 'Result' );
        }, timeout );
        return 100;
    };
    self.validCommandLineTryCheckAfterRun        = function ( timeout, id_host, id_check, dfe ) {
        var _text_expected = "";
        var _switch_value  = __shinken_test_type + "-" + __phase;
        
        switch ( _switch_value ) {
            case "00122-4":
            case "00122-6":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST._00122.COMMAND_LINE;
                break;
            case "00122-8":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST._00122.COMMAND_LINE_7;
                break;
        }
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.getTryCheckCommandLine( id_host, id_check, dfe ), _text_expected, 'Ligne de commande' );
        }, timeout );
        return 100;
    };
    self.validEvaluationLineTryCheckAfterRun     = function ( timeout, id_host, id_check, dfe ) {
        var _text_expected = "";
        var _switch_value  = __shinken_test_type + "-" + __phase;
        
        switch ( _switch_value ) {
            case "00122-4":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST._00122.COMMAND_LINE_INTERPRETED.PHASE_4;
                break;
            case "00122-6":
                _text_expected = SHINKEN.TOOLS.TEST_AUTO.CONST._00122.COMMAND_LINE_INTERPRETED.PHASE_6;
                break;
        }
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.getTryCheckEvaluationLine( id_host, id_check, dfe ), _text_expected, 'Ligne de commande avec les données interprétées' );
        }, timeout );
        return 100;
    };
    self.validDataPerformanceTryCheckAfterRun    = function ( timeout, id_host, id_check, dfe ) {
        var _text_expected_flat  = "";
        var _text_expected_table = "";
        
        var _is_perf_data_valid = true;
        var _has_perf_data      = true;
        var _has_table_data     = true;
        
        var _nb_table_data_row = 3;
        var _nb_table_data_col = 4;
        
        var _switch_value = __shinken_test_type + "-" + __phase;
        switch ( _switch_value ) {
            case "00028-1":
                _text_expected_flat  = "time=0.216080s size=1124B";
                _text_expected_table = "Métrique Valeur Seuil d'avertissement Seuil critique time 0.216080s   size 1124B";
                break;
            case "00028-2":
                _text_expected_flat  = "time=0.216080s";
                _text_expected_table = "Métrique Valeur Seuil d'avertissement Seuil critique time 0.216080s";
                _nb_table_data_row   = 2;
                break;
            case "00028-3":
                _text_expected_flat = "time blabla=0.216080s";
                _has_table_data     = false;
                _is_perf_data_valid = false;
                break;
            case "00028-4":
                _text_expected_flat = "time=0.216080s,";
                _has_table_data     = false;
                _is_perf_data_valid = false;
                break;
            case "00028-5":
                _text_expected_flat = "time=0,216080s";
                _has_table_data     = false;
                _is_perf_data_valid = false;
                break;
            case "00028-6":
                _text_expected_flat  = "'john''s disk'=83%";
                _text_expected_table = "Métrique Valeur Seuil d'avertissement Seuil critique john''s disk 83%";
                _has_table_data      = true;
                _nb_table_data_row   = 2;
                _nb_table_data_col   = 4;
                break;
            case "00028-7":
                _text_expected_flat = "'disk usage'=78%;80;90;;;";
                _has_table_data     = false;
                _is_perf_data_valid = false;
                break;
            case "00028-8":
                _text_expected_flat  = "'disk usage'=78%;80;90";
                _text_expected_table = "Métrique Valeur Seuil d'avertissement Seuil critique disk usage 78% 80 90";
                _has_table_data      = true;
                _nb_table_data_row   = 2;
                _nb_table_data_col   = 4;
                break;
            case "00028-9":
                _text_expected_flat  = "'data packets'=11345234c";
                _text_expected_table = "Métrique Valeur Seuil d'avertissement Seuil critique data packets 11345234c";
                _has_table_data      = true;
                _nb_table_data_row   = 2;
                _nb_table_data_col   = 4;
                break;
            case "00028-10":
                _text_expected_flat = "temperature=23;;;20;30";
                _has_table_data      = true;
                _nb_table_data_row   = 2;
                _nb_table_data_col   = 4;
                break;
            case "00028-11":
                _has_table_data = false;
                _has_perf_data  = false;
                break;
        }
        setTimeout( function () {
            var _dom_flat  = self.getTryCheckFlatPerformanceData( id_host, id_check, dfe );
            var _dom_table = self.getTryCheckTablePerformanceData( id_host, id_check, dfe );
            var _dom_error = self.getTryCheckMessagePerformanceData( id_host, id_check, dfe );
            if ( _has_perf_data ) {
                SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _dom_flat, _text_expected_flat, 'La data performance flat' );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _dom_flat );
            }
            if ( _has_table_data ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isTable( 0, _dom_table, _nb_table_data_row, _nb_table_data_col, _text_expected_table );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _dom_table );
            }
            if ( _is_perf_data_valid ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _dom_error );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_error );
            }
        }, timeout );
        return 10;
    };
    
    //********************************************  TEST TAGS  **************************************************//
    self.hasHiddenTagState     = function ( timeout, state_expected, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _tag = self.getHiddenTag( id_host, id_check, dfe );
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tag, "TAG HIDDEN " + self._buildCheckID( id_host, id_check, dfe ) );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _tag, "TAG HIDDEN " + self._buildCheckID( id_host, id_check, dfe ) );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.hasDuplicateTagState  = function ( timeout, state_expected, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _tag = self.getDuplicatedTag( id_host, id_check, dfe );
            switch ( state_expected ) {
                case COMPONENT.CONST.BTN_STATE.OFF:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _tag, "TAG Duplicate " + self._buildCheckID( id_host, id_check, dfe ) );
                    break;
                case COMPONENT.CONST.BTN_STATE.ON:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( _tag, "TAG Duplicate " + self._buildCheckID( id_host, id_check, dfe ) );
                    self.hasHiddenTagState( 0, state_expected, id_host, id_check, dfe );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.validTagModulation    = function ( timeout, state, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _dom_tag_info = self._getTagModulation( id_host, id_check, dfe );
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_tag_info, "tag modulation" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE_BUTTON.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_tag_info, "tag modulation" );
                    break;
            }
        }, timeout );
        return 10;
    };
    //********************************************  TEST MISC  **************************************************//
    self.validCfgOverrideText  = function ( timeout, text_expected ) {
        setTimeout( function () {
            var _text = self.getCfgOverrideText();
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _text, text_expected, 'Syntaxe des surcharges de check' );
        }, timeout );
        return 2000;
    };
    self.isTextCommand         = function ( timeout, value, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _command = self.getCommand( id_host, id_check, dfe );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( _command, value );
        }, timeout );
        return 100;
    };
    self.analyseCommandContent = function ( timeout, nb_error, nb_warning, id_host, id_check, dfe ) {
        setTimeout( function () {
            var _errors = self.getMacrosInCommand( id_host, id_check, dfe, "shinken-macro-error" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _errors, nb_error, "nb errors in macro" );
            for ( var i = 0, _size_i = _errors.length; i < _size_i; i++ ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.isMacroError( 0, _errors[ i ] );
            }
            var _warning = self.getMacrosInCommand( id_host, id_check, dfe, "shinken-macro-warning" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _warning, nb_warning, "nb warnings in macro" );
            for ( var i = 0, _size_i = _warning.length; i < _size_i; i++ ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.isMacroWarning( 0, _warning[ i ] );
            }
        }, timeout );
        return 200;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_CHECK_TAB || {} );



