'use strict';

COMPONENT.Tag           = function ( dom_element, parent_name ) {
    // dom_element
    // element
    // is_dragging
    //animation_timer
    this.init( dom_element, parent_name );
};
COMPONENT.Tag.prototype = {
    init                    : function ( dom_element, parent_name ) {
        if ( dom_element ) {
            this.dom_element = dom_element;
            this.initElement( parent_name );
        }
    },
    initElement             : function ( parent_name ) {
        this.element = new OBJECT.ElementList();
        this.element.setName( this.dom_element.dataset.keyName );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setUUID( this.dom_element.dataset.uuid );
        if ( parent_name === PROPERTY.CONST.NAME.EDITION_CONTACTS && this.dom_element.classList.contains( 'shinken-tag-disabled' ) ) {
            this.text_tooltip = _( 'element.tooltip_edition_contact_not_expert' );
        }
        this.setTooltip();
    },
    setTooltip              : function ( text_tooltip ) {
        var _text = text_tooltip || this.element.getTooltip() || this.text_tooltip || '';
        this.dom_element.querySelector( 'tbody' ).setAttribute( "shi-tip-html", _text );
    },
    getDomElement           : function () {
        return this.dom_element;
    },
    isDefaultTag            : function () {
        return this.element.getName() === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
    },
    isNullTag               : function () {
        return this.element.getName() === PROPERTY.CONST.CUSTOM_SELECT.NONE;
    },
    getName                 : function () {
        return this.element.getName();
    },
    getLabel                : function () {
        return this.element.getLabel() || this.getName();
    },
    updateTagWithNoneTags   : function ( to_set ) {
        this.element.setLabel( to_set, this.dom_element );
        this.buildHTML();
    },
    setLabel                : function ( to_set ) {
        this.element.setLabel( to_set, this.dom_element.querySelector( '.title' ) );
        this.dom_element.querySelector( '.title' ).innerHTML = to_set;
    },
    getState                : function () {
        return this.element.getState();
    },
    setState                : function ( to_set ) {
        this.element.setState( to_set );
        DOM.Service.setDataSet( this.dom_element, 'state', to_set );
    },
    getType                 : function () {
        return this.element.getType();
    },
    setElement              : function ( to_set ) {
        this.element = to_set;
    },
    isDeletable             : function () {
        return (this.getType() !== 'inheritance');
    },
    isHidden                : function () {
        return this.element.getState() === COMPONENT.CONST.TAG.STATE.HIDDEN;
    },
    clone                   : function () {
        var _to_return         = new COMPONENT.Tag();
        _to_return.dom_element = this.dom_element.cloneNode( true );
        _to_return.element     = this.element.clone();
        return _to_return;
    },
    setIndexParentDomElement: function ( index ) {
        if ( !this.dom_element ) {
            return;
        }
        var _parent = DOM.Service.findParentElementWithClass( this.dom_element, 'droppable', 3 );
        if ( !_parent ) {
            return;
        }
        _parent.dataset.index = index;
    },
    
    pulsateTag : function () {
        this.dom_element.classList.add( SHINKEN.CONST.CLASS_CSS.PULSATE );
        if ( this.animation_timer ) {
            clearTimeout( this.animation_timer );
        }
        var self             = this;
        this.animation_timer = setTimeout( function () {
            self.dom_element.classList.remove( SHINKEN.CONST.CLASS_CSS.PULSATE );
        }, 1500 );
    },
    setDragging: function ( _to_set ) {
        this.is_dragging = _to_set;
        var self         = this;
        setTimeout( function () {
            if ( _to_set ) {
                self.dom_element.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.DISCREET );
            }
            else {
                self.dom_element.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.DISCREET );
            }
        }, 0 );
    },
    
    setMessageTooltip: function ( message ) {
        this.dom_element.querySelector( 'tbody' ).setAttribute( "shi-tip-html", message );
    },
    addClass         : function ( label ) {
        this.dom_element.classList.add( label );
    },
    removeClass      : function ( label ) {
        this.dom_element.classList.remove( label );
    },
    isError          : function ( prop_name ) {
        if ( prop_name === PROPERTY.CONST.NAME.USE ) {
            return this.element.getState() === OBJECT.CONST.TEMPLATE.STATUS.BADLOOP;
        }
        return this.element.getState() === COMPONENT.CONST.TAG.STATE.UNKNOWN;
    },
    isWarning        : function ( prop_name ) {
        if ( prop_name === PROPERTY.CONST.NAME.USE ) {
            return false;
        }
        var _to_return = this.element.is_disabled || this.element.is_force_to_null;
        if ( !_to_return ) {
            if ( this.element.shinken_element ) {
                _to_return = this.element.shinken_element.is_new;
            }
            else if ( this.element.state === COMPONENT.CONST.TAG.STATE.NEW ) {
                _to_return = true;
            }
        }
        return _to_return;
    },
    buildHTMLParent  : function ( parent_name, index, link ) {
        var _to_return = DOM.Service.createElement( 'div', {
            class       : 'droppable',
            'data-index': index,
            ondrop      : 'MANAGER.DragNDropManager.dropShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '", "' + parent_name + '", this)',
            ondragend   : 'MANAGER.DragNDropManager.dragEndShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '")',
            ondragover  : 'MANAGER.DragNDropManager.dragOverShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '", "' + parent_name + '", this)'
        } );
        this.buildHTML( parent_name, link );
        DOM.Service.addElementTo( this.dom_element, _to_return );
        return _to_return;
    },
    buildHTML        : function ( parent_name, link, full_link ) {
        var dom_param = {
            class               : 'container-tag',
            'data-key-name'     : this.getName(),
            'data-state'        : this.getState(),
            'data-is-disabled'  : this.element.is_disabled,
            'data-force-to-null': this.element.is_force_to_null,
            'data-type'         : this.getType()
        };
        
        if ( parent_name && this.getType() === OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            dom_param[ 'class' ]       = 'container-tag ' + MANAGER.CONST.DRAG_N_DROP.CLASS.DRAGGABLE;
            dom_param[ 'draggable' ]   = true;
            dom_param[ 'ondragstart' ] = 'MANAGER.DragNDropManager.dragStartShinken(event, "' + PROPERTY.CONST.DRAG_N_DROP.TYPE.SELECTED_ITEM + '", "' + parent_name + '", "' + this.getName() + '")';
        }
        if ( parent_name === PROPERTY.CONST.NAME.EDITION_CONTACTS ) {
            if ( !this.element.shinken_element ) {
                this.element.findShinkenElement();
            }
            if ( this.element.shinken_element && !this.element.shinken_element.is_admin && !this.element.shinken_element.is_expert ) {
                dom_param[ 'class' ] = dom_param[ 'class' ] + ' shinken-tag-disabled';
                this.text_tooltip    = _( 'element.tooltip_edition_contact_not_expert' );
            }
        }
        
        var _line        = DOM.Service.createElement( 'tr', { class: 'text-break-all-pre-line' } );
        var _col_content = DOM.Service.createElement( 'td', { class: 'content' } );
        var _col_cube    = DOM.Service.createElement( 'td', { class: 'shinken-tag-cube' } );
        var _title;
        if ( this.element.shinken_element ) {
            _title = SHINKEN.TOOLS.buildLinkShinkenElement( this.element.shinken_element );
        }
        else if ( this.getState() === COMPONENT.CONST.TAG.STATE.INHERITED && full_link ) {
            _title = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( full_link[ 0 ] || '', full_link[ 1 ] || '', this.getLabel() );
        }
        else {
            var _final_id = this.element.uuid;
            switch ( this.element.state ) {
                case COMPONENT.CONST.TAG.STATE.NEW :
                case COMPONENT.CONST.TAG.STATE.OVERRIDE_NEW :
                    _final_id = this.element.uuid + '?new=1';
                    break;
            }
            _title = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( link, _final_id, this.getLabel() );
        }
        var _tbody = DOM.Service.createElement( 'tbody' ); // Tag
        _tbody.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
        _tbody.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        _tbody.setAttribute( "shi-tip-html", '' );
        _tbody.setAttribute( "shi-tip-placement", "bottom" );
        
        this.dom_element = DOM.Service.createElement( 'table', dom_param ); // Tag
        
        
        DOM.Service.addElementTo( _title, _col_content );
        if ( this.isDeletable() ) {
            var _to_close = DOM.Service.createElement( 'span', {
                class  : 'shinken-close-icon',
                onclick: 'MANAGER.EventManager.clickOnDeleteItemSelector("' + parent_name + '","' + this.getName() + '")'
            }, 'x' );
            DOM.Service.addElementTo( _to_close, _col_content );
        }
        DOM.Service.addElementTo( _col_content, _line );
        DOM.Service.addElementTo( _col_cube, _line );
        DOM.Service.addElementTo( _line, _tbody );
        DOM.Service.addElementTo( _tbody, this.dom_element );
    },
    getValueFinal    : function () {
        return this.element.getValueFinal();
    }
};