'use strict';

MANAGER.DistributorSourceManager           = function () {
    this.sources   = {};
    this.view_type = SOURCE.CONST.VIEW_TYPES.DETAIL;
    this.dom_element_module_type;
};
MANAGER.DistributorSourceManager.prototype = {
    toggleViewSource       : function () {
        this.view_type = (this.view_type === SOURCE.CONST.VIEW_TYPES.DETAIL) ? SOURCE.CONST.VIEW_TYPES.ALL : SOURCE.CONST.VIEW_TYPES.DETAIL;
        DOM.Service.setDataSet( this.getDomElementModuleType(), 'displayAll', this.view_type );
    },
    getDomElementModuleType: function () {
        if ( !this.dom_element_module_type ) {
            this.dom_element_module_type = document.getElementById( "modules-type-area" );
        }
        return this.dom_element_module_type;
    },
    createSource           : function ( type ) {
        var _to_return = new SOURCE.Sources( type );
        
        this.sources[ type ] = _to_return;
        
        return _to_return;
    },
    findSource             : function ( name ) {
        var _list_all_sources = this.findSources( SOURCE.CONST.TYPES.ALL );
        return _list_all_sources.getSource( name );
    },
    findSources            : function ( type ) {
        if ( !type ) {
            return;
        }
        
        var _to_return = this.getSource( type );
        
        if ( !_to_return ) {
            _to_return = this.createSource( type );
            switch ( type ) {
                case SOURCE.CONST.TYPES.ALL:
                    break;
                case SOURCE.CONST.TYPES.COLLECTOR:
                case SOURCE.CONST.TYPES.LISTENER:
                case SOURCE.CONST.TYPES.ANALYZER:
                    _to_return.addAllSource( this.sources[ SOURCE.CONST.TYPES.ALL ].getSourceByType( type ) );
                    break;
            }
        }
        return _to_return;
    },
    getSource              : function ( type ) {
        return this.sources[ type ];
    },
    reorderAllSourceDom    : function () {
        var _dom_element = document.getElementById( 'modules-type-area' );
        _dom_element.classList.add( "shinken-animate-order" );
        setTimeout( function () {
            _dom_element.classList.remove( "shinken-animate-order" );
        }, 3000 );
        
        this.reorderSourceDom( SOURCE.CONST.TYPES.ALL );
        this.reorderSourceDom( SOURCE.CONST.TYPES.ANALYZER );
        this.reorderSourceDom( SOURCE.CONST.TYPES.LISTENER );
        this.reorderSourceDom( SOURCE.CONST.TYPES.COLLECTOR );
    },
    reorderSourceDom       : function ( type ) {
        var _current = this.findSources( type );
        if ( !_current ) {
            return;
        }
        _current.reorderDomElement();
    }
};
MANAGER.__instance_source_distributor      = new MANAGER.DistributorSourceManager();