'use strict';

document.addEventListener( "DOMContentLoaded", function ( e ) {
    MANAGER.__instance_navigator_size.run();
} );


MANAGER.NavigatorSizeManager           = function () {
    this._interval;
    this._check_top_shinken_content = true;
    this.init_done                  = false;
};
MANAGER.NavigatorSizeManager.prototype = {
    run                 : function () {
        setTimeout( function () {
            MANAGER.__instance_navigator_size.checkSizes();
        }, 100 );
        this._interval = setInterval( function () {
            MANAGER.__instance_navigator_size.checkSizes();
        }, 4000 );
    },
    initDomElements     : function () {
        this.dom_element_shinken_navigation_table = document.getElementById( 'shinken-id-navigation-table' );
        this.dom_element_shinken_menu_top_bar     = document.querySelector( '.shinken-menu-top-bar' );
        this.dom_element_shinken_content          = document.querySelector( '.shinken-content' );
        var _width_button_log                     = document.querySelector( '.shinken-quit-cell' ).getBoundingClientRect().width;
        var _width_logo_shinken                   = document.querySelector( '.shinken-logo-cell' ).getBoundingClientRect().width;
        var _width_back_button                    = document.querySelector( '.shinken-arrow-back-block-cell' ).getBoundingClientRect().width;
        this.width_nav_bar_used                   = _width_button_log + _width_back_button + _width_logo_shinken;
        this.init_done                            = true;
    },
    checkSizes          : function () {
        this._menu_elements();
        if ( this._check_top_shinken_content ) {
            this._top_shinken_content();
        }
        if ( CONTROLLER.MassChange && CONTROLLER.MassChange.steps ) {
            CONTROLLER.MassChange.computeSizes();
        }
        if ( CONTROLLER.ShinkenElement ) {
            CONTROLLER.ShinkenElement.computeSizes();
        }
    },
    tab_data_exclude    : function () {
        var _dom_element = document.querySelector( "#checks.shinken-host-check-window-container" );
        if ( _dom_element ) {
            if ( _dom_element.dataset.tabSelected === "2" ) {
                var _prop_exclude = document.getElementById( 'id-shinken-exclude-property-container' );
                if ( _prop_exclude ) {
                    var _height                                                                 = _prop_exclude.getBoundingClientRect().height;
                    _dom_element.querySelector( '.shinken-scroll-without-header' ).style.height = "calc(100% - " + _height + "px)";
                }
            }
            else {
                _dom_element.querySelector( '.shinken-scroll-without-header' ).style.height = "100%";
            }
        }
    },
    _menu_elements      : function () {
        if ( !this.dom_element_shinken_navigation_table ) {
            return;
        }
        var _rect = this.dom_element_shinken_navigation_table.getBoundingClientRect();
        
        if ( _rect.width + this.width_nav_bar_used > window.innerWidth ) {
            var _data_responsive = parseInt( this.dom_element_shinken_menu_top_bar.dataset.responsive );
            if ( _data_responsive < 4 ) {
                DOM.Service.setDataSet( this.dom_element_shinken_menu_top_bar, "responsive", _data_responsive + 1 );
                this._menu_elements();
            }
        }
        else {
            setTimeout( function () {
                DOM.BodyService.askAddClass("shinken-menu-ready");
            }, 10 )
        }
    },
    _top_shinken_content: function () {
        this._check_top_shinken_content = false;
        if ( !this.dom_element_shinken_content || !this.dom_element_shinken_menu_top_bar ) {
            return;
        }
        var _height                                      = this.dom_element_shinken_menu_top_bar.getBoundingClientRect().height;
        this.dom_element_shinken_content.style.top       = _height + 'px';
        this.dom_element_shinken_content.style.height    = 'calc(100% - ' + _height + 'px)';
        this.dom_element_shinken_content.style.maxHeight = 'calc(100% - ' + _height + 'px)';
    },
    resizeDone          : function () {
        if ( !this.init_done ) {
            this.initDomElements();
        }
        if ( !this._interval ) {
            return;
        }
        DOM.Service.setDataSet( this.dom_element_shinken_menu_top_bar, "responsive", 0 );
        this._check_top_shinken_content                          = true;
        this.checkSizes();
        if( CONTROLLER.List ){
            CONTROLLER.List.resizeDone();
        }
    }
};

MANAGER.__instance_navigator_size = new MANAGER.NavigatorSizeManager();


function action_when_resizing () {
    MANAGER.__instance_navigator_size.resizeDone();
    var _dom_area_header        = $( '.shinken-area-header' );
    var _dom_form               = $( '#id-shinken-form-element' );
    var _dom_right_column       = $( '#right-column' );
    var _dom_left_column        = $( '#left-column' );
    var _dom_element_list_panel = $( '.elements-list-panel' );
    
    /**********************
     * Resize LIST
     *********************/
    App.Scope.adjustHeight( $( '#top-list-container' ), _dom_element_list_panel, $( '.elements-panel' ), false );
    App.Scope.adjustHeight( $( '.header-background' ), $( '.body-background' ), _dom_element_list_panel );
    
    /*******************************
     * Resize Page Edition element
     *******************************/
    //App.Scope.adjustHeight( _dom_area_header, $( '.form-element' ), _dom_right_column, false, true );
    //App.Scope.adjustHeight( _dom_area_header, _dom_form, _dom_form.parent(), false, true );
    //
    /**************************************
     * Page Edition element - Resize HELP
     **************************************/
    var _dom_info_area     = $( '.info-area' );
    var _dom_info_box_help = $( '.info-box.help' );
    var _dom_action_area   = $( '.action-area' );
    //// ----- Level 1
    //App.Scope.adjustHeight( _dom_action_area, _dom_info_area, _dom_left_column, false );
    //// ----- Level 2
    //App.Scope.adjustHeight( $( '#shinken-box-content-legend' ), _dom_info_box_help, _dom_info_area, false );
    //// ----- Level 3
    //App.Scope.adjustHeight( $( '#shinken-help-title' ), $( '#shinken-help-content' ), _dom_info_box_help, false );
    
    /*******************************
     * Resize Page Production
     *******************************/
    App.Scope.adjustHeight( $( '.main-header' ), $( '.main-content' ), $( '#main-right' ) );
    App.Scope.adjustHeight( _dom_action_area, $( '#left-panel-error' ), _dom_left_column );
    
    /*******************************
     * Resize Page Source and Tagger
     *******************************/
    App.Scope.adjustHeightMulti( $( '.table-head-js' ), $( '.table-body-js' ), $( '.table-shinken-js' ), false );
    
    /*******************************
     * Reposition Add Comment pop-up
     *******************************/
    var _element_add_comment_specific = document.getElementById( "comment-to-submit-for-staging" );
    if ( _element_add_comment_specific && _element_add_comment_specific.classList.contains( "active" ) ) {
        document.getElementById( "element-btn-submit-to-stagging-add-comment" ).click();
    }
    var _element_add_comment_list = document.getElementById( "comment-to-action-launch" );
    if ( _element_add_comment_list && _element_add_comment_list.classList.contains( "active" ) ) {
        var _element = document.querySelector( "#btn-action-launch-add-comment .label-button-mass-action" );
        if ( _element ) {
            _element.click();
        }
    }
}

$( window ).resize( action_when_resizing );

$( document ).ready( function () {
    $( window ).trigger( 'resize' );
} );

