'use strict';

MANAGER.WorkFlowManager = {
    dom_element_body: null,
    state           : null,
    setState        : function( state ) {
        this.state = state;
        DOM.Service.setDataSet( this.getDomElement(), 'stateWorkFlow', state );
        var save_in_staging         = (this.state === MANAGER.CONST.STATE.WORK_FLOW.STAGING ? '1' : '0');
        var params                  = SHINKEN.HIGHWAY.getParams();
        params[ 'save_in_staging' ] = save_in_staging;
        SHINKEN.HIGHWAY.changeUrl( SHINKEN.HIGHWAY.getPath() + SHINKEN.HIGHWAY.buildParamsToUrl( params ) );
    },
    getState        : function() {
        if ( !this.state ) {
            this.state = this.getDomElement().dataset.stateWorkFlow;
        }
        return this.state;
    },
    clickOnTabArea  : function( to_set ) {
        this.setState( to_set );
        if ( CONTROLLER.List ) {
            CONTROLLER.List.mass_action.computeTitleSelect();
        }
        $( window ).trigger( 'resize' );
    },
    getDomElement   : function() {
        if ( !this.dom_element_body ) {
            this.dom_element_body = document.querySelector( 'body' );
        }
        return this.dom_element_body;
    }
};

