'use strict';

OBJECT.CONST.PHASE = {
    RUNNING                 : 0,
    REFRESHING              : 1,
    INIT                    : 2,
    EDITING                 : 3,
    SAVING                  : 4,
    WAITING_FOR_START_IMPORT: 5,
    WAITING_FOR_IMPORT      : 6,
    WAITING_FOR_MERGE       : 7,
    WAITING_FOR_UPDATE      : 8,
    READY                   : 9,
    WAITING_FOR_READY       : 10,
    SLEEPING                : 11
};

OBJECT.Phase           = function () {
    this.previous_phase = null;
    this.current_phase  = OBJECT.CONST.PHASE.INIT;
    this.next_phase     = null;
};
OBJECT.Phase.prototype = {
    setPhase           : function ( to_set ) {
        this.previous_phase = this.current_phase;
        this.current_phase  = to_set;
        this.next_phase     = null;
    },
    setPhaseWithTimeOut: function ( to_set, timeout ) {
        if ( !timeout ) {
            timeout = 0;
        }
        var self = this;
        setTimeout( function () {
            self.previous_phase = this.current_phase;
            self.current_phase  = to_set;
        }, timeout );
    },
    isPhase            : function ( to_test ) {
        return this.current_phase === to_test;
    }
};
