%see_all_button = in_working_area
%extra_class = 'white-around' if in_working_area else ''

<div class='elements-title-panel'>
    <div class="title {{extra_class}}">
        %if not in_working_area:
            <img class="database-image" src="/static/{{app.http_start_time}}/main/img/databases.png">
            <span class="database-text">{{app._('header.staging')}}</span> >
        %end
        <span class="database-text">{{!title}}</span>
    </div>


    %if see_all_button:
        <div class="see-all-button">
            %if mypage == 'my_working_area':
                <a class="btn-elements" href="/elements/working_area/{{item_type}}">
                    {{app._('element.see_all_element')}}
                </a>
            %elif mypage == 'working_area':
                <a class="btn-elements" href="/elements/my_working_area/{{item_type}}">
                    {{app._('element.see_only_working')}}
                </a>
            %end
        </div>
    %end

    <div class="shinken-action">
        %if show_analyze_button:
            %if analyzer_enabled:
            %   analyzer_enable_class = 'shinken-active'
            %   analyzer_tooltip_message = app._('element.tooltip_analyzer_no_host_selected')
            %else:
            %   analyzer_enable_class = 'shinken-content-disabled'
            %   analyzer_tooltip_message = app._('element.tooltip_analyzer_disabled')
            %end
            <div id="analyze-button-div" class="{{analyzer_enable_class}}" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this);" onmouseleave="SHINKEN_TOOLTIP.hideTooltip();" shi-tip-placement="left" shi-tip-html="{{ analyzer_tooltip_message }}">
                <a id="analyze-button-redirect" class="btn-elements" onclick="redirect_to_analyzer();" draggable="false">
                    <i class="icon-search"></i>&nbsp;{{app._('element.analyze')}}
                </a>
            </div>
        %end

        %if show_add_button:
            <div class="add-button">
                %_url_add = '/elements/add/working_area/%ss'%addpage if addpage == 'host' else '/elements/add/%s'%addpage
                <a class="btn-elements" href="{{_url_add}}" draggable="false">
                    <i class="icon-plus"></i>&nbsp;{{app._('element.add')}} [ {{app._('type.%s'%item_type[:-1])}} ]
                </a>
            </div>
        %end
     </div>
</div>
