%placeholder = app._("mass-change.place_holder_no_filter")
<div class="shinken-mass-change-summary-full-title">
    <span>{{app._("mass-change.step-4.table-summary.title")}}</span>
</div>
%_extra_class = '' if have_plus_in_list else 'shinken-have-no-plus-in-list'
<div class="shinken-list-container shinken-mass-change-summary-full shinken-selected {{_extra_class}}">
    <table class="shinken-width-100 shinken-table-mass-change-full-sum">
        <thead>
            <tr class="shinken-mass-change-header shinken-parent-target-click shinken-header-line">
                <th class="shinken-list-header shinken-check-box-cell shinken-check-box-cell-with-setter"></th>
                <th class="shinken-list-header shinken-elements-cell">{{!app._("mass-change.step-4.table-summary.headers.elements").format(type_label)}}</th>
                %if type_modification == MASSIVE_CHANGE_TYPE.OVERRIDES:
                    <th class="shinken-list-header shinken-check-cell">{{app._("mass-change.step-4.table-summary.headers.check")}}</th>
                %end
                <th class="shinken-list-header shinken-category-cell">{{app._("mass-change.step-4.table-summary.headers.category")}}</th>
                <th class="shinken-list-header shinken-property-cell">{{app._("mass-change.step-4.table-summary.headers.property")}}</th>
                <th class="shinken-list-header shinken-initial-value-cell-plus shinken-initial-value-plus-cell-with-setter"></th>
                <th class="shinken-list-header shinken-initial-value-cell"><span class="shinken-keep-all-space">{{app._("mass-change.step-4.table-summary.headers.initial-value")}}</span></th>
                <th class="shinken-list-header shinken-final-value-cell-plus shinken-final-value-plus-cell-with-setter"></th>
                <th class="shinken-list-header shinken-final-value-cell"><span class="shinken-keep-all-space">{{app._("mass-change.step-4.table-summary.headers.final-value")}}</span></th>
                <th class="shinken-list-header shinken-action-cell">{{app._("mass-change.step-4.table-summary.headers.action")}}</th>
                <th class="shinken-list-header shinken-counters-cell">{{app._("mass-change.step-4.table-summary.headers.counters")}}</th>
                <th class="shinken-list-header shinken-collapse-cell"></th>
            </tr>
            <tr class="shinken-mass-change-filter shinken-filter-line shinken-collapse-parent">
                {{!helper_object.get_check_box_cell_html(1,-1,'shinken-all-elements', class_to_add='shinken-all-elements shinken-check-box-cell-with-setter')}}
                <th class="shinken-list-filter shinken-elements-cell" data-name="elements" data-object-type="shinken-list-filter" data-type="input_string">{{!helper.helper_component.get_input_html('input', '', placeholder=placeholder)}}</th>
                %if type_modification == MASSIVE_CHANGE_TYPE.OVERRIDES:
                    <th class="shinken-list-filter shinken-check-cell" data-name="check" data-object-type="shinken-list-filter" data-type="input_string">{{!helper.helper_component.get_input_html('input', '', placeholder=placeholder)}}</th>
                %end
                <th class="shinken-list-filter shinken-category-cell" data-name="category" data-object-type="shinken-list-filter" data-type="input_string">{{!helper.helper_component.get_input_html('input', '', placeholder=placeholder)}}</th>
                <th class="shinken-list-filter shinken-property-cell" data-name="property" data-object-type="shinken-list-filter" data-type="input_string">{{!helper.helper_component.get_input_html('input', '', placeholder=placeholder)}}</th>
                {{!helper.mass_change_helper.get_cell_mass_change_plus_filter_html('initial-value-plus', class_to_add="shinken-initial-value-plus-cell-with-setter")}}
                <th class="shinken-list-filter shinken-initial-value-cell" data-name="initial-value" data-object-type="shinken-list-filter" data-type="input_string">{{!helper.helper_component.get_input_html('input', '', placeholder=placeholder)}}</th>
                {{!helper.mass_change_helper.get_cell_mass_change_plus_filter_html('final-value-plus', class_to_add="shinken-final-value-plus-cell-with-setter")}}
                <th class="shinken-list-filter shinken-final-value-cell" data-name="final-value" data-object-type="shinken-list-filter" data-type="input_string">{{!helper.helper_component.get_input_html('input', '', placeholder=placeholder)}}</th>
                {{!helper.mass_change_helper.get_cell_mass_change_action_filter_html(step)}}
                {{!helper.mass_change_helper.get_cell_mass_change_counter_filter_html('counters')}}
                {{!helper_object.get_check_collapse_cell_html(0,'shinken-all-elements', class_to_add='shinken-action-cell', shinkon_plus='shinicon-angle-double-down', shinkon_minus='shinicon-angle-double-up')}}
            </tr>
        </thead>
    </table>
    %_action_text_error = '<div class="shinken-action-label shinken-toggle-button-active"><span class="shinkon-warning-lite"></span><span class="shinken-label">%s</span></div>' % app._('common.look_at')
    %for item in mass_change_detail.elements:
        %if not item.get_properties() and not item.get_overrides():
            %continue
        %end
        %_uuid = item.get_uuid()
        %_parent_class = "shinken-is-error" if item.error_counter else ""
        %_class = "shinken-selected-disabled" if item.error_counter else "shinken-selected"
        %_checkbox_status = -1 if item.error_counter else 1
        %_action_text = _action_text_error if item.has_validation_messages else ""
        <div class="shinken-table-mass-change-full-sum-data-container shinken-selected-parent {{_parent_class}}">
            <table class="shinken-width-100 shinken-table-mass-change-full-sum">
                <thead>
                    <tr class="shinken-mass-change-header shinken-header-line">
                        <th class="shinken-check-box-cell shinken-check-box-cell-with-setter"></th>
                        <th class="shinken-elements-cell"></th>
                        %if type_modification == MASSIVE_CHANGE_TYPE.OVERRIDES:
                            <th class="shinken-check-cell"></th>
                        %end
                        <th class="shinken-category-cell"></th>
                        <th class="shinken-property-cell"></th>
                        <th class="shinken-initial-value-cell shinken-initial-value-plus-cell-with-setter"></th>
                        <th class="shinken-initial-value-cell"></th>
                        <th class="shinken-final-value-cell shinken-final-value-plus-cell-with-setter"></th>
                        <th class="shinken-final-value-cell"></th>
                        <th class="shinken-action-cell"></th>
                        <th class="shinken-counters-cell"></th>
                        <th class="shinken-collapse-cell"></th>
                    </tr>
                </thead>
                <tbody class="shinken-list-line-tbody-main shinken-list-line {{_class}} shinken-collapse-parent shinken-parent-target-click shinken-parent-event-listener"
                       data-uuid="{{_uuid}}"
                       data-controller="mass-change"
                       data-parent-select-class="shinken-table-mass-change-full-sum-data-container">
                    <tr>
                        {{!helper_object.get_check_box_cell_html(_checkbox_status,-1,_uuid, class_to_add='shinken-list-line-checkbox shinken-check-box-cell-with-setter shinken-top-space-maker')}}
                        %colspan = '8' if type_modification == MASSIVE_CHANGE_TYPE.OVERRIDES else '7'
                        <td colspan="{{colspan}}" class="shinken-list-cell shinken-elements-cell shinken-top-space-maker" data-filter="elements">{{!item.get_name_to_html(app)}}</td>
                        <td class="shinken-list-cell shinken-action-cell shinken-user-select-none" data-filter="action" data-filter-value="**SHINKEN_HAS_CHILDREN**">{{!_action_text}}</td>
                        <td class="shinken-list-cell shinken-counters-cell shinken-top-space-maker" data-filter="counters" data-filter-value-array="{{item.get_counter_cell_filter_value()}}">{{!item.get_counter_cell_content(app)}}</td>
                        {{!helper_object.get_check_collapse_cell_html(0,_uuid, class_to_add='shinken-action-cell')}}
                        %if type_modification == MASSIVE_CHANGE_TYPE.OVERRIDES:
                            <td class="shinken-list-cell shinken-hidden" data-filter="check">**SHINKEN_HAS_CHILDREN**</td>
                        %end
                        <td class="shinken-list-cell shinken-hidden" data-filter="category">**SHINKEN_HAS_CHILDREN**</td>
                        <td class="shinken-list-cell shinken-hidden" data-filter="property">**SHINKEN_HAS_CHILDREN**</td>
                        <td class="shinken-list-cell shinken-hidden" data-filter="initial-value-plus">**SHINKEN_HAS_CHILDREN**</td>
                        <td class="shinken-list-cell shinken-hidden" data-filter="initial-value">**SHINKEN_HAS_CHILDREN**</td>
                        <td class="shinken-list-cell shinken-hidden" data-filter="final-value-plus">**SHINKEN_HAS_CHILDREN**</td>
                        <td class="shinken-list-cell shinken-hidden" data-filter="final-value">**SHINKEN_HAS_CHILDREN**</td>
                    </tr>
                    %if item.has_validation_messages:
                        <tr class="shinken-error-warning-detail">
                            <td colspan="2" class="shinken-hover-box-shadow"></td>
                            %if type_modification == MASSIVE_CHANGE_TYPE.OVERRIDES:
                                <td colspan="10" class="shinken-hover-box-shadow">
                            %else:
                                <td colspan="9" class="shinken-hover-box-shadow">
                            %end
                                <div class="shinken-mass-change-error-warning">
                                    {{!item._validation_errors_html}}
                                    {{!item._validation_warnings_html}}
                                </div>
                            </td>
                        </tr>
                    %end
                </tbody>
                %if type_modification == MASSIVE_CHANGE_TYPE.OVERRIDES:
                    %for override in item.get_overrides():
                        %for prop in override.get_properties():
                            %include( "massive_change/step_4/summary-line" )
                        %end
                    %end
                %else:
                    %for prop in item.get_properties():
                        %include( "massive_change/step_4/summary-line" )
                    %end
                %end
            </table>
        </div>
    %end
</div>