%import shinkensolutions.shinkenjson as json;
%import base64;

%is_admin = user.is_admin()

%include( "__shinken-lib", type="MAIN")
%rebase( "layout_skonf", page_id="main", title=app._('main.title'))

<div class="content-staging elements" >
    <div class="elements-inner" >
        <div class="header" >
            <img class="database-image" src="/static/{{app.http_start_time}}/main/img/databases.png" >
            <a href="/elements/elements" class="database-text" >
                {{app._('main.staging')}}
            </a>
        </div >
        %include("element_panel", locals=locals())
    </div >
</div >
%if is_admin:
    <div class="shinken-content-sources autodetection" >
        <div class="autodetection-inner" >
            <div class="header" >
                {{app._('main.automatic_detection_modules')}}
            </div >
            <div id="modules-type-area" class="modules-type-area" data-display-all="0"  >
                <div class="module-type-name" >{{app._('main.sources_maj')}} ></div >
                <div id="error-sources" class="error-tab" style="display: none;" ></div >
                <div id="sort-list-source" onclick="MANAGER.EventManager.clickOnToggleViewSource()"  >
                    <div class="box-icon">
                        <span class="icon-sort" ></span >
                    </div >
                    <p >{{app._('main.change_sources_order')}}</p >
                </div >
                <div id="view-sources" onclick="MANAGER.EventManager.clickOnToggleViewSource()" >
                    <div class="box-icon">
                        <span class="icon-sort" ></span >
                    </div >
                    <p >{{app._('main.view_sources')}}</p >
                </div >
                %include("element_list_source_all")
                %include("element_list_source_analyzer")
                %include("element_list_source_listener")
                %include("element_list_source_collector")
                <div class="separator" ></div >
                %include("element_list_tagger")
                %include("ip_range_line_template")
            </div >
        </div >
    </div >
%else:
    %include("_workflow.tpl")
%end

<script>
    var sources = '{{!base64.b64encode(json.dumps(sources))}}';
</script >




