%status_list = [("ok", app._('element.%s' % "ok")), ("warning", app._('element.%s' % "warning")), ("error", app._('element.%s' % "error"))]
%sname = source.get_name()
%stype = source.type

%listener_or_analyzer = stype in ('listener', 'analyzer')

%number_of_col = 7 if listener_or_analyzer else 5

%is_selectable = False

<!-- Table -->
<div class="table-head-js scroll-head content responsive">
    <table class="table striped bordered" role="grid">
        <thead>
            <tr role="row">
                %if is_selectable:
                    <th class="col-check"></th>
                %end
                <th class="shinken-col-status">{{app._('element.status')}}</th>
                <th class="col-class">{{app._('source.class')}}</th>
                <th class="col-type">{{app._('source.name')}}</th>
                <th class="col-sync">{{app._('source.synchronization_keys')}}</th>
                %if listener_or_analyzer:
                    <th class="col-update-date" >{{app._('source.update_date')}}</th>
                %end
                <th class="col-action" >{{app._('source.expand')}}</th>
                %if listener_or_analyzer:
                    <th class="col-delete" >{{app._('source.delete')}}</th>
                %end
            </tr>
        </thead>
    </table>
</div>
<div class="table-filter-js scroll-head filter content responsive">
    <table class="table striped bordered" role="grid">
        <tr role="row">
            %if is_selectable:
                <th class="col-check">
                    <input id="selected-all" type="checkbox" value="0"/>
                </th>
            %end
            <th class="shinken-col-status">
                %value_status = filters.get('status','')
                %_filled_class = 'filled' if value_status else ''
                <select data-filter-tag-js="status" class="form-control input-sm {{_filled_class}}"  title="">
                    <option value="0">-- {{app._('apply.all')}} --</option>
                    %for index, value in  status_list:
                        %_selected =  'selected' if value_status == index else ''
                        <option value="{{index}}" {{_selected}} >{{value}}</option>
                    %end
                </select>
            </th>
            <th class="col-class">
                %value_class = filters.get('class','')
                %_filled_class = 'filled' if value_class else ''
                <select data-filter-tag-js="class" class="form-control input-sm {{_filled_class}}"  title="">
                    <option value="0">-- {{app._('apply.all')}} --</option>
                    %for display_item_type in display_item_types:
                        %_selected =  'selected' if value_class == display_item_type['type'] else ''
                        <option value="{{display_item_type['type']}}" {{_selected}} >{{display_item_type['display']}}</option>
                    %end
                </select>
            </th>
            <th class="col-type">
                %value_name = filters.get('name','')
                %_filled_name = 'filled' if value_name else ''
                <input value="{{value_name}}" data-filter-tag-js="name" placeholder="{{app._('source.no_filter')}}" class="form-control input-sm {{_filled_name}}" type="search"/>
            </th>
            <th class="col-sync">
                %value_sync = filters.get('sync','')
                %_filled_sync = 'filled' if value_sync else ''
                <input value="{{value_sync}}" data-filter-tag-js="sync" placeholder="{{app._('source.no_filter')}}" class="form-control input-sm {{_filled_sync}}" type="search"/>
            </th>
            %if listener_or_analyzer:
                <th class="col-update-date" ></th>
            %end
            <th class="col-action" ></th>
            %if listener_or_analyzer and list:
                <th class="col-delete" >
                    <a onclick="deleteSourceElementConfirm('{{source.source_name}}')">
                        <span class="shinkon shinkon-broom discreet"></span>
                    </a>
                </th>
            %end
        </tr>
    </table>
</div>
<div class="table-body-js scroll-body content responsive">
    <table class="table striped bordered" role="grid">
        <tbody>
            %if len(list) == 0:
                <div class="col-sm-12">
                    <h1>{{app._('source.no_objects')}}</h1>
                </div>
            %else:
                %i = 0
                %for item in list:
                    %id_class    = item.get('_id').replace('.', '_') # with . replace by _ because jquery don't like the . in ids
                    %id          = item.get('_id')
                    %type        = item.get('@type')
                    %name        = item.get('@name')
                    %update_date = item.get('@update_date')
                    %hash        = item.get('@hash')
                    %import_warnings = item.get('@import_warnings', None)
                    %import_errors = item.get('@import_errors', None)
                    %item_status = []
                    %data_state = ""
                    %if import_errors:
                        %item_status.append("error")
                        %data_state = "CRITICAL"
                    %end
                    %if import_warnings:
                        %item_status.append("warning")
                        %data_state = "%s WARNING" % data_state if data_state else "WARNING"
                    %end
                    %if not len(item_status):
                        % item_status.append("ok")
                        %data_state = "OK"
                    %end

                    % odd_or_even = 'even' if (i%2 == 0) else 'odd'
                    %i = i+1
                    <tr class="{{odd_or_even}} shinken-source-state-container" role="row" data-state="{{data_state}}" >
                        %if is_selectable:
                            <td class="col-check"><input type="checkbox" value="0"/></td>
                        %end
                        <td class="shinken-col-status state-current-status">
                            %for status in item_status:
                                <span class="shinken-state-label shinken-tag-status {{status}}">{{app._('element.%s' % status)}}</span>
                            %end
                        </td>
                        <td class="col-class text-break-all" data-th="{{app._('source.class')}}">{{app._('type.%s' % type)}}</td>
                        <td class="col-type" data-th="{{app._('type.%s'%type)}} {{app._('source.name')}}">{{name}}</td>
                        <td class="col-sync" data-th="{{app._('source.synchronization_keys')}}">{{', '.join(item.get('_SYNC_KEYS', []))}}</td>
                        %if listener_or_analyzer and update_date:
                            <td class="col-update-date" data-th="{{app._('source.update_date')}}" >{{app.helper.print_date(update_date)}}</td>
                        %end
                        <td class="col-action" data-th="{{app._('source.expand')}}" >
                            <div class="show-item-js shinken-source-item-action"
                                data-last-run-number="{{last_run_number}}"
                                data-target="#elt-{{type}}-{{id_class}}-collapse"
                                data-name="{{source.source_name}}"
                                data-type="{{type}}" data-id="{{id}}"
                                data-id-class="{{id_class}}"
                                data-hash="{{hash}}">
                                <i class="icon-eye-open"></i>
                            </div>
                        </td>
                        %if listener_or_analyzer:
                            <td class="col-delete" data-th="{{app._('source.delete')}}" >
                                <div class="delete-item-js shinken-source-item-action" data-name="{{source.source_name}}" data-type="{{type}}" data-id="{{id}}">
                                    <span class="shinkon shinkon-broom discreet"></span>
                                </div>
                            </td>
                        %end

                    </tr>
                    <tr id="elt-{{type}}-{{id_class}}-collapse" role="row" >
                        <td colspan="{{number_of_col}}" id="elt-{{type}}-{{id_class}}" class="shinken-class-collapsable shinken-collapsed"></td>
                    </tr>

                %end
            %end
        </tbody>

    </table>
</div>