#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import component_manager


class ShinkenObject(object):
    
    def __init__(self, translate=None):
        self.translate = translate if translate else component_manager.get_translate_component().translator()
    
    
    @staticmethod
    def wrap_in_middle_vertical_align_container(content):
        # type: (str)-> str
        return '''<div class="shinken-display-table"><div class="shinken-display-table-cell">%s</div></div>''' % content
    
    
    def _(self, key):
        # type: (str)-> str
        return self.translate.translate(key)
    
    
    @staticmethod
    def get_http_start_time():
        return component_manager.get_configuration_component().http_start_time
    
    
    @staticmethod
    def get_html_tooltip(text='', message_type='', placement=""):
        _attribute_type = '''shi-tip-type="%s"''' % message_type if message_type else ''
        _attribute_placement = '''shi-tip-placement="%s"''' % placement if placement else ''
        return '''onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" %s shi-tip-html="%s" %s''' % (_attribute_type, text.replace('&', '&amp;'), _attribute_placement)
    
    
    def get_html(self):
        raise NotImplementedError()
