#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.

import time

from pymongo.errors import AutoReconnect


def retry_on_auto_reconnect(func):
    def wrapper(self, *args, **kwargs):
        left_round = self._auto_reconnect_max_try
        collection_name = getattr(self, '_collection_name', '')
        if collection_name:
            operation_name = '%s on %s' % (func.__name__, collection_name)
        else:
            operation_name = '%s' % func.__name__
        while left_round:
            try:
                return func(self, *args, **kwargs)
            except AutoReconnect as e:
                if left_round <= 1:
                    self.logger.info('[MONGO] ' 'Mongo ask a AutoReconnect on the operation %s and we try %s time but it keep failing' % (operation_name, self._auto_reconnect_max_try))
                    raise e
                self.logger.info('[MONGO] ' 'Mongo ask a AutoReconnect on the operation %s retrying %s/%s' % (operation_name, self._auto_reconnect_max_try - left_round + 1, self._auto_reconnect_max_try))
                time.sleep(self._auto_reconnect_sleep_between_try)
                left_round -= 1
                
    
    
    return wrapper
