#!/bin/bash


DEST=""
SYNCHRONIZER_IP=""



function doexit {
    printf "\033[91m $1 \033[0m\n"
    exit 2
}


function display_help {
    printf "launch-server-analyzer [options]\n"
    printf "This tool will make an analyze of the distant server (linux).\n"
    printf "Options:\n"
    printf "  --help              -h  : will display this help\n"
    printf "  --server            -s  : server to analyze\n"
    printf "  --listener          -l  : REST API listener IP address\n"
}


while :
do
    case "$1" in
	
	-h | --help)
	    display_help
	    # Call help function no shifting needed here, we're done.
	    exit 0
	    ;;
	-s | --server)
	    DEST="$2"
	    shift
	    shift
	    ;;
	-l | --listener)
	    SYNCHRONIZER_IP="$2"
	    shift
	    shift
	    ;;
	-*)
	    display_help
	    doexit "Unknown option: $1"
	    ;;
	*)
	    if [ ! -z $1 ]
	    then
		display_help
		doexit "Unknown option: $1"
	    fi
	    # No more options
	    break
	    ;;
    esac
done

if [ "X$DEST" == "X" ]; then
    doexit "The --server parameter is mandatory"
fi

export SERVER_ANALYZER_PATH="/var/lib/shinken/analyzer/server-analyzer.tar.gz"
export EXECUTE_ANALYZER_ON_SERVER_PATH="/var/lib/shinken/libexec/analyzer/execute_analyzer_on_server.sh"

if [ "X$SYNCHRONIZER_IP" == "X" ]; then
    SYNCHRONIZER_IP=$(hostname -I|awk '{print $1}')
fi



export LOG=/tmp/server_analyzer_$DEST.log
> $LOG

export RESULT_PAYLOAD=/tmp/server_analyzer_$DEST.result
> $RESULT_PAYLOAD

cd /root


# 94 = blue
BLUE='\033[94m'
# 94 = blue
MAGENTA='\033[95m'
# 90 = grey
GREY='\033[90m'
# 91 = red
RED='\033[91m'
# 92 = green
GREEN='\033[92m'
# 93 = yellow
YELLOW='\033[93m'
# 0 = reset
RESET='\033[0m'

SPINNER_ARRAY_IDX=0
SPINNER_ARRAY=("⣷" "⣯" "⣟" "⡿" "⢿" "⣻" "⣽" "⣾")
SPINNER_ARRAY_LEN=8

increase_spinner(){
    SPINNER_ARRAY_IDX=`expr $SPINNER_ARRAY_IDX + 1`
    SPINNER_ARRAY_IDX=`expr $SPINNER_ARRAY_IDX % $SPINNER_ARRAY_LEN`
}

get_spinner(){
    echo ${SPINNER_ARRAY[$SPINNER_ARRAY_IDX]}
}




push_agent(){
    DEST=$1
	OUT=$(scp -o LogLevel=ERROR -o BatchMode=yes -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no $SERVER_ANALYZER_PATH $EXECUTE_ANALYZER_ON_SERVER_PATH $DEST:/tmp 2>&1)
	if [ $? != 0 ]; then
	    printf "\nERROR: cannot copy the discovery pack on the server $1:\n"
	    printf "%s\n" "$OUT"
	    exit 2
    fi
}


export -f push_agent



analysing_server(){
    DEST="$1"
    
    EXEC=$(ssh -o LogLevel=ERROR  -o BatchMode=yes -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no $DEST "/bin/bash /tmp/execute_analyzer_on_server.sh" 2>&1)


    printf "%s" "$EXEC" >> $LOG

    if [ $? != 0 ]; then
	   printf "\n$RED Х ERROR$RESET\n"
	   printf "ERROR: The focus discovery did return an error:\n"
	   cat $LOG
	   exit 2
    fi

    RES=$(scp -o LogLevel=ERROR  -o BatchMode=yes -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no $DEST:/tmp/shinken-local-analyzer-payload.json $RESULT_PAYLOAD)
    if [ $? != 0 ]; then
	   printf "\n$RED Х ERROR$RESET\n"
	   printf "ERROR: The focus discovery did run well, but we cannot get back results:\n"
	   printf "%s\n" "$RES"
	   exit 2
    fi
}

export -f analysing_server

push_to_synchronizer(){
    EXEC=$(curl --header "Content-Type: application/json" -XPUT -d @$RESULT_PAYLOAD  --unix-socket /var/lib/shinken/server-analyzer.sock http:/v1/hosts/ 2>&1)

    printf "%s" "$EXEC" >> $LOG

    if [ $? != 0 ]; then
	   printf "\n$RED Х ERROR$RESET\n"
	   printf "ERROR: The analyzer did return an error:\n"
	   cat $LOG
	   exit 2
    fi

}

export -f push_to_synchronizer

printf "\n$BLUE─────────────$RESET Analysing the server $MAGENTA$1$RESET   (1/2)\n"

printf "    ┌──────────────────────┐                                    ┌────────────────────────┐\n"
printf "    │    Synchronizer      │                                    │      Target server     │\n"
printf "    │   $MAGENTA%15s$RESET    │                                    │  $MAGENTA%15s$RESET       │\n"  "$SYNCHRONIZER_IP" "$1"
printf "    └──────────────────────┘                                    └────────────────────────┘\n"


printf "    ┌──────────────────────┐                                    ┌────────────────────────┐\n"
printf "    │                      │  1: Push analyze script            │                        │\n"
printf "    │                      │  ──────────────────────────────→   │                        │"

push_agent "$DEST" &
PROC_ID=$!
while kill -0 "$PROC_ID" >/dev/null 2>&1; do
    increase_spinner
    SPINNER_CHAR=`get_spinner`
    printf "\r    │                      │  ──────────────────────────────→   │           $BLUE$SPINNER_CHAR$RESET            │"
    sleep 0.1
done
# we are using wait to have the return code from the $PROC_ID
wait %1
if [ $? != 0 ]; then
    exit $?
fi

printf "\r    │                      │  ──────────────────────────────→   │          $GREEN √$RESET            │\n"
printf "    │                      │                                    │                        │\n"


printf "    │                      │  2: Analysing target server        │                        │\n"
printf "    │                      │                         ───────→   │                        │"

analysing_server "$DEST" &
PROC_ID=$!
while kill -0 "$PROC_ID" >/dev/null 2>&1; do
    increase_spinner
    SPINNER_CHAR=`get_spinner`
    printf "\r    │                      │                         ───────→   │           $BLUE$SPINNER_CHAR$RESET            │"
    sleep 0.1
done
# we are using wait to have the return code from the $PROC_ID
wait %1
if [ $? != 0 ]; then
    exit $?
fi


printf "\r    │                      │                         ───────→   │           $GREEN√$RESET            │\n"
printf "    │                      │  3: Create/Update host             │                        │\n"
push_to_synchronizer

printf "    │ $MAGENTA REST API LIstener$RESET   │  ←───────                          │           $GREEN√$RESET            │\n"
printf "    └──────────────────────┘                                    └────────────────────────┘\n"


printf "\n"
printf "$GREY | you can look at the discovery execution logs at $LOG\n$RESET"

printf "\n\n$BLUE─────────────$RESET Results for $MAGENTA$1$RESET   (2/2)\n"

TEMPLATES=$(cat $RESULT_PAYLOAD | grep "use" | awk '{print $2}' | cut -d'"' -f2 )
printf " * Templates → $MAGENTA$TEMPLATES$RESET \n"

HOST_NAME=$(cat $RESULT_PAYLOAD | grep "host_name" | awk '{print $2}'| cut -d'"' -f2 )
printf " * Name      → $MAGENTA$HOST_NAME$RESET \n"


PUBLIC_IP=$(cat $RESULT_PAYLOAD | grep "PUBLIC_IP" | awk '{print $2}'| cut -d'"' -f2 )
printf " * Public ip → $MAGENTA$PUBLIC_IP$RESET \n"



printf "\n\nServer analysing is $GREEN√ OK$RESET\n"
