#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.


import json

from shinken.basemodule import BaseModule, SOURCE_STATE
from shinken.log import logger

properties = {
    'daemons': ['synchronizer'],
    'type'   : 'json-import',
}


# called by the plugin manager to get a module
def get_instance(plugin):
    logger.info('[JSON Import] Get a JSON import module for plugin %s' % plugin.get_name())
    
    # Catch errors
    path = plugin.path
    
    instance = JSON_Import(plugin, path)
    return instance


# Just print some stuff
class JSON_Import(BaseModule):
    def __init__(self, mod_conf, path):
        BaseModule.__init__(self, mod_conf)
        self.path = path
        self.file = None
        self.obj = {}
        self.err = None
    
    
    def init(self):
        logger.info('[JSON Import] Initialization')
    
    
    def get_objects(self):
        try:
            with open(self.path, 'rb') as self.file:
                self.obj = json.load(self.file)
        except Exception, exp:
            self.err = exp
        
        if self.err is not None:
            return {
                'state'   : SOURCE_STATE.CRITICAL,
                'output'  : 'File %s cannot be load' % self.path,
                'objects' : {},
                'errors'  : [str(self.err)],
                'warnings': []
            }
        
        logger.debug('[JSON Import] RETURN OBJ %s' % self.obj)
        
        res = {
            'state'   : SOURCE_STATE.OK,
            'output'  : 'File %s was load successfully' % self.path,
            'objects' : self.obj,
            'errors'  : [],
            'warnings': []
        }
        
        return res
