#!/usr/bin/python

# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
# Gabes Jean, naparuba@gmail.com
# Gerhard Lausser, Gerhard.Lausser@consol.de
# Gregory Starck, g.starck@gmail.com
# Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken. If not, see <http://www.gnu.org/licenses/>.


import os

from shinken.basemodule import BaseModule
from shinkensolutions.ssh_mongodb.sshtunnelmongomgr import mongo_by_ssh_mgr

properties = {
    'daemons' : ['arbiter', 'webui', 'skonf'],
    'type'    : 'mongodb',
    'external': False,
    'phases'  : ['configuration'],
}


# called by the plugin manager to get a module instance
def get_instance(plugin):
    uri = plugin.uri
    database = plugin.database
    
    instance = MongodbConnector(plugin, uri, database)
    return instance


# This module job is to get configuration data (mostly hosts) from a mongodb database.
class MongodbConnector(BaseModule):
    def __init__(self, mod_conf, uri, database):
        BaseModule.__init__(self, mod_conf)
        self.logger.debug('creating new mongodb module')
        self.uri = uri
        self.database = database
        
        self.use_ssh_tunnel = getattr(mod_conf, 'use_ssh_tunnel', False) in ['1', True]
        self.use_ssh_retry_failure = int(getattr(mod_conf, 'use_ssh_retry_failure', 1))
        self.ssh_user = getattr(mod_conf, 'ssh_user', os.getenv('USER'))
        self.ssh_keyfile = getattr(mod_conf, 'ssh_keyfile', '~shinken/.ssh/id_rsa')
        
        # Some used variable init
        self.con = None
        self.db = None
    
    
    def init(self):
        self.logger.info('Try to open a Mongodb connection to %s:%s' % (self.uri, self.database))
        try:
            # Get a connection. If need, we will use a SSH tunnel
            con_result = mongo_by_ssh_mgr.get_connection(
                self.uri,
                self.logger,
                fsync=False,
                use_ssh=self.use_ssh_tunnel,
                ssh_keyfile=self.ssh_keyfile,
                ssh_user=self.ssh_user,
                ssh_retry=self.use_ssh_retry_failure,
                requestor=self.name,
            )
            self.con = con_result.get_connection()
            self.db = getattr(self.con, self.database)
        except Exception as exp:
            self.logger.error('Error %s:' % exp)
            raise
        self.logger.info('Connection OK')
