#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.

import bson
import pymongo

from component.sla_common import shared_data
from component.sla_error_handler import error_handler
from sla_module_broker import SLAModuleBroker
from sla_module_webui import SLAModuleWebUI

ACCEPTED_BROK_TYPES = ('service_check_result', 'update_service_status', 'update_host_status', 'host_check_result', 'initial_service_status', 'initial_host_status', 'initial_broks_done')

properties = {
    'daemons' : ['broker', 'webui'],
    'type'    : 'sla',
    'external': False,
}


# called by the plugin manager to get a module instance
def get_instance(configuration, module_on, display_info=True, already_archived=False):
    shared_data.set_already_archived(already_archived)
    error_handler.reset()
    
    if not pymongo.has_c():
        raise Exception('Your pymongo lib has not the C extension installed')
    if not bson.has_c():
        raise Exception('Your bson lib has not the C extension installed')
    
    if module_on == 'broker':
        return SLAModuleBroker(configuration, display_info=display_info)
    elif module_on == 'webui':
        return SLAModuleWebUI(configuration, display_info=display_info)
